# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagedDatabasesResult',
    'AwaitableGetManagedDatabasesResult',
    'get_managed_databases',
    'get_managed_databases_output',
]

@pulumi.output_type
class GetManagedDatabasesResult:
    """
    A collection of values returned by getManagedDatabases.
    """
    def __init__(__self__, compartment_id=None, deployment_type=None, external_exadata_infrastructure_id=None, filters=None, id=None, managed_database_collections=None, management_option=None, name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deployment_type and not isinstance(deployment_type, str):
            raise TypeError("Expected argument 'deployment_type' to be a str")
        pulumi.set(__self__, "deployment_type", deployment_type)
        if external_exadata_infrastructure_id and not isinstance(external_exadata_infrastructure_id, str):
            raise TypeError("Expected argument 'external_exadata_infrastructure_id' to be a str")
        pulumi.set(__self__, "external_exadata_infrastructure_id", external_exadata_infrastructure_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if managed_database_collections and not isinstance(managed_database_collections, list):
            raise TypeError("Expected argument 'managed_database_collections' to be a list")
        pulumi.set(__self__, "managed_database_collections", managed_database_collections)
        if management_option and not isinstance(management_option, str):
            raise TypeError("Expected argument 'management_option' to be a str")
        pulumi.set(__self__, "management_option", management_option)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which the Managed Database Group resides.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[str]:
        """
        The infrastructure used to deploy the Oracle Database.
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="externalExadataInfrastructureId")
    def external_exadata_infrastructure_id(self) -> Optional[str]:
        return pulumi.get(self, "external_exadata_infrastructure_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagedDatabasesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Managed Database Group.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managedDatabaseCollections")
    def managed_database_collections(self) -> Sequence['outputs.GetManagedDatabasesManagedDatabaseCollectionResult']:
        """
        The list of managed_database_collection.
        """
        return pulumi.get(self, "managed_database_collections")

    @property
    @pulumi.getter(name="managementOption")
    def management_option(self) -> Optional[str]:
        """
        The management option used when enabling Database Management.
        """
        return pulumi.get(self, "management_option")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Managed Database.
        """
        return pulumi.get(self, "name")


class AwaitableGetManagedDatabasesResult(GetManagedDatabasesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagedDatabasesResult(
            compartment_id=self.compartment_id,
            deployment_type=self.deployment_type,
            external_exadata_infrastructure_id=self.external_exadata_infrastructure_id,
            filters=self.filters,
            id=self.id,
            managed_database_collections=self.managed_database_collections,
            management_option=self.management_option,
            name=self.name)


def get_managed_databases(compartment_id: Optional[str] = None,
                          deployment_type: Optional[str] = None,
                          external_exadata_infrastructure_id: Optional[str] = None,
                          filters: Optional[Sequence[Union['GetManagedDatabasesFilterArgs', 'GetManagedDatabasesFilterArgsDict']]] = None,
                          id: Optional[str] = None,
                          management_option: Optional[str] = None,
                          name: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagedDatabasesResult:
    """
    This data source provides the list of Managed Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the Managed Database for a specific ID or the list of Managed Databases in a specific compartment.
    Managed Databases can be filtered based on the name parameter. Only one of the parameters, ID or name
    should be provided. If neither of these parameters is provided, all the Managed Databases in the compartment
    are listed. Managed Databases can also be filtered based on the deployment type and management option.
    If the deployment type is not specified or if it is `ONPREMISE`, then the management option is not
    considered and Managed Databases with `ADVANCED` management option are listed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases = oci.DatabaseManagement.get_managed_databases(compartment_id=compartment_id,
        deployment_type=managed_database_deployment_type,
        external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
        id=managed_database_id,
        management_option=managed_database_management_option,
        name=managed_database_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str deployment_type: A filter to return Managed Databases of the specified deployment type.
    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    :param str id: The identifier of the resource.
    :param str management_option: A filter to return Managed Databases with the specified management option.
    :param str name: A filter to return only resources that match the entire name.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['deploymentType'] = deployment_type
    __args__['externalExadataInfrastructureId'] = external_exadata_infrastructure_id
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['managementOption'] = management_option
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DatabaseManagement/getManagedDatabases:getManagedDatabases', __args__, opts=opts, typ=GetManagedDatabasesResult).value

    return AwaitableGetManagedDatabasesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deployment_type=pulumi.get(__ret__, 'deployment_type'),
        external_exadata_infrastructure_id=pulumi.get(__ret__, 'external_exadata_infrastructure_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        managed_database_collections=pulumi.get(__ret__, 'managed_database_collections'),
        management_option=pulumi.get(__ret__, 'management_option'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_managed_databases)
def get_managed_databases_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                 deployment_type: Optional[pulumi.Input[Optional[str]]] = None,
                                 external_exadata_infrastructure_id: Optional[pulumi.Input[Optional[str]]] = None,
                                 filters: Optional[pulumi.Input[Optional[Sequence[Union['GetManagedDatabasesFilterArgs', 'GetManagedDatabasesFilterArgsDict']]]]] = None,
                                 id: Optional[pulumi.Input[Optional[str]]] = None,
                                 management_option: Optional[pulumi.Input[Optional[str]]] = None,
                                 name: Optional[pulumi.Input[Optional[str]]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagedDatabasesResult]:
    """
    This data source provides the list of Managed Databases in Oracle Cloud Infrastructure Database Management service.

    Gets the Managed Database for a specific ID or the list of Managed Databases in a specific compartment.
    Managed Databases can be filtered based on the name parameter. Only one of the parameters, ID or name
    should be provided. If neither of these parameters is provided, all the Managed Databases in the compartment
    are listed. Managed Databases can also be filtered based on the deployment type and management option.
    If the deployment type is not specified or if it is `ONPREMISE`, then the management option is not
    considered and Managed Databases with `ADVANCED` management option are listed.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_managed_databases = oci.DatabaseManagement.get_managed_databases(compartment_id=compartment_id,
        deployment_type=managed_database_deployment_type,
        external_exadata_infrastructure_id=test_external_exadata_infrastructure["id"],
        id=managed_database_id,
        management_option=managed_database_management_option,
        name=managed_database_name)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str deployment_type: A filter to return Managed Databases of the specified deployment type.
    :param str external_exadata_infrastructure_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata infrastructure.
    :param str id: The identifier of the resource.
    :param str management_option: A filter to return Managed Databases with the specified management option.
    :param str name: A filter to return only resources that match the entire name.
    """
    ...
