# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetastoresResult',
    'AwaitableGetMetastoresResult',
    'get_metastores',
    'get_metastores_output',
]

@pulumi.output_type
class GetMetastoresResult:
    """
    A collection of values returned by getMetastores.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, metastores=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if metastores and not isinstance(metastores, list):
            raise TypeError("Expected argument 'metastores' to be a list")
        pulumi.set(__self__, "metastores", metastores)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        OCID of the compartment which holds the metastore.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Mutable name of the metastore.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMetastoresFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def metastores(self) -> Sequence['outputs.GetMetastoresMetastoreResult']:
        """
        The list of metastores.
        """
        return pulumi.get(self, "metastores")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the metastore.
        """
        return pulumi.get(self, "state")


class AwaitableGetMetastoresResult(GetMetastoresResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetastoresResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            metastores=self.metastores,
            state=self.state)


def get_metastores(compartment_id: Optional[str] = None,
                   display_name: Optional[str] = None,
                   filters: Optional[Sequence[Union['GetMetastoresFilterArgs', 'GetMetastoresFilterArgsDict']]] = None,
                   state: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetastoresResult:
    """
    This data source provides the list of Metastores in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all metastores in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metastores = oci.DataCatalog.get_metastores(compartment_id=compartment_id,
        display_name=metastore_display_name,
        state=metastore_state)
    ```


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getMetastores:getMetastores', __args__, opts=opts, typ=GetMetastoresResult).value

    return AwaitableGetMetastoresResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        metastores=pulumi.get(__ret__, 'metastores'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_metastores)
def get_metastores_output(compartment_id: Optional[pulumi.Input[str]] = None,
                          display_name: Optional[pulumi.Input[Optional[str]]] = None,
                          filters: Optional[pulumi.Input[Optional[Sequence[Union['GetMetastoresFilterArgs', 'GetMetastoresFilterArgsDict']]]]] = None,
                          state: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetastoresResult]:
    """
    This data source provides the list of Metastores in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all metastores in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_metastores = oci.DataCatalog.get_metastores(compartment_id=compartment_id,
        display_name=metastore_display_name,
        state=metastore_state)
    ```


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    ...
