# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetWorkspaceImportRequestResult',
    'AwaitableGetWorkspaceImportRequestResult',
    'get_workspace_import_request',
    'get_workspace_import_request_output',
]

@pulumi.output_type
class GetWorkspaceImportRequestResult:
    """
    A collection of values returned by getWorkspaceImportRequest.
    """
    def __init__(__self__, are_data_asset_references_included=None, bucket=None, created_by=None, error_messages=None, file_name=None, id=None, import_conflict_resolutions=None, import_request_key=None, imported_objects=None, key=None, name=None, object_key_for_import=None, object_storage_region=None, object_storage_tenancy_id=None, status=None, time_ended_in_millis=None, time_started_in_millis=None, total_imported_object_count=None, workspace_id=None):
        if are_data_asset_references_included and not isinstance(are_data_asset_references_included, bool):
            raise TypeError("Expected argument 'are_data_asset_references_included' to be a bool")
        pulumi.set(__self__, "are_data_asset_references_included", are_data_asset_references_included)
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if error_messages and not isinstance(error_messages, dict):
            raise TypeError("Expected argument 'error_messages' to be a dict")
        pulumi.set(__self__, "error_messages", error_messages)
        if file_name and not isinstance(file_name, str):
            raise TypeError("Expected argument 'file_name' to be a str")
        pulumi.set(__self__, "file_name", file_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if import_conflict_resolutions and not isinstance(import_conflict_resolutions, list):
            raise TypeError("Expected argument 'import_conflict_resolutions' to be a list")
        pulumi.set(__self__, "import_conflict_resolutions", import_conflict_resolutions)
        if import_request_key and not isinstance(import_request_key, str):
            raise TypeError("Expected argument 'import_request_key' to be a str")
        pulumi.set(__self__, "import_request_key", import_request_key)
        if imported_objects and not isinstance(imported_objects, list):
            raise TypeError("Expected argument 'imported_objects' to be a list")
        pulumi.set(__self__, "imported_objects", imported_objects)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if object_key_for_import and not isinstance(object_key_for_import, str):
            raise TypeError("Expected argument 'object_key_for_import' to be a str")
        pulumi.set(__self__, "object_key_for_import", object_key_for_import)
        if object_storage_region and not isinstance(object_storage_region, str):
            raise TypeError("Expected argument 'object_storage_region' to be a str")
        pulumi.set(__self__, "object_storage_region", object_storage_region)
        if object_storage_tenancy_id and not isinstance(object_storage_tenancy_id, str):
            raise TypeError("Expected argument 'object_storage_tenancy_id' to be a str")
        pulumi.set(__self__, "object_storage_tenancy_id", object_storage_tenancy_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_ended_in_millis and not isinstance(time_ended_in_millis, str):
            raise TypeError("Expected argument 'time_ended_in_millis' to be a str")
        pulumi.set(__self__, "time_ended_in_millis", time_ended_in_millis)
        if time_started_in_millis and not isinstance(time_started_in_millis, str):
            raise TypeError("Expected argument 'time_started_in_millis' to be a str")
        pulumi.set(__self__, "time_started_in_millis", time_started_in_millis)
        if total_imported_object_count and not isinstance(total_imported_object_count, int):
            raise TypeError("Expected argument 'total_imported_object_count' to be a int")
        pulumi.set(__self__, "total_imported_object_count", total_imported_object_count)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="areDataAssetReferencesIncluded")
    def are_data_asset_references_included(self) -> bool:
        """
        This field controls if the data asset references will be included during import.
        """
        return pulumi.get(self, "are_data_asset_references_included")

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the Object Storage Bucket where the objects will be imported from
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        Name of the user who initiated import request.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="errorMessages")
    def error_messages(self) -> Mapping[str, str]:
        """
        Contains key of the error
        """
        return pulumi.get(self, "error_messages")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> str:
        """
        Name of the zip file from which objects will be imported.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="importConflictResolutions")
    def import_conflict_resolutions(self) -> Sequence['outputs.GetWorkspaceImportRequestImportConflictResolutionResult']:
        """
        Import Objects Conflict resolution.
        """
        return pulumi.get(self, "import_conflict_resolutions")

    @property
    @pulumi.getter(name="importRequestKey")
    def import_request_key(self) -> str:
        return pulumi.get(self, "import_request_key")

    @property
    @pulumi.getter(name="importedObjects")
    def imported_objects(self) -> Sequence['outputs.GetWorkspaceImportRequestImportedObjectResult']:
        """
        The array of imported object details.
        """
        return pulumi.get(self, "imported_objects")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Import object request key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the import request.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="objectKeyForImport")
    def object_key_for_import(self) -> str:
        """
        Key of the object inside which all the objects will be imported
        """
        return pulumi.get(self, "object_key_for_import")

    @property
    @pulumi.getter(name="objectStorageRegion")
    def object_storage_region(self) -> str:
        """
        Region of the object storage (if using object storage of different region)
        """
        return pulumi.get(self, "object_storage_region")

    @property
    @pulumi.getter(name="objectStorageTenancyId")
    def object_storage_tenancy_id(self) -> str:
        """
        Optional parameter to point to object storage tenancy (if using Object Storage of different tenancy)
        """
        return pulumi.get(self, "object_storage_tenancy_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Import Objects request status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeEndedInMillis")
    def time_ended_in_millis(self) -> str:
        """
        Time at which the request was completely processed.
        """
        return pulumi.get(self, "time_ended_in_millis")

    @property
    @pulumi.getter(name="timeStartedInMillis")
    def time_started_in_millis(self) -> str:
        """
        Time at which the request started getting processed.
        """
        return pulumi.get(self, "time_started_in_millis")

    @property
    @pulumi.getter(name="totalImportedObjectCount")
    def total_imported_object_count(self) -> int:
        """
        Number of objects that are imported.
        """
        return pulumi.get(self, "total_imported_object_count")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceImportRequestResult(GetWorkspaceImportRequestResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceImportRequestResult(
            are_data_asset_references_included=self.are_data_asset_references_included,
            bucket=self.bucket,
            created_by=self.created_by,
            error_messages=self.error_messages,
            file_name=self.file_name,
            id=self.id,
            import_conflict_resolutions=self.import_conflict_resolutions,
            import_request_key=self.import_request_key,
            imported_objects=self.imported_objects,
            key=self.key,
            name=self.name,
            object_key_for_import=self.object_key_for_import,
            object_storage_region=self.object_storage_region,
            object_storage_tenancy_id=self.object_storage_tenancy_id,
            status=self.status,
            time_ended_in_millis=self.time_ended_in_millis,
            time_started_in_millis=self.time_started_in_millis,
            total_imported_object_count=self.total_imported_object_count,
            workspace_id=self.workspace_id)


def get_workspace_import_request(import_request_key: Optional[str] = None,
                                 workspace_id: Optional[str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceImportRequestResult:
    """
    This data source provides details about a specific Workspace Import Request resource in Oracle Cloud Infrastructure Data Integration service.

    This endpoint can be used to get the summary/details of object being imported.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_import_request = oci.DataIntegration.get_workspace_import_request(import_request_key=workspace_import_request_import_request_key,
        workspace_id=test_workspace["id"])
    ```


    :param str import_request_key: The key of the object export object request
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['importRequestKey'] = import_request_key
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceImportRequest:getWorkspaceImportRequest', __args__, opts=opts, typ=GetWorkspaceImportRequestResult).value

    return AwaitableGetWorkspaceImportRequestResult(
        are_data_asset_references_included=pulumi.get(__ret__, 'are_data_asset_references_included'),
        bucket=pulumi.get(__ret__, 'bucket'),
        created_by=pulumi.get(__ret__, 'created_by'),
        error_messages=pulumi.get(__ret__, 'error_messages'),
        file_name=pulumi.get(__ret__, 'file_name'),
        id=pulumi.get(__ret__, 'id'),
        import_conflict_resolutions=pulumi.get(__ret__, 'import_conflict_resolutions'),
        import_request_key=pulumi.get(__ret__, 'import_request_key'),
        imported_objects=pulumi.get(__ret__, 'imported_objects'),
        key=pulumi.get(__ret__, 'key'),
        name=pulumi.get(__ret__, 'name'),
        object_key_for_import=pulumi.get(__ret__, 'object_key_for_import'),
        object_storage_region=pulumi.get(__ret__, 'object_storage_region'),
        object_storage_tenancy_id=pulumi.get(__ret__, 'object_storage_tenancy_id'),
        status=pulumi.get(__ret__, 'status'),
        time_ended_in_millis=pulumi.get(__ret__, 'time_ended_in_millis'),
        time_started_in_millis=pulumi.get(__ret__, 'time_started_in_millis'),
        total_imported_object_count=pulumi.get(__ret__, 'total_imported_object_count'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))


@_utilities.lift_output_func(get_workspace_import_request)
def get_workspace_import_request_output(import_request_key: Optional[pulumi.Input[str]] = None,
                                        workspace_id: Optional[pulumi.Input[str]] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetWorkspaceImportRequestResult]:
    """
    This data source provides details about a specific Workspace Import Request resource in Oracle Cloud Infrastructure Data Integration service.

    This endpoint can be used to get the summary/details of object being imported.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_import_request = oci.DataIntegration.get_workspace_import_request(import_request_key=workspace_import_request_import_request_key,
        workspace_id=test_workspace["id"])
    ```


    :param str import_request_key: The key of the object export object request
    :param str workspace_id: The workspace ID.
    """
    ...
