# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetLibraryMaskingFormatsResult',
    'AwaitableGetLibraryMaskingFormatsResult',
    'get_library_masking_formats',
    'get_library_masking_formats_output',
]

@pulumi.output_type
class GetLibraryMaskingFormatsResult:
    """
    A collection of values returned by getLibraryMaskingFormats.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, display_name=None, filters=None, id=None, library_masking_format_collections=None, library_masking_format_id=None, library_masking_format_source=None, state=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if library_masking_format_collections and not isinstance(library_masking_format_collections, list):
            raise TypeError("Expected argument 'library_masking_format_collections' to be a list")
        pulumi.set(__self__, "library_masking_format_collections", library_masking_format_collections)
        if library_masking_format_id and not isinstance(library_masking_format_id, str):
            raise TypeError("Expected argument 'library_masking_format_id' to be a str")
        pulumi.set(__self__, "library_masking_format_id", library_masking_format_id)
        if library_masking_format_source and not isinstance(library_masking_format_source, str):
            raise TypeError("Expected argument 'library_masking_format_source' to be a str")
        pulumi.set(__self__, "library_masking_format_source", library_masking_format_source)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the library masking format.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the library masking format.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetLibraryMaskingFormatsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="libraryMaskingFormatCollections")
    def library_masking_format_collections(self) -> Sequence['outputs.GetLibraryMaskingFormatsLibraryMaskingFormatCollectionResult']:
        """
        The list of library_masking_format_collection.
        """
        return pulumi.get(self, "library_masking_format_collections")

    @property
    @pulumi.getter(name="libraryMaskingFormatId")
    def library_masking_format_id(self) -> Optional[str]:
        """
        The OCID of the library masking format.
        """
        return pulumi.get(self, "library_masking_format_id")

    @property
    @pulumi.getter(name="libraryMaskingFormatSource")
    def library_masking_format_source(self) -> Optional[str]:
        return pulumi.get(self, "library_masking_format_source")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the library masking format.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetLibraryMaskingFormatsResult(GetLibraryMaskingFormatsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLibraryMaskingFormatsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            library_masking_format_collections=self.library_masking_format_collections,
            library_masking_format_id=self.library_masking_format_id,
            library_masking_format_source=self.library_masking_format_source,
            state=self.state,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_library_masking_formats(access_level: Optional[str] = None,
                                compartment_id: Optional[str] = None,
                                compartment_id_in_subtree: Optional[bool] = None,
                                display_name: Optional[str] = None,
                                filters: Optional[Sequence[Union['GetLibraryMaskingFormatsFilterArgs', 'GetLibraryMaskingFormatsFilterArgsDict']]] = None,
                                library_masking_format_id: Optional[str] = None,
                                library_masking_format_source: Optional[str] = None,
                                state: Optional[str] = None,
                                time_created_greater_than_or_equal_to: Optional[str] = None,
                                time_created_less_than: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLibraryMaskingFormatsResult:
    """
    This data source provides the list of Library Masking Formats in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of library masking formats based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_library_masking_formats = oci.DataSafe.get_library_masking_formats(compartment_id=compartment_id,
        access_level=library_masking_format_access_level,
        compartment_id_in_subtree=library_masking_format_compartment_id_in_subtree,
        display_name=library_masking_format_display_name,
        library_masking_format_id=test_library_masking_format["id"],
        library_masking_format_source=library_masking_format_library_masking_format_source,
        state=library_masking_format_state,
        time_created_greater_than_or_equal_to=library_masking_format_time_created_greater_than_or_equal_to,
        time_created_less_than=library_masking_format_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str library_masking_format_id: A filter to return only the resources that match the specified library masking format OCID.
    :param str library_masking_format_source: A filter to return the library masking format resources based on the value of their source attribute.
    :param str state: A filter to return only the resources that match the specified lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['libraryMaskingFormatId'] = library_masking_format_id
    __args__['libraryMaskingFormatSource'] = library_masking_format_source
    __args__['state'] = state
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getLibraryMaskingFormats:getLibraryMaskingFormats', __args__, opts=opts, typ=GetLibraryMaskingFormatsResult).value

    return AwaitableGetLibraryMaskingFormatsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        library_masking_format_collections=pulumi.get(__ret__, 'library_masking_format_collections'),
        library_masking_format_id=pulumi.get(__ret__, 'library_masking_format_id'),
        library_masking_format_source=pulumi.get(__ret__, 'library_masking_format_source'),
        state=pulumi.get(__ret__, 'state'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))


@_utilities.lift_output_func(get_library_masking_formats)
def get_library_masking_formats_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                       compartment_id: Optional[pulumi.Input[str]] = None,
                                       compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                       display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                       filters: Optional[pulumi.Input[Optional[Sequence[Union['GetLibraryMaskingFormatsFilterArgs', 'GetLibraryMaskingFormatsFilterArgsDict']]]]] = None,
                                       library_masking_format_id: Optional[pulumi.Input[Optional[str]]] = None,
                                       library_masking_format_source: Optional[pulumi.Input[Optional[str]]] = None,
                                       state: Optional[pulumi.Input[Optional[str]]] = None,
                                       time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                       time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetLibraryMaskingFormatsResult]:
    """
    This data source provides the list of Library Masking Formats in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of library masking formats based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_library_masking_formats = oci.DataSafe.get_library_masking_formats(compartment_id=compartment_id,
        access_level=library_masking_format_access_level,
        compartment_id_in_subtree=library_masking_format_compartment_id_in_subtree,
        display_name=library_masking_format_display_name,
        library_masking_format_id=test_library_masking_format["id"],
        library_masking_format_source=library_masking_format_library_masking_format_source,
        state=library_masking_format_state,
        time_created_greater_than_or_equal_to=library_masking_format_time_created_greater_than_or_equal_to,
        time_created_less_than=library_masking_format_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str display_name: A filter to return only resources that match the specified display name.
    :param str library_masking_format_id: A filter to return only the resources that match the specified library masking format OCID.
    :param str library_masking_format_source: A filter to return the library masking format resources based on the value of their source attribute.
    :param str state: A filter to return only the resources that match the specified lifecycle states.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    ...
