# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetMaskingReportResult',
    'AwaitableGetMaskingReportResult',
    'get_masking_report',
    'get_masking_report_output',
]

@pulumi.output_type
class GetMaskingReportResult:
    """
    A collection of values returned by getMaskingReport.
    """
    def __init__(__self__, compartment_id=None, id=None, is_drop_temp_tables_enabled=None, is_redo_logging_enabled=None, is_refresh_stats_enabled=None, masking_policy_id=None, masking_report_id=None, masking_work_request_id=None, parallel_degree=None, recompile=None, state=None, target_id=None, time_created=None, time_masking_finished=None, time_masking_started=None, total_masked_columns=None, total_masked_objects=None, total_masked_schemas=None, total_masked_sensitive_types=None, total_masked_values=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_drop_temp_tables_enabled and not isinstance(is_drop_temp_tables_enabled, bool):
            raise TypeError("Expected argument 'is_drop_temp_tables_enabled' to be a bool")
        pulumi.set(__self__, "is_drop_temp_tables_enabled", is_drop_temp_tables_enabled)
        if is_redo_logging_enabled and not isinstance(is_redo_logging_enabled, bool):
            raise TypeError("Expected argument 'is_redo_logging_enabled' to be a bool")
        pulumi.set(__self__, "is_redo_logging_enabled", is_redo_logging_enabled)
        if is_refresh_stats_enabled and not isinstance(is_refresh_stats_enabled, bool):
            raise TypeError("Expected argument 'is_refresh_stats_enabled' to be a bool")
        pulumi.set(__self__, "is_refresh_stats_enabled", is_refresh_stats_enabled)
        if masking_policy_id and not isinstance(masking_policy_id, str):
            raise TypeError("Expected argument 'masking_policy_id' to be a str")
        pulumi.set(__self__, "masking_policy_id", masking_policy_id)
        if masking_report_id and not isinstance(masking_report_id, str):
            raise TypeError("Expected argument 'masking_report_id' to be a str")
        pulumi.set(__self__, "masking_report_id", masking_report_id)
        if masking_work_request_id and not isinstance(masking_work_request_id, str):
            raise TypeError("Expected argument 'masking_work_request_id' to be a str")
        pulumi.set(__self__, "masking_work_request_id", masking_work_request_id)
        if parallel_degree and not isinstance(parallel_degree, str):
            raise TypeError("Expected argument 'parallel_degree' to be a str")
        pulumi.set(__self__, "parallel_degree", parallel_degree)
        if recompile and not isinstance(recompile, str):
            raise TypeError("Expected argument 'recompile' to be a str")
        pulumi.set(__self__, "recompile", recompile)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_masking_finished and not isinstance(time_masking_finished, str):
            raise TypeError("Expected argument 'time_masking_finished' to be a str")
        pulumi.set(__self__, "time_masking_finished", time_masking_finished)
        if time_masking_started and not isinstance(time_masking_started, str):
            raise TypeError("Expected argument 'time_masking_started' to be a str")
        pulumi.set(__self__, "time_masking_started", time_masking_started)
        if total_masked_columns and not isinstance(total_masked_columns, str):
            raise TypeError("Expected argument 'total_masked_columns' to be a str")
        pulumi.set(__self__, "total_masked_columns", total_masked_columns)
        if total_masked_objects and not isinstance(total_masked_objects, str):
            raise TypeError("Expected argument 'total_masked_objects' to be a str")
        pulumi.set(__self__, "total_masked_objects", total_masked_objects)
        if total_masked_schemas and not isinstance(total_masked_schemas, str):
            raise TypeError("Expected argument 'total_masked_schemas' to be a str")
        pulumi.set(__self__, "total_masked_schemas", total_masked_schemas)
        if total_masked_sensitive_types and not isinstance(total_masked_sensitive_types, str):
            raise TypeError("Expected argument 'total_masked_sensitive_types' to be a str")
        pulumi.set(__self__, "total_masked_sensitive_types", total_masked_sensitive_types)
        if total_masked_values and not isinstance(total_masked_values, str):
            raise TypeError("Expected argument 'total_masked_values' to be a str")
        pulumi.set(__self__, "total_masked_values", total_masked_values)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the masking report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDropTempTablesEnabled")
    def is_drop_temp_tables_enabled(self) -> bool:
        """
        Indicates if the temporary tables created during the masking operation were dropped after masking.
        """
        return pulumi.get(self, "is_drop_temp_tables_enabled")

    @property
    @pulumi.getter(name="isRedoLoggingEnabled")
    def is_redo_logging_enabled(self) -> bool:
        """
        Indicates if redo logging was enabled during the masking operation.
        """
        return pulumi.get(self, "is_redo_logging_enabled")

    @property
    @pulumi.getter(name="isRefreshStatsEnabled")
    def is_refresh_stats_enabled(self) -> bool:
        """
        Indicates if statistics gathering was enabled during the masking operation.
        """
        return pulumi.get(self, "is_refresh_stats_enabled")

    @property
    @pulumi.getter(name="maskingPolicyId")
    def masking_policy_id(self) -> str:
        """
        The OCID of the masking policy used.
        """
        return pulumi.get(self, "masking_policy_id")

    @property
    @pulumi.getter(name="maskingReportId")
    def masking_report_id(self) -> str:
        return pulumi.get(self, "masking_report_id")

    @property
    @pulumi.getter(name="maskingWorkRequestId")
    def masking_work_request_id(self) -> str:
        """
        The OCID of the masking work request that resulted in this masking report.
        """
        return pulumi.get(self, "masking_work_request_id")

    @property
    @pulumi.getter(name="parallelDegree")
    def parallel_degree(self) -> str:
        """
        Indicates if parallel execution was enabled during the masking operation.
        """
        return pulumi.get(self, "parallel_degree")

    @property
    @pulumi.getter
    def recompile(self) -> str:
        """
        Indicates how invalid objects were recompiled post the masking operation.
        """
        return pulumi.get(self, "recompile")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the masking report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> str:
        """
        The OCID of the target database masked.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the masking report was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeMaskingFinished")
    def time_masking_finished(self) -> str:
        """
        The date and time data masking finished, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_finished")

    @property
    @pulumi.getter(name="timeMaskingStarted")
    def time_masking_started(self) -> str:
        """
        The date and time data masking started, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339)
        """
        return pulumi.get(self, "time_masking_started")

    @property
    @pulumi.getter(name="totalMaskedColumns")
    def total_masked_columns(self) -> str:
        """
        The total number of masked columns.
        """
        return pulumi.get(self, "total_masked_columns")

    @property
    @pulumi.getter(name="totalMaskedObjects")
    def total_masked_objects(self) -> str:
        """
        The total number of unique objects (tables and editioning views) that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_objects")

    @property
    @pulumi.getter(name="totalMaskedSchemas")
    def total_masked_schemas(self) -> str:
        """
        The total number of unique schemas that contain the masked columns.
        """
        return pulumi.get(self, "total_masked_schemas")

    @property
    @pulumi.getter(name="totalMaskedSensitiveTypes")
    def total_masked_sensitive_types(self) -> str:
        """
        The total number of unique sensitive types associated with the masked columns.
        """
        return pulumi.get(self, "total_masked_sensitive_types")

    @property
    @pulumi.getter(name="totalMaskedValues")
    def total_masked_values(self) -> str:
        """
        The total number of masked values.
        """
        return pulumi.get(self, "total_masked_values")


class AwaitableGetMaskingReportResult(GetMaskingReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingReportResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_drop_temp_tables_enabled=self.is_drop_temp_tables_enabled,
            is_redo_logging_enabled=self.is_redo_logging_enabled,
            is_refresh_stats_enabled=self.is_refresh_stats_enabled,
            masking_policy_id=self.masking_policy_id,
            masking_report_id=self.masking_report_id,
            masking_work_request_id=self.masking_work_request_id,
            parallel_degree=self.parallel_degree,
            recompile=self.recompile,
            state=self.state,
            target_id=self.target_id,
            time_created=self.time_created,
            time_masking_finished=self.time_masking_finished,
            time_masking_started=self.time_masking_started,
            total_masked_columns=self.total_masked_columns,
            total_masked_objects=self.total_masked_objects,
            total_masked_schemas=self.total_masked_schemas,
            total_masked_sensitive_types=self.total_masked_sensitive_types,
            total_masked_values=self.total_masked_values)


def get_masking_report(masking_report_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingReportResult:
    """
    This data source provides details about a specific Masking Report resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_report = oci.DataSafe.get_masking_report(masking_report_id=test_masking_report_oci_data_safe_masking_report["id"])
    ```


    :param str masking_report_id: The OCID of the masking report.
    """
    __args__ = dict()
    __args__['maskingReportId'] = masking_report_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingReport:getMaskingReport', __args__, opts=opts, typ=GetMaskingReportResult).value

    return AwaitableGetMaskingReportResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_drop_temp_tables_enabled=pulumi.get(__ret__, 'is_drop_temp_tables_enabled'),
        is_redo_logging_enabled=pulumi.get(__ret__, 'is_redo_logging_enabled'),
        is_refresh_stats_enabled=pulumi.get(__ret__, 'is_refresh_stats_enabled'),
        masking_policy_id=pulumi.get(__ret__, 'masking_policy_id'),
        masking_report_id=pulumi.get(__ret__, 'masking_report_id'),
        masking_work_request_id=pulumi.get(__ret__, 'masking_work_request_id'),
        parallel_degree=pulumi.get(__ret__, 'parallel_degree'),
        recompile=pulumi.get(__ret__, 'recompile'),
        state=pulumi.get(__ret__, 'state'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_masking_finished=pulumi.get(__ret__, 'time_masking_finished'),
        time_masking_started=pulumi.get(__ret__, 'time_masking_started'),
        total_masked_columns=pulumi.get(__ret__, 'total_masked_columns'),
        total_masked_objects=pulumi.get(__ret__, 'total_masked_objects'),
        total_masked_schemas=pulumi.get(__ret__, 'total_masked_schemas'),
        total_masked_sensitive_types=pulumi.get(__ret__, 'total_masked_sensitive_types'),
        total_masked_values=pulumi.get(__ret__, 'total_masked_values'))


@_utilities.lift_output_func(get_masking_report)
def get_masking_report_output(masking_report_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaskingReportResult]:
    """
    This data source provides details about a specific Masking Report resource in Oracle Cloud Infrastructure Data Safe service.

    Gets the details of the specified masking report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_report = oci.DataSafe.get_masking_report(masking_report_id=test_masking_report_oci_data_safe_masking_report["id"])
    ```


    :param str masking_report_id: The OCID of the masking report.
    """
    ...
