# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetTargetAlertPolicyAssociationsResult',
    'AwaitableGetTargetAlertPolicyAssociationsResult',
    'get_target_alert_policy_associations',
    'get_target_alert_policy_associations_output',
]

@pulumi.output_type
class GetTargetAlertPolicyAssociationsResult:
    """
    A collection of values returned by getTargetAlertPolicyAssociations.
    """
    def __init__(__self__, access_level=None, alert_policy_id=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, state=None, target_alert_policy_association_collections=None, target_alert_policy_association_id=None, target_id=None, time_created_greater_than_or_equal_to=None, time_created_less_than=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if alert_policy_id and not isinstance(alert_policy_id, str):
            raise TypeError("Expected argument 'alert_policy_id' to be a str")
        pulumi.set(__self__, "alert_policy_id", alert_policy_id)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if target_alert_policy_association_collections and not isinstance(target_alert_policy_association_collections, list):
            raise TypeError("Expected argument 'target_alert_policy_association_collections' to be a list")
        pulumi.set(__self__, "target_alert_policy_association_collections", target_alert_policy_association_collections)
        if target_alert_policy_association_id and not isinstance(target_alert_policy_association_id, str):
            raise TypeError("Expected argument 'target_alert_policy_association_id' to be a str")
        pulumi.set(__self__, "target_alert_policy_association_id", target_alert_policy_association_id)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)
        if time_created_greater_than_or_equal_to and not isinstance(time_created_greater_than_or_equal_to, str):
            raise TypeError("Expected argument 'time_created_greater_than_or_equal_to' to be a str")
        pulumi.set(__self__, "time_created_greater_than_or_equal_to", time_created_greater_than_or_equal_to)
        if time_created_less_than and not isinstance(time_created_less_than, str):
            raise TypeError("Expected argument 'time_created_less_than' to be a str")
        pulumi.set(__self__, "time_created_less_than", time_created_less_than)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="alertPolicyId")
    def alert_policy_id(self) -> Optional[str]:
        return pulumi.get(self, "alert_policy_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the policy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetTargetAlertPolicyAssociationsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the target-alert policy association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetAlertPolicyAssociationCollections")
    def target_alert_policy_association_collections(self) -> Sequence['outputs.GetTargetAlertPolicyAssociationsTargetAlertPolicyAssociationCollectionResult']:
        """
        The list of target_alert_policy_association_collection.
        """
        return pulumi.get(self, "target_alert_policy_association_collections")

    @property
    @pulumi.getter(name="targetAlertPolicyAssociationId")
    def target_alert_policy_association_id(self) -> Optional[str]:
        return pulumi.get(self, "target_alert_policy_association_id")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        """
        The OCID of the target on which alert policy is to be applied.
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCreatedGreaterThanOrEqualTo")
    def time_created_greater_than_or_equal_to(self) -> Optional[str]:
        return pulumi.get(self, "time_created_greater_than_or_equal_to")

    @property
    @pulumi.getter(name="timeCreatedLessThan")
    def time_created_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_created_less_than")


class AwaitableGetTargetAlertPolicyAssociationsResult(GetTargetAlertPolicyAssociationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTargetAlertPolicyAssociationsResult(
            access_level=self.access_level,
            alert_policy_id=self.alert_policy_id,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            state=self.state,
            target_alert_policy_association_collections=self.target_alert_policy_association_collections,
            target_alert_policy_association_id=self.target_alert_policy_association_id,
            target_id=self.target_id,
            time_created_greater_than_or_equal_to=self.time_created_greater_than_or_equal_to,
            time_created_less_than=self.time_created_less_than)


def get_target_alert_policy_associations(access_level: Optional[str] = None,
                                         alert_policy_id: Optional[str] = None,
                                         compartment_id: Optional[str] = None,
                                         compartment_id_in_subtree: Optional[bool] = None,
                                         filters: Optional[Sequence[Union['GetTargetAlertPolicyAssociationsFilterArgs', 'GetTargetAlertPolicyAssociationsFilterArgsDict']]] = None,
                                         state: Optional[str] = None,
                                         target_alert_policy_association_id: Optional[str] = None,
                                         target_id: Optional[str] = None,
                                         time_created_greater_than_or_equal_to: Optional[str] = None,
                                         time_created_less_than: Optional[str] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTargetAlertPolicyAssociationsResult:
    """
    This data source provides the list of Target Alert Policy Associations in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all target-alert policy associations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_alert_policy_associations = oci.DataSafe.get_target_alert_policy_associations(compartment_id=compartment_id,
        access_level=target_alert_policy_association_access_level,
        alert_policy_id=test_alert_policy["id"],
        compartment_id_in_subtree=target_alert_policy_association_compartment_id_in_subtree,
        state=target_alert_policy_association_state,
        target_alert_policy_association_id=test_target_alert_policy_association["id"],
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=target_alert_policy_association_time_created_greater_than_or_equal_to,
        time_created_less_than=target_alert_policy_association_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str alert_policy_id: A filter to return policy by it's OCID.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str state: An optional filter to return only alert policies that have the given life-cycle state.
    :param str target_alert_policy_association_id: A filter to return only items related to a specific target-alert policy association ID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['alertPolicyId'] = alert_policy_id
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['state'] = state
    __args__['targetAlertPolicyAssociationId'] = target_alert_policy_association_id
    __args__['targetId'] = target_id
    __args__['timeCreatedGreaterThanOrEqualTo'] = time_created_greater_than_or_equal_to
    __args__['timeCreatedLessThan'] = time_created_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getTargetAlertPolicyAssociations:getTargetAlertPolicyAssociations', __args__, opts=opts, typ=GetTargetAlertPolicyAssociationsResult).value

    return AwaitableGetTargetAlertPolicyAssociationsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        alert_policy_id=pulumi.get(__ret__, 'alert_policy_id'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        target_alert_policy_association_collections=pulumi.get(__ret__, 'target_alert_policy_association_collections'),
        target_alert_policy_association_id=pulumi.get(__ret__, 'target_alert_policy_association_id'),
        target_id=pulumi.get(__ret__, 'target_id'),
        time_created_greater_than_or_equal_to=pulumi.get(__ret__, 'time_created_greater_than_or_equal_to'),
        time_created_less_than=pulumi.get(__ret__, 'time_created_less_than'))


@_utilities.lift_output_func(get_target_alert_policy_associations)
def get_target_alert_policy_associations_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                                alert_policy_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                compartment_id: Optional[pulumi.Input[str]] = None,
                                                compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                                filters: Optional[pulumi.Input[Optional[Sequence[Union['GetTargetAlertPolicyAssociationsFilterArgs', 'GetTargetAlertPolicyAssociationsFilterArgsDict']]]]] = None,
                                                state: Optional[pulumi.Input[Optional[str]]] = None,
                                                target_alert_policy_association_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                time_created_greater_than_or_equal_to: Optional[pulumi.Input[Optional[str]]] = None,
                                                time_created_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTargetAlertPolicyAssociationsResult]:
    """
    This data source provides the list of Target Alert Policy Associations in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of all target-alert policy associations.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_target_alert_policy_associations = oci.DataSafe.get_target_alert_policy_associations(compartment_id=compartment_id,
        access_level=target_alert_policy_association_access_level,
        alert_policy_id=test_alert_policy["id"],
        compartment_id_in_subtree=target_alert_policy_association_compartment_id_in_subtree,
        state=target_alert_policy_association_state,
        target_alert_policy_association_id=test_target_alert_policy_association["id"],
        target_id=test_target["id"],
        time_created_greater_than_or_equal_to=target_alert_policy_association_time_created_greater_than_or_equal_to,
        time_created_less_than=target_alert_policy_association_time_created_less_than)
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str alert_policy_id: A filter to return policy by it's OCID.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str state: An optional filter to return only alert policies that have the given life-cycle state.
    :param str target_alert_policy_association_id: A filter to return only items related to a specific target-alert policy association ID.
    :param str target_id: A filter to return only items related to a specific target OCID.
    :param str time_created_greater_than_or_equal_to: A filter to return only the resources that were created after the specified date and time, as defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Using TimeCreatedGreaterThanOrEqualToQueryParam parameter retrieves all resources created after that date.
           
           **Example:** 2016-12-19T16:39:57.600Z
    :param str time_created_less_than: Search for resources that were created before a specific date. Specifying this parameter corresponding `timeCreatedLessThan` parameter will retrieve all resources created before the specified created date, in "YYYY-MM-ddThh:mmZ" format with a Z offset, as defined by RFC 3339.
           
           **Example:** 2016-12-19T16:39:57.600Z
    """
    ...
