# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SensitiveDataModelsSensitiveColumnArgs', 'SensitiveDataModelsSensitiveColumn']

@pulumi.input_type
class SensitiveDataModelsSensitiveColumnArgs:
    def __init__(__self__, *,
                 column_name: pulumi.Input[str],
                 object: pulumi.Input[str],
                 schema_name: pulumi.Input[str],
                 sensitive_data_model_id: pulumi.Input[str],
                 app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object_type: Optional[pulumi.Input[str]] = None,
                 parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 relation_type: Optional[pulumi.Input[str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SensitiveDataModelsSensitiveColumn resource.
        :param pulumi.Input[str] column_name: The name of the sensitive column.
        :param pulumi.Input[str] object: The database object that contains the sensitive column.
        :param pulumi.Input[str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] app_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] app_name: The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        :param pulumi.Input[str] data_type: (Updatable) The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parent_column_keys: (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        :param pulumi.Input[str] relation_type: (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        :param pulumi.Input[str] status: (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "column_name", column_name)
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "schema_name", schema_name)
        pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if app_defined_child_column_keys is not None:
            pulumi.set(__self__, "app_defined_child_column_keys", app_defined_child_column_keys)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if db_defined_child_column_keys is not None:
            pulumi.set(__self__, "db_defined_child_column_keys", db_defined_child_column_keys)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if parent_column_keys is not None:
            pulumi.set(__self__, "parent_column_keys", parent_column_keys)
        if relation_type is not None:
            pulumi.set(__self__, "relation_type", relation_type)
        if sensitive_type_id is not None:
            pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Input[str]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Input[str]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Input[str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter(name="appDefinedChildColumnKeys")
    def app_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "app_defined_child_column_keys")

    @app_defined_child_column_keys.setter
    def app_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "app_defined_child_column_keys", value)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The data type of the sensitive column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="dbDefinedChildColumnKeys")
    def db_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "db_defined_child_column_keys")

    @db_defined_child_column_keys.setter
    def db_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_defined_child_column_keys", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_type", value)

    @property
    @pulumi.getter(name="parentColumnKeys")
    def parent_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "parent_column_keys")

    @parent_column_keys.setter
    def parent_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parent_column_keys", value)

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @relation_type.setter
    def relation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relation_type", value)

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @sensitive_type_id.setter
    def sensitive_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_type_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _SensitiveDataModelsSensitiveColumnState:
    def __init__(__self__, *,
                 app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 column_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 column_name: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 estimated_data_value_count: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_type: Optional[pulumi.Input[str]] = None,
                 parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 relation_type: Optional[pulumi.Input[str]] = None,
                 sample_data_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SensitiveDataModelsSensitiveColumn resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] app_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] app_name: The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] column_groups: The composite key groups to which the sensitive column belongs. If the column is part of a composite key, it's assigned a column group. It helps identify and manage referential relationships that involve composite keys.
        :param pulumi.Input[str] column_name: The name of the sensitive column.
        :param pulumi.Input[str] data_type: (Updatable) The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] estimated_data_value_count: The estimated number of data values the column has in the associated database.
        :param pulumi.Input[str] key: The unique key that identifies the sensitive column. It's numeric and unique within a sensitive data model.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the sensitive column.
        :param pulumi.Input[str] object: The database object that contains the sensitive column.
        :param pulumi.Input[str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parent_column_keys: (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        :param pulumi.Input[str] relation_type: (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sample_data_values: Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        :param pulumi.Input[str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        :param pulumi.Input[str] source: The source of the sensitive column. DISCOVERY indicates that the column was added to the sensitive data model using a data discovery job. MANUAL indicates that the column was added manually.
        :param pulumi.Input[str] state: The current state of the sensitive column.
        :param pulumi.Input[str] status: (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was created in the sensitive data model.
        :param pulumi.Input[str] time_updated: The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was last updated in the sensitive data model.
        """
        if app_defined_child_column_keys is not None:
            pulumi.set(__self__, "app_defined_child_column_keys", app_defined_child_column_keys)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if column_groups is not None:
            pulumi.set(__self__, "column_groups", column_groups)
        if column_name is not None:
            pulumi.set(__self__, "column_name", column_name)
        if data_type is not None:
            pulumi.set(__self__, "data_type", data_type)
        if db_defined_child_column_keys is not None:
            pulumi.set(__self__, "db_defined_child_column_keys", db_defined_child_column_keys)
        if estimated_data_value_count is not None:
            pulumi.set(__self__, "estimated_data_value_count", estimated_data_value_count)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if object_type is not None:
            pulumi.set(__self__, "object_type", object_type)
        if parent_column_keys is not None:
            pulumi.set(__self__, "parent_column_keys", parent_column_keys)
        if relation_type is not None:
            pulumi.set(__self__, "relation_type", relation_type)
        if sample_data_values is not None:
            pulumi.set(__self__, "sample_data_values", sample_data_values)
        if schema_name is not None:
            pulumi.set(__self__, "schema_name", schema_name)
        if sensitive_data_model_id is not None:
            pulumi.set(__self__, "sensitive_data_model_id", sensitive_data_model_id)
        if sensitive_type_id is not None:
            pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="appDefinedChildColumnKeys")
    def app_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "app_defined_child_column_keys")

    @app_defined_child_column_keys.setter
    def app_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "app_defined_child_column_keys", value)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The composite key groups to which the sensitive column belongs. If the column is part of a composite key, it's assigned a column group. It helps identify and manage referential relationships that involve composite keys.
        """
        return pulumi.get(self, "column_groups")

    @column_groups.setter
    def column_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "column_groups", value)

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_name")

    @column_name.setter
    def column_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "column_name", value)

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The data type of the sensitive column.
        """
        return pulumi.get(self, "data_type")

    @data_type.setter
    def data_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_type", value)

    @property
    @pulumi.getter(name="dbDefinedChildColumnKeys")
    def db_defined_child_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "db_defined_child_column_keys")

    @db_defined_child_column_keys.setter
    def db_defined_child_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "db_defined_child_column_keys", value)

    @property
    @pulumi.getter(name="estimatedDataValueCount")
    def estimated_data_value_count(self) -> Optional[pulumi.Input[str]]:
        """
        The estimated number of data values the column has in the associated database.
        """
        return pulumi.get(self, "estimated_data_value_count")

    @estimated_data_value_count.setter
    def estimated_data_value_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "estimated_data_value_count", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The unique key that identifies the sensitive column. It's numeric and unique within a sensitive data model.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the sensitive column.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_type")

    @object_type.setter
    def object_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object_type", value)

    @property
    @pulumi.getter(name="parentColumnKeys")
    def parent_column_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "parent_column_keys")

    @parent_column_keys.setter
    def parent_column_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "parent_column_keys", value)

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @relation_type.setter
    def relation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "relation_type", value)

    @property
    @pulumi.getter(name="sampleDataValues")
    def sample_data_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        """
        return pulumi.get(self, "sample_data_values")

    @sample_data_values.setter
    def sample_data_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sample_data_values", value)

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> Optional[pulumi.Input[str]]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_name")

    @schema_name.setter
    def schema_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schema_name", value)

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @sensitive_data_model_id.setter
    def sensitive_data_model_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_data_model_id", value)

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @sensitive_type_id.setter
    def sensitive_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sensitive_type_id", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source of the sensitive column. DISCOVERY indicates that the column was added to the sensitive data model using a data discovery job. MANUAL indicates that the column was added manually.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the sensitive column.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was created in the sensitive data model.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was last updated in the sensitive data model.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class SensitiveDataModelsSensitiveColumn(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 column_name: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_type: Optional[pulumi.Input[str]] = None,
                 parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 relation_type: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Sensitive Data Models Sensitive Column resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive column in the specified sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_models_sensitive_column = oci.data_safe.SensitiveDataModelsSensitiveColumn("test_sensitive_data_models_sensitive_column",
            column_name=sensitive_data_models_sensitive_column_column_name,
            object=sensitive_data_models_sensitive_column_object,
            schema_name=sensitive_data_models_sensitive_column_schema_name,
            sensitive_data_model_id=test_sensitive_data_model["id"],
            app_defined_child_column_keys=sensitive_data_models_sensitive_column_app_defined_child_column_keys,
            app_name=sensitive_data_models_sensitive_column_app_name,
            data_type=sensitive_data_models_sensitive_column_data_type,
            db_defined_child_column_keys=sensitive_data_models_sensitive_column_db_defined_child_column_keys,
            object_type=sensitive_data_models_sensitive_column_object_type,
            parent_column_keys=sensitive_data_models_sensitive_column_parent_column_keys,
            relation_type=sensitive_data_models_sensitive_column_relation_type,
            sensitive_type_id=test_sensitive_type["id"],
            status=sensitive_data_models_sensitive_column_status)
        ```

        ## Import

        SensitiveDataModelsSensitiveColumns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModelsSensitiveColumn:SensitiveDataModelsSensitiveColumn test_sensitive_data_models_sensitive_column "sensitiveDataModels/{sensitiveDataModelId}/sensitiveColumns/{sensitiveColumnKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] app_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] app_name: The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        :param pulumi.Input[str] column_name: The name of the sensitive column.
        :param pulumi.Input[str] data_type: (Updatable) The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] object: The database object that contains the sensitive column.
        :param pulumi.Input[str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parent_column_keys: (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        :param pulumi.Input[str] relation_type: (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        :param pulumi.Input[str] status: (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SensitiveDataModelsSensitiveColumnArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Sensitive Data Models Sensitive Column resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a new sensitive column in the specified sensitive data model.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_sensitive_data_models_sensitive_column = oci.data_safe.SensitiveDataModelsSensitiveColumn("test_sensitive_data_models_sensitive_column",
            column_name=sensitive_data_models_sensitive_column_column_name,
            object=sensitive_data_models_sensitive_column_object,
            schema_name=sensitive_data_models_sensitive_column_schema_name,
            sensitive_data_model_id=test_sensitive_data_model["id"],
            app_defined_child_column_keys=sensitive_data_models_sensitive_column_app_defined_child_column_keys,
            app_name=sensitive_data_models_sensitive_column_app_name,
            data_type=sensitive_data_models_sensitive_column_data_type,
            db_defined_child_column_keys=sensitive_data_models_sensitive_column_db_defined_child_column_keys,
            object_type=sensitive_data_models_sensitive_column_object_type,
            parent_column_keys=sensitive_data_models_sensitive_column_parent_column_keys,
            relation_type=sensitive_data_models_sensitive_column_relation_type,
            sensitive_type_id=test_sensitive_type["id"],
            status=sensitive_data_models_sensitive_column_status)
        ```

        ## Import

        SensitiveDataModelsSensitiveColumns can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/sensitiveDataModelsSensitiveColumn:SensitiveDataModelsSensitiveColumn test_sensitive_data_models_sensitive_column "sensitiveDataModels/{sensitiveDataModelId}/sensitiveColumns/{sensitiveColumnKey}"
        ```

        :param str resource_name: The name of the resource.
        :param SensitiveDataModelsSensitiveColumnArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SensitiveDataModelsSensitiveColumnArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 column_name: Optional[pulumi.Input[str]] = None,
                 data_type: Optional[pulumi.Input[str]] = None,
                 db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 object_type: Optional[pulumi.Input[str]] = None,
                 parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 relation_type: Optional[pulumi.Input[str]] = None,
                 schema_name: Optional[pulumi.Input[str]] = None,
                 sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
                 sensitive_type_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SensitiveDataModelsSensitiveColumnArgs.__new__(SensitiveDataModelsSensitiveColumnArgs)

            __props__.__dict__["app_defined_child_column_keys"] = app_defined_child_column_keys
            __props__.__dict__["app_name"] = app_name
            if column_name is None and not opts.urn:
                raise TypeError("Missing required property 'column_name'")
            __props__.__dict__["column_name"] = column_name
            __props__.__dict__["data_type"] = data_type
            __props__.__dict__["db_defined_child_column_keys"] = db_defined_child_column_keys
            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            __props__.__dict__["object_type"] = object_type
            __props__.__dict__["parent_column_keys"] = parent_column_keys
            __props__.__dict__["relation_type"] = relation_type
            if schema_name is None and not opts.urn:
                raise TypeError("Missing required property 'schema_name'")
            __props__.__dict__["schema_name"] = schema_name
            if sensitive_data_model_id is None and not opts.urn:
                raise TypeError("Missing required property 'sensitive_data_model_id'")
            __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
            __props__.__dict__["sensitive_type_id"] = sensitive_type_id
            __props__.__dict__["status"] = status
            __props__.__dict__["column_groups"] = None
            __props__.__dict__["estimated_data_value_count"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["sample_data_values"] = None
            __props__.__dict__["source"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(SensitiveDataModelsSensitiveColumn, __self__).__init__(
            'oci:DataSafe/sensitiveDataModelsSensitiveColumn:SensitiveDataModelsSensitiveColumn',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            column_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            column_name: Optional[pulumi.Input[str]] = None,
            data_type: Optional[pulumi.Input[str]] = None,
            db_defined_child_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            estimated_data_value_count: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            object: Optional[pulumi.Input[str]] = None,
            object_type: Optional[pulumi.Input[str]] = None,
            parent_column_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            relation_type: Optional[pulumi.Input[str]] = None,
            sample_data_values: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            schema_name: Optional[pulumi.Input[str]] = None,
            sensitive_data_model_id: Optional[pulumi.Input[str]] = None,
            sensitive_type_id: Optional[pulumi.Input[str]] = None,
            source: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'SensitiveDataModelsSensitiveColumn':
        """
        Get an existing SensitiveDataModelsSensitiveColumn resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] app_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] app_name: The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] column_groups: The composite key groups to which the sensitive column belongs. If the column is part of a composite key, it's assigned a column group. It helps identify and manage referential relationships that involve composite keys.
        :param pulumi.Input[str] column_name: The name of the sensitive column.
        :param pulumi.Input[str] data_type: (Updatable) The data type of the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] db_defined_child_column_keys: (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        :param pulumi.Input[str] estimated_data_value_count: The estimated number of data values the column has in the associated database.
        :param pulumi.Input[str] key: The unique key that identifies the sensitive column. It's numeric and unique within a sensitive data model.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the sensitive column.
        :param pulumi.Input[str] object: The database object that contains the sensitive column.
        :param pulumi.Input[str] object_type: The type of the database object that contains the sensitive column.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] parent_column_keys: (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        :param pulumi.Input[str] relation_type: (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sample_data_values: Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        :param pulumi.Input[str] schema_name: The database schema that contains the sensitive column.
        :param pulumi.Input[str] sensitive_data_model_id: The OCID of the sensitive data model.
        :param pulumi.Input[str] sensitive_type_id: (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        :param pulumi.Input[str] source: The source of the sensitive column. DISCOVERY indicates that the column was added to the sensitive data model using a data discovery job. MANUAL indicates that the column was added manually.
        :param pulumi.Input[str] state: The current state of the sensitive column.
        :param pulumi.Input[str] status: (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was created in the sensitive data model.
        :param pulumi.Input[str] time_updated: The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was last updated in the sensitive data model.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SensitiveDataModelsSensitiveColumnState.__new__(_SensitiveDataModelsSensitiveColumnState)

        __props__.__dict__["app_defined_child_column_keys"] = app_defined_child_column_keys
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["column_groups"] = column_groups
        __props__.__dict__["column_name"] = column_name
        __props__.__dict__["data_type"] = data_type
        __props__.__dict__["db_defined_child_column_keys"] = db_defined_child_column_keys
        __props__.__dict__["estimated_data_value_count"] = estimated_data_value_count
        __props__.__dict__["key"] = key
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["object"] = object
        __props__.__dict__["object_type"] = object_type
        __props__.__dict__["parent_column_keys"] = parent_column_keys
        __props__.__dict__["relation_type"] = relation_type
        __props__.__dict__["sample_data_values"] = sample_data_values
        __props__.__dict__["schema_name"] = schema_name
        __props__.__dict__["sensitive_data_model_id"] = sensitive_data_model_id
        __props__.__dict__["sensitive_type_id"] = sensitive_type_id
        __props__.__dict__["source"] = source
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return SensitiveDataModelsSensitiveColumn(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="appDefinedChildColumnKeys")
    def app_defined_child_column_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Unique keys identifying the columns that are application-level (non-dictionary) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "app_defined_child_column_keys")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        The name of the application associated with the sensitive column. It's useful when the application name is different from the schema name. Otherwise, it can be ignored. If this attribute is not provided, it's automatically populated with the value provided for the schemaName attribute.
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="columnGroups")
    def column_groups(self) -> pulumi.Output[Sequence[str]]:
        """
        The composite key groups to which the sensitive column belongs. If the column is part of a composite key, it's assigned a column group. It helps identify and manage referential relationships that involve composite keys.
        """
        return pulumi.get(self, "column_groups")

    @property
    @pulumi.getter(name="columnName")
    def column_name(self) -> pulumi.Output[str]:
        """
        The name of the sensitive column.
        """
        return pulumi.get(self, "column_name")

    @property
    @pulumi.getter(name="dataType")
    def data_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The data type of the sensitive column.
        """
        return pulumi.get(self, "data_type")

    @property
    @pulumi.getter(name="dbDefinedChildColumnKeys")
    def db_defined_child_column_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Unique keys identifying the columns that are database-level (dictionary-defined) children of the sensitive column. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the child columns must be added to the sensitive data model before their keys can be specified here. If this attribute is provided, the parentColumnKeys and relationType attributes of the child columns are automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "db_defined_child_column_keys")

    @property
    @pulumi.getter(name="estimatedDataValueCount")
    def estimated_data_value_count(self) -> pulumi.Output[str]:
        """
        The estimated number of data values the column has in the associated database.
        """
        return pulumi.get(self, "estimated_data_value_count")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The unique key that identifies the sensitive column. It's numeric and unique within a sensitive data model.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the sensitive column.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[str]:
        """
        The database object that contains the sensitive column.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter(name="objectType")
    def object_type(self) -> pulumi.Output[str]:
        """
        The type of the database object that contains the sensitive column.
        """
        return pulumi.get(self, "object_type")

    @property
    @pulumi.getter(name="parentColumnKeys")
    def parent_column_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Unique keys identifying the columns that are parents of the sensitive column. At present, it accepts only one parent column key. This attribute can be used to establish relationship between columns in a sensitive data model. Note that the parent column must be added to the sensitive data model before its key can be specified here. If this attribute is provided, the appDefinedChildColumnKeys or dbDefinedChildColumnKeys attribute of the parent column is automatically updated to reflect the relationship.
        """
        return pulumi.get(self, "parent_column_keys")

    @property
    @pulumi.getter(name="relationType")
    def relation_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of referential relationship the sensitive column has with its parent. NONE indicates that the sensitive column does not have a parent. DB_DEFINED indicates that the relationship is defined in the database dictionary. APP_DEFINED indicates that the relationship is defined at the application level and not in the database dictionary.
        """
        return pulumi.get(self, "relation_type")

    @property
    @pulumi.getter(name="sampleDataValues")
    def sample_data_values(self) -> pulumi.Output[Sequence[str]]:
        """
        Original data values collected for the sensitive column from the associated database. Sample data helps review the column and ensure that it actually contains sensitive data. Note that sample data is retrieved by a data discovery job only if the isSampleDataCollectionEnabled attribute is set to true. At present, only one data value is collected per sensitive column.
        """
        return pulumi.get(self, "sample_data_values")

    @property
    @pulumi.getter(name="schemaName")
    def schema_name(self) -> pulumi.Output[str]:
        """
        The database schema that contains the sensitive column.
        """
        return pulumi.get(self, "schema_name")

    @property
    @pulumi.getter(name="sensitiveDataModelId")
    def sensitive_data_model_id(self) -> pulumi.Output[str]:
        """
        The OCID of the sensitive data model.
        """
        return pulumi.get(self, "sensitive_data_model_id")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the sensitive type to be associated with the sensitive column.
        """
        return pulumi.get(self, "sensitive_type_id")

    @property
    @pulumi.getter
    def source(self) -> pulumi.Output[str]:
        """
        The source of the sensitive column. DISCOVERY indicates that the column was added to the sensitive data model using a data discovery job. MANUAL indicates that the column was added manually.
        """
        return pulumi.get(self, "source")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the sensitive column.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) The status of the sensitive column. VALID means the column is considered sensitive. INVALID means the column is not considered sensitive. Tracking invalid columns in a sensitive data model helps ensure that an incremental data discovery job does not identify these columns as sensitive. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was created in the sensitive data model.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339), the sensitive column was last updated in the sensitive data model.
        """
        return pulumi.get(self, "time_updated")

