# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetModelResult',
    'AwaitableGetModelResult',
    'get_model',
    'get_model_output',
]

@pulumi.output_type
class GetModelResult:
    """
    A collection of values returned by getModel.
    """
    def __init__(__self__, artifact_content_disposition=None, artifact_content_length=None, artifact_content_md5=None, artifact_last_modified=None, compartment_id=None, created_by=None, custom_metadata_lists=None, defined_metadata_lists=None, defined_tags=None, description=None, display_name=None, empty_model=None, freeform_tags=None, id=None, input_schema=None, model_artifact=None, model_id=None, output_schema=None, project_id=None, state=None, time_created=None):
        if artifact_content_disposition and not isinstance(artifact_content_disposition, str):
            raise TypeError("Expected argument 'artifact_content_disposition' to be a str")
        pulumi.set(__self__, "artifact_content_disposition", artifact_content_disposition)
        if artifact_content_length and not isinstance(artifact_content_length, str):
            raise TypeError("Expected argument 'artifact_content_length' to be a str")
        pulumi.set(__self__, "artifact_content_length", artifact_content_length)
        if artifact_content_md5 and not isinstance(artifact_content_md5, str):
            raise TypeError("Expected argument 'artifact_content_md5' to be a str")
        pulumi.set(__self__, "artifact_content_md5", artifact_content_md5)
        if artifact_last_modified and not isinstance(artifact_last_modified, str):
            raise TypeError("Expected argument 'artifact_last_modified' to be a str")
        pulumi.set(__self__, "artifact_last_modified", artifact_last_modified)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_by and not isinstance(created_by, str):
            raise TypeError("Expected argument 'created_by' to be a str")
        pulumi.set(__self__, "created_by", created_by)
        if custom_metadata_lists and not isinstance(custom_metadata_lists, list):
            raise TypeError("Expected argument 'custom_metadata_lists' to be a list")
        pulumi.set(__self__, "custom_metadata_lists", custom_metadata_lists)
        if defined_metadata_lists and not isinstance(defined_metadata_lists, list):
            raise TypeError("Expected argument 'defined_metadata_lists' to be a list")
        pulumi.set(__self__, "defined_metadata_lists", defined_metadata_lists)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if empty_model and not isinstance(empty_model, bool):
            raise TypeError("Expected argument 'empty_model' to be a bool")
        pulumi.set(__self__, "empty_model", empty_model)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if input_schema and not isinstance(input_schema, str):
            raise TypeError("Expected argument 'input_schema' to be a str")
        pulumi.set(__self__, "input_schema", input_schema)
        if model_artifact and not isinstance(model_artifact, str):
            raise TypeError("Expected argument 'model_artifact' to be a str")
        pulumi.set(__self__, "model_artifact", model_artifact)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if output_schema and not isinstance(output_schema, str):
            raise TypeError("Expected argument 'output_schema' to be a str")
        pulumi.set(__self__, "output_schema", output_schema)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="artifactContentDisposition")
    def artifact_content_disposition(self) -> str:
        return pulumi.get(self, "artifact_content_disposition")

    @property
    @pulumi.getter(name="artifactContentLength")
    def artifact_content_length(self) -> str:
        return pulumi.get(self, "artifact_content_length")

    @property
    @pulumi.getter(name="artifactContentMd5")
    def artifact_content_md5(self) -> str:
        return pulumi.get(self, "artifact_content_md5")

    @property
    @pulumi.getter(name="artifactLastModified")
    def artifact_last_modified(self) -> str:
        return pulumi.get(self, "artifact_last_modified")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model's compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user who created the model.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="customMetadataLists")
    def custom_metadata_lists(self) -> Sequence['outputs.GetModelCustomMetadataListResult']:
        """
        An array of custom metadata details for the model.
        """
        return pulumi.get(self, "custom_metadata_lists")

    @property
    @pulumi.getter(name="definedMetadataLists")
    def defined_metadata_lists(self) -> Sequence['outputs.GetModelDefinedMetadataListResult']:
        """
        An array of defined metadata details for the model.
        """
        return pulumi.get(self, "defined_metadata_lists")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A short description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly display name for the resource. It does not have to be unique and can be modified. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="emptyModel")
    def empty_model(self) -> bool:
        return pulumi.get(self, "empty_model")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="inputSchema")
    def input_schema(self) -> str:
        """
        Input schema file content in String format
        """
        return pulumi.get(self, "input_schema")

    @property
    @pulumi.getter(name="modelArtifact")
    def model_artifact(self) -> str:
        return pulumi.get(self, "model_artifact")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="outputSchema")
    def output_schema(self) -> str:
        """
        Output schema file content in String format
        """
        return pulumi.get(self, "output_schema")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the project associated with the model.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the resource was created in the timestamp format defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: 2019-08-25T21:10:29.41Z
        """
        return pulumi.get(self, "time_created")


class AwaitableGetModelResult(GetModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelResult(
            artifact_content_disposition=self.artifact_content_disposition,
            artifact_content_length=self.artifact_content_length,
            artifact_content_md5=self.artifact_content_md5,
            artifact_last_modified=self.artifact_last_modified,
            compartment_id=self.compartment_id,
            created_by=self.created_by,
            custom_metadata_lists=self.custom_metadata_lists,
            defined_metadata_lists=self.defined_metadata_lists,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            empty_model=self.empty_model,
            freeform_tags=self.freeform_tags,
            id=self.id,
            input_schema=self.input_schema,
            model_artifact=self.model_artifact,
            model_id=self.model_id,
            output_schema=self.output_schema,
            project_id=self.project_id,
            state=self.state,
            time_created=self.time_created)


def get_model(model_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelResult:
    """
    This data source provides details about a specific Model resource in Oracle Cloud Infrastructure Data Science service.

    Gets the specified model's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model = oci.DataScience.get_model(model_id=test_model_oci_datascience_model["id"])
    ```


    :param str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
    """
    __args__ = dict()
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataScience/getModel:getModel', __args__, opts=opts, typ=GetModelResult).value

    return AwaitableGetModelResult(
        artifact_content_disposition=pulumi.get(__ret__, 'artifact_content_disposition'),
        artifact_content_length=pulumi.get(__ret__, 'artifact_content_length'),
        artifact_content_md5=pulumi.get(__ret__, 'artifact_content_md5'),
        artifact_last_modified=pulumi.get(__ret__, 'artifact_last_modified'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_by=pulumi.get(__ret__, 'created_by'),
        custom_metadata_lists=pulumi.get(__ret__, 'custom_metadata_lists'),
        defined_metadata_lists=pulumi.get(__ret__, 'defined_metadata_lists'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        empty_model=pulumi.get(__ret__, 'empty_model'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        input_schema=pulumi.get(__ret__, 'input_schema'),
        model_artifact=pulumi.get(__ret__, 'model_artifact'),
        model_id=pulumi.get(__ret__, 'model_id'),
        output_schema=pulumi.get(__ret__, 'output_schema'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_model)
def get_model_output(model_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetModelResult]:
    """
    This data source provides details about a specific Model resource in Oracle Cloud Infrastructure Data Science service.

    Gets the specified model's information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model = oci.DataScience.get_model(model_id=test_model_oci_datascience_model["id"])
    ```


    :param str model_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the model.
    """
    ...
