# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDelegatedResourceAccessRequestsResult',
    'AwaitableGetDelegatedResourceAccessRequestsResult',
    'get_delegated_resource_access_requests',
    'get_delegated_resource_access_requests_output',
]

@pulumi.output_type
class GetDelegatedResourceAccessRequestsResult:
    """
    A collection of values returned by getDelegatedResourceAccessRequests.
    """
    def __init__(__self__, compartment_id=None, delegated_resource_access_request_summary_collections=None, delegation_control_id=None, filters=None, id=None, request_status=None, resource_id=None, state=None, time_end=None, time_start=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if delegated_resource_access_request_summary_collections and not isinstance(delegated_resource_access_request_summary_collections, list):
            raise TypeError("Expected argument 'delegated_resource_access_request_summary_collections' to be a list")
        pulumi.set(__self__, "delegated_resource_access_request_summary_collections", delegated_resource_access_request_summary_collections)
        if delegation_control_id and not isinstance(delegation_control_id, str):
            raise TypeError("Expected argument 'delegation_control_id' to be a str")
        pulumi.set(__self__, "delegation_control_id", delegation_control_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if request_status and not isinstance(request_status, str):
            raise TypeError("Expected argument 'request_status' to be a str")
        pulumi.set(__self__, "request_status", request_status)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment that contains the Delegated Resource Access Request.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="delegatedResourceAccessRequestSummaryCollections")
    def delegated_resource_access_request_summary_collections(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionResult']:
        """
        The list of delegated_resource_access_request_summary_collection.
        """
        return pulumi.get(self, "delegated_resource_access_request_summary_collections")

    @property
    @pulumi.getter(name="delegationControlId")
    def delegation_control_id(self) -> Optional[str]:
        """
        The OCID of the Delegation Control governing the target resource.
        """
        return pulumi.get(self, "delegation_control_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDelegatedResourceAccessRequestsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> Optional[str]:
        """
        The current status of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "request_status")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The OCID of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        return pulumi.get(self, "time_start")


class AwaitableGetDelegatedResourceAccessRequestsResult(GetDelegatedResourceAccessRequestsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegatedResourceAccessRequestsResult(
            compartment_id=self.compartment_id,
            delegated_resource_access_request_summary_collections=self.delegated_resource_access_request_summary_collections,
            delegation_control_id=self.delegation_control_id,
            filters=self.filters,
            id=self.id,
            request_status=self.request_status,
            resource_id=self.resource_id,
            state=self.state,
            time_end=self.time_end,
            time_start=self.time_start)


def get_delegated_resource_access_requests(compartment_id: Optional[str] = None,
                                           delegation_control_id: Optional[str] = None,
                                           filters: Optional[Sequence[Union['GetDelegatedResourceAccessRequestsFilterArgs', 'GetDelegatedResourceAccessRequestsFilterArgsDict']]] = None,
                                           request_status: Optional[str] = None,
                                           resource_id: Optional[str] = None,
                                           state: Optional[str] = None,
                                           time_end: Optional[str] = None,
                                           time_start: Optional[str] = None,
                                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegatedResourceAccessRequestsResult:
    """
    This data source provides the list of Delegated Resource Access Requests in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists all Delegated Resource Access Requests in the compartment. Note that only one of lifecycleState or requestStatus query parameter can be used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_requests = oci.DelegateAccessControl.get_delegated_resource_access_requests(compartment_id=compartment_id,
        delegation_control_id=test_delegation_control["id"],
        request_status=delegated_resource_access_request_request_status,
        resource_id=test_resource["id"],
        state=delegated_resource_access_request_state,
        time_end=delegated_resource_access_request_time_end,
        time_start=delegated_resource_access_request_time_start)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str delegation_control_id: unique Delegation Control identifier
    :param str request_status: A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
    :param str resource_id: A filter to return only Delegated Resource Access Requests for the given resource identifier.
    :param str state: A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
    :param str time_end: Query end time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.
    :param str time_start: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['delegationControlId'] = delegation_control_id
    __args__['filters'] = filters
    __args__['requestStatus'] = request_status
    __args__['resourceId'] = resource_id
    __args__['state'] = state
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getDelegatedResourceAccessRequests:getDelegatedResourceAccessRequests', __args__, opts=opts, typ=GetDelegatedResourceAccessRequestsResult).value

    return AwaitableGetDelegatedResourceAccessRequestsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        delegated_resource_access_request_summary_collections=pulumi.get(__ret__, 'delegated_resource_access_request_summary_collections'),
        delegation_control_id=pulumi.get(__ret__, 'delegation_control_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        request_status=pulumi.get(__ret__, 'request_status'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        state=pulumi.get(__ret__, 'state'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_delegated_resource_access_requests)
def get_delegated_resource_access_requests_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                                  delegation_control_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                  filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDelegatedResourceAccessRequestsFilterArgs', 'GetDelegatedResourceAccessRequestsFilterArgsDict']]]]] = None,
                                                  request_status: Optional[pulumi.Input[Optional[str]]] = None,
                                                  resource_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                  state: Optional[pulumi.Input[Optional[str]]] = None,
                                                  time_end: Optional[pulumi.Input[Optional[str]]] = None,
                                                  time_start: Optional[pulumi.Input[Optional[str]]] = None,
                                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelegatedResourceAccessRequestsResult]:
    """
    This data source provides the list of Delegated Resource Access Requests in Oracle Cloud Infrastructure Delegate Access Control service.

    Lists all Delegated Resource Access Requests in the compartment. Note that only one of lifecycleState or requestStatus query parameter can be used.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegated_resource_access_requests = oci.DelegateAccessControl.get_delegated_resource_access_requests(compartment_id=compartment_id,
        delegation_control_id=test_delegation_control["id"],
        request_status=delegated_resource_access_request_request_status,
        resource_id=test_resource["id"],
        state=delegated_resource_access_request_state,
        time_end=delegated_resource_access_request_time_end,
        time_start=delegated_resource_access_request_time_start)
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str delegation_control_id: unique Delegation Control identifier
    :param str request_status: A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
    :param str resource_id: A filter to return only Delegated Resource Access Requests for the given resource identifier.
    :param str state: A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
    :param str time_end: Query end time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.
    :param str time_start: Query start time in UTC in ISO 8601 format(inclusive). Example 2019-10-30T00:00:00Z (yyyy-MM-ddThh:mm:ssZ). timeIntervalStart and timeIntervalEnd parameters cannot be used together.
    """
    ...
