# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDelegationControlResourcesResult',
    'AwaitableGetDelegationControlResourcesResult',
    'get_delegation_control_resources',
    'get_delegation_control_resources_output',
]

@pulumi.output_type
class GetDelegationControlResourcesResult:
    """
    A collection of values returned by getDelegationControlResources.
    """
    def __init__(__self__, delegation_control_id=None, delegation_control_resource_collections=None, filters=None, id=None):
        if delegation_control_id and not isinstance(delegation_control_id, str):
            raise TypeError("Expected argument 'delegation_control_id' to be a str")
        pulumi.set(__self__, "delegation_control_id", delegation_control_id)
        if delegation_control_resource_collections and not isinstance(delegation_control_resource_collections, list):
            raise TypeError("Expected argument 'delegation_control_resource_collections' to be a list")
        pulumi.set(__self__, "delegation_control_resource_collections", delegation_control_resource_collections)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="delegationControlId")
    def delegation_control_id(self) -> str:
        return pulumi.get(self, "delegation_control_id")

    @property
    @pulumi.getter(name="delegationControlResourceCollections")
    def delegation_control_resource_collections(self) -> Sequence['outputs.GetDelegationControlResourcesDelegationControlResourceCollectionResult']:
        """
        The list of delegation_control_resource_collection.
        """
        return pulumi.get(self, "delegation_control_resource_collections")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDelegationControlResourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDelegationControlResourcesResult(GetDelegationControlResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDelegationControlResourcesResult(
            delegation_control_id=self.delegation_control_id,
            delegation_control_resource_collections=self.delegation_control_resource_collections,
            filters=self.filters,
            id=self.id)


def get_delegation_control_resources(delegation_control_id: Optional[str] = None,
                                     filters: Optional[Sequence[Union['GetDelegationControlResourcesFilterArgs', 'GetDelegationControlResourcesFilterArgsDict']]] = None,
                                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDelegationControlResourcesResult:
    """
    This data source provides the list of Delegation Control Resources in Oracle Cloud Infrastructure Delegate Access Control service.

    Returns a list of resources associated with the Delegation Control.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegation_control_resources = oci.DelegateAccessControl.get_delegation_control_resources(delegation_control_id=test_delegation_control["id"])
    ```


    :param str delegation_control_id: unique Delegation Control identifier
    """
    __args__ = dict()
    __args__['delegationControlId'] = delegation_control_id
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DelegateAccessControl/getDelegationControlResources:getDelegationControlResources', __args__, opts=opts, typ=GetDelegationControlResourcesResult).value

    return AwaitableGetDelegationControlResourcesResult(
        delegation_control_id=pulumi.get(__ret__, 'delegation_control_id'),
        delegation_control_resource_collections=pulumi.get(__ret__, 'delegation_control_resource_collections'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_delegation_control_resources)
def get_delegation_control_resources_output(delegation_control_id: Optional[pulumi.Input[str]] = None,
                                            filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDelegationControlResourcesFilterArgs', 'GetDelegationControlResourcesFilterArgsDict']]]]] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDelegationControlResourcesResult]:
    """
    This data source provides the list of Delegation Control Resources in Oracle Cloud Infrastructure Delegate Access Control service.

    Returns a list of resources associated with the Delegation Control.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_delegation_control_resources = oci.DelegateAccessControl.get_delegation_control_resources(delegation_control_id=test_delegation_control["id"])
    ```


    :param str delegation_control_id: unique Delegation Control identifier
    """
    ...
