# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDrProtectionGroupsResult',
    'AwaitableGetDrProtectionGroupsResult',
    'get_dr_protection_groups',
    'get_dr_protection_groups_output',
]

@pulumi.output_type
class GetDrProtectionGroupsResult:
    """
    A collection of values returned by getDrProtectionGroups.
    """
    def __init__(__self__, compartment_id=None, display_name=None, dr_protection_group_collections=None, dr_protection_group_id=None, filters=None, id=None, lifecycle_sub_state=None, role=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dr_protection_group_collections and not isinstance(dr_protection_group_collections, list):
            raise TypeError("Expected argument 'dr_protection_group_collections' to be a list")
        pulumi.set(__self__, "dr_protection_group_collections", dr_protection_group_collections)
        if dr_protection_group_id and not isinstance(dr_protection_group_id, str):
            raise TypeError("Expected argument 'dr_protection_group_id' to be a str")
        pulumi.set(__self__, "dr_protection_group_id", dr_protection_group_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_sub_state and not isinstance(lifecycle_sub_state, str):
            raise TypeError("Expected argument 'lifecycle_sub_state' to be a str")
        pulumi.set(__self__, "lifecycle_sub_state", lifecycle_sub_state)
        if role and not isinstance(role, str):
            raise TypeError("Expected argument 'role' to be a str")
        pulumi.set(__self__, "role", role)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the DR protection group.  Example: `ocid1.compartment.oc1..uniqueID`
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The display name of the DR protection group.  Example: `EBS PHX Group`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="drProtectionGroupCollections")
    def dr_protection_group_collections(self) -> Sequence['outputs.GetDrProtectionGroupsDrProtectionGroupCollectionResult']:
        """
        The list of dr_protection_group_collection.
        """
        return pulumi.get(self, "dr_protection_group_collections")

    @property
    @pulumi.getter(name="drProtectionGroupId")
    def dr_protection_group_id(self) -> Optional[str]:
        return pulumi.get(self, "dr_protection_group_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDrProtectionGroupsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleSubState")
    def lifecycle_sub_state(self) -> Optional[str]:
        """
        The current sub-state of the DR protection group.
        """
        return pulumi.get(self, "lifecycle_sub_state")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        The role of the DR protection group.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the DR protection group.
        """
        return pulumi.get(self, "state")


class AwaitableGetDrProtectionGroupsResult(GetDrProtectionGroupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDrProtectionGroupsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            dr_protection_group_collections=self.dr_protection_group_collections,
            dr_protection_group_id=self.dr_protection_group_id,
            filters=self.filters,
            id=self.id,
            lifecycle_sub_state=self.lifecycle_sub_state,
            role=self.role,
            state=self.state)


def get_dr_protection_groups(compartment_id: Optional[str] = None,
                             display_name: Optional[str] = None,
                             dr_protection_group_id: Optional[str] = None,
                             filters: Optional[Sequence[Union['GetDrProtectionGroupsFilterArgs', 'GetDrProtectionGroupsFilterArgsDict']]] = None,
                             lifecycle_sub_state: Optional[str] = None,
                             role: Optional[str] = None,
                             state: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDrProtectionGroupsResult:
    """
    This data source provides the list of Dr Protection Groups in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR protection groups in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_protection_groups = oci.DisasterRecovery.get_dr_protection_groups(compartment_id=compartment_id,
        display_name=dr_protection_group_display_name,
        dr_protection_group_id=test_dr_protection_group["id"],
        lifecycle_sub_state=dr_protection_group_lifecycle_sub_state,
        role=dr_protection_group_role,
        state=dr_protection_group_state)
    ```


    :param str compartment_id: The ID (OCID) of the compartment in which to list resources.  Example: `ocid1.compartment.oc1..uniqueID`
    :param str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param str dr_protection_group_id: The OCID of the DR protection group. Optional query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param str lifecycle_sub_state: A filter to return only DR protection groups that match the given lifecycle sub-state.
    :param str role: The DR protection group Role.
    :param str state: A filter to return only DR protection groups that match the given lifecycle state.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['drProtectionGroupId'] = dr_protection_group_id
    __args__['filters'] = filters
    __args__['lifecycleSubState'] = lifecycle_sub_state
    __args__['role'] = role
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DisasterRecovery/getDrProtectionGroups:getDrProtectionGroups', __args__, opts=opts, typ=GetDrProtectionGroupsResult).value

    return AwaitableGetDrProtectionGroupsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dr_protection_group_collections=pulumi.get(__ret__, 'dr_protection_group_collections'),
        dr_protection_group_id=pulumi.get(__ret__, 'dr_protection_group_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_sub_state=pulumi.get(__ret__, 'lifecycle_sub_state'),
        role=pulumi.get(__ret__, 'role'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_dr_protection_groups)
def get_dr_protection_groups_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                    display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                    dr_protection_group_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDrProtectionGroupsFilterArgs', 'GetDrProtectionGroupsFilterArgsDict']]]]] = None,
                                    lifecycle_sub_state: Optional[pulumi.Input[Optional[str]]] = None,
                                    role: Optional[pulumi.Input[Optional[str]]] = None,
                                    state: Optional[pulumi.Input[Optional[str]]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDrProtectionGroupsResult]:
    """
    This data source provides the list of Dr Protection Groups in Oracle Cloud Infrastructure Disaster Recovery service.

    Get a summary list of all DR protection groups in a compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dr_protection_groups = oci.DisasterRecovery.get_dr_protection_groups(compartment_id=compartment_id,
        display_name=dr_protection_group_display_name,
        dr_protection_group_id=test_dr_protection_group["id"],
        lifecycle_sub_state=dr_protection_group_lifecycle_sub_state,
        role=dr_protection_group_role,
        state=dr_protection_group_state)
    ```


    :param str compartment_id: The ID (OCID) of the compartment in which to list resources.  Example: `ocid1.compartment.oc1..uniqueID`
    :param str display_name: A filter to return only resources that match the given display name.  Example: `MyResourceDisplayName`
    :param str dr_protection_group_id: The OCID of the DR protection group. Optional query param.  Example: `ocid1.drprotectiongroup.oc1..uniqueID`
    :param str lifecycle_sub_state: A filter to return only DR protection groups that match the given lifecycle sub-state.
    :param str role: The DR protection group Role.
    :param str state: A filter to return only DR protection groups that match the given lifecycle state.
    """
    ...
