# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetModelResult',
    'AwaitableGetModelResult',
    'get_model',
    'get_model_output',
]

@pulumi.output_type
class GetModelResult:
    """
    A collection of values returned by getModel.
    """
    def __init__(__self__, base_model_id=None, capabilities=None, compartment_id=None, defined_tags=None, description=None, display_name=None, fine_tune_details=None, freeform_tags=None, id=None, is_long_term_supported=None, lifecycle_details=None, model_id=None, model_metrics=None, state=None, system_tags=None, time_created=None, time_deprecated=None, time_updated=None, type=None, vendor=None, version=None):
        if base_model_id and not isinstance(base_model_id, str):
            raise TypeError("Expected argument 'base_model_id' to be a str")
        pulumi.set(__self__, "base_model_id", base_model_id)
        if capabilities and not isinstance(capabilities, list):
            raise TypeError("Expected argument 'capabilities' to be a list")
        pulumi.set(__self__, "capabilities", capabilities)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fine_tune_details and not isinstance(fine_tune_details, list):
            raise TypeError("Expected argument 'fine_tune_details' to be a list")
        pulumi.set(__self__, "fine_tune_details", fine_tune_details)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_long_term_supported and not isinstance(is_long_term_supported, bool):
            raise TypeError("Expected argument 'is_long_term_supported' to be a bool")
        pulumi.set(__self__, "is_long_term_supported", is_long_term_supported)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if model_id and not isinstance(model_id, str):
            raise TypeError("Expected argument 'model_id' to be a str")
        pulumi.set(__self__, "model_id", model_id)
        if model_metrics and not isinstance(model_metrics, list):
            raise TypeError("Expected argument 'model_metrics' to be a list")
        pulumi.set(__self__, "model_metrics", model_metrics)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_deprecated and not isinstance(time_deprecated, str):
            raise TypeError("Expected argument 'time_deprecated' to be a str")
        pulumi.set(__self__, "time_deprecated", time_deprecated)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if vendor and not isinstance(vendor, str):
            raise TypeError("Expected argument 'vendor' to be a str")
        pulumi.set(__self__, "vendor", vendor)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="baseModelId")
    def base_model_id(self) -> str:
        """
        The OCID of the base model that's used for fine-tuning. For pretrained models, the value is null.
        """
        return pulumi.get(self, "base_model_id")

    @property
    @pulumi.getter
    def capabilities(self) -> Sequence[str]:
        """
        Describes what this model can be used for.
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The compartment OCID for fine-tuned models. For pretrained models, this value is null.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        An optional description of the model.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fineTuneDetails")
    def fine_tune_details(self) -> Sequence['outputs.GetModelFineTuneDetailResult']:
        """
        Details about fine-tuning a custom model.
        """
        return pulumi.get(self, "fine_tune_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        An ID that uniquely identifies a pretrained or fine-tuned model.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLongTermSupported")
    def is_long_term_supported(self) -> bool:
        """
        Whether a model is supported long-term. Only applicable to base models.
        """
        return pulumi.get(self, "is_long_term_supported")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state of the model in more detail that can provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="modelId")
    def model_id(self) -> str:
        return pulumi.get(self, "model_id")

    @property
    @pulumi.getter(name="modelMetrics")
    def model_metrics(self) -> Sequence['outputs.GetModelModelMetricResult']:
        """
        Model metrics during the creation of a new model.
        """
        return pulumi.get(self, "model_metrics")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The lifecycle state of the model.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the model was created in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeDeprecated")
    def time_deprecated(self) -> str:
        """
        Corresponds to the time when the custom model and its associated foundation model will be deprecated.
        """
        return pulumi.get(self, "time_deprecated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time that the model was updated in the format of an RFC3339 datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def vendor(self) -> str:
        """
        The provider of the base model.
        """
        return pulumi.get(self, "vendor")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the model.
        """
        return pulumi.get(self, "version")


class AwaitableGetModelResult(GetModelResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetModelResult(
            base_model_id=self.base_model_id,
            capabilities=self.capabilities,
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            fine_tune_details=self.fine_tune_details,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_long_term_supported=self.is_long_term_supported,
            lifecycle_details=self.lifecycle_details,
            model_id=self.model_id,
            model_metrics=self.model_metrics,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_deprecated=self.time_deprecated,
            time_updated=self.time_updated,
            type=self.type,
            vendor=self.vendor,
            version=self.version)


def get_model(model_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetModelResult:
    """
    This data source provides details about a specific Model resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about a custom model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model = oci.GenerativeAi.get_model(model_id=test_model_oci_generative_ai_model["id"])
    ```


    :param str model_id: The model OCID
    """
    __args__ = dict()
    __args__['modelId'] = model_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GenerativeAi/getModel:getModel', __args__, opts=opts, typ=GetModelResult).value

    return AwaitableGetModelResult(
        base_model_id=pulumi.get(__ret__, 'base_model_id'),
        capabilities=pulumi.get(__ret__, 'capabilities'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fine_tune_details=pulumi.get(__ret__, 'fine_tune_details'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_long_term_supported=pulumi.get(__ret__, 'is_long_term_supported'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        model_id=pulumi.get(__ret__, 'model_id'),
        model_metrics=pulumi.get(__ret__, 'model_metrics'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_deprecated=pulumi.get(__ret__, 'time_deprecated'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        vendor=pulumi.get(__ret__, 'vendor'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_model)
def get_model_output(model_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetModelResult]:
    """
    This data source provides details about a specific Model resource in Oracle Cloud Infrastructure Generative AI service.

    Gets information about a custom model.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_model = oci.GenerativeAi.get_model(model_id=test_model_oci_generative_ai_model["id"])
    ```


    :param str model_id: The model OCID
    """
    ...
