# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ImportStandardTagsManagementArgs', 'ImportStandardTagsManagement']

@pulumi.input_type
class ImportStandardTagsManagementArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 standard_tag_namespace_name: pulumi.Input[str]):
        """
        The set of arguments for constructing a ImportStandardTagsManagement resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        :param pulumi.Input[str] standard_tag_namespace_name: The name of standard tag namespace that will be imported in bulk 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "standard_tag_namespace_name", standard_tag_namespace_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="standardTagNamespaceName")
    def standard_tag_namespace_name(self) -> pulumi.Input[str]:
        """
        The name of standard tag namespace that will be imported in bulk 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standard_tag_namespace_name")

    @standard_tag_namespace_name.setter
    def standard_tag_namespace_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "standard_tag_namespace_name", value)


@pulumi.input_type
class _ImportStandardTagsManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 standard_tag_namespace_name: Optional[pulumi.Input[str]] = None,
                 work_request_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ImportStandardTagsManagement resources.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        :param pulumi.Input[str] standard_tag_namespace_name: The name of standard tag namespace that will be imported in bulk 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if standard_tag_namespace_name is not None:
            pulumi.set(__self__, "standard_tag_namespace_name", standard_tag_namespace_name)
        if work_request_id is not None:
            pulumi.set(__self__, "work_request_id", work_request_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="standardTagNamespaceName")
    def standard_tag_namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of standard tag namespace that will be imported in bulk 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standard_tag_namespace_name")

    @standard_tag_namespace_name.setter
    def standard_tag_namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "standard_tag_namespace_name", value)

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "work_request_id")

    @work_request_id.setter
    def work_request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "work_request_id", value)


class ImportStandardTagsManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 standard_tag_namespace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Import Standard Tags Management resource in Oracle Cloud Infrastructure Identity service.

        OCI will release Tag Namespaces that our customers can import.
        These Tag Namespaces will provide Tags for our customers and Partners to provide consistency and enable data reporting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_import_standard_tags_management = oci.identity.ImportStandardTagsManagement("test_import_standard_tags_management",
            compartment_id=compartment_id,
            standard_tag_namespace_name=test_tag_namespace["name"])
        ```

        ## Import

        ImportStandardTagsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/importStandardTagsManagement:ImportStandardTagsManagement test_import_standard_tags_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        :param pulumi.Input[str] standard_tag_namespace_name: The name of standard tag namespace that will be imported in bulk 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ImportStandardTagsManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Import Standard Tags Management resource in Oracle Cloud Infrastructure Identity service.

        OCI will release Tag Namespaces that our customers can import.
        These Tag Namespaces will provide Tags for our customers and Partners to provide consistency and enable data reporting.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_import_standard_tags_management = oci.identity.ImportStandardTagsManagement("test_import_standard_tags_management",
            compartment_id=compartment_id,
            standard_tag_namespace_name=test_tag_namespace["name"])
        ```

        ## Import

        ImportStandardTagsManagement can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/importStandardTagsManagement:ImportStandardTagsManagement test_import_standard_tags_management "id"
        ```

        :param str resource_name: The name of the resource.
        :param ImportStandardTagsManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ImportStandardTagsManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 standard_tag_namespace_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ImportStandardTagsManagementArgs.__new__(ImportStandardTagsManagementArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if standard_tag_namespace_name is None and not opts.urn:
                raise TypeError("Missing required property 'standard_tag_namespace_name'")
            __props__.__dict__["standard_tag_namespace_name"] = standard_tag_namespace_name
            __props__.__dict__["work_request_id"] = None
        super(ImportStandardTagsManagement, __self__).__init__(
            'oci:Identity/importStandardTagsManagement:ImportStandardTagsManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            standard_tag_namespace_name: Optional[pulumi.Input[str]] = None,
            work_request_id: Optional[pulumi.Input[str]] = None) -> 'ImportStandardTagsManagement':
        """
        Get an existing ImportStandardTagsManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        :param pulumi.Input[str] standard_tag_namespace_name: The name of standard tag namespace that will be imported in bulk 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ImportStandardTagsManagementState.__new__(_ImportStandardTagsManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["standard_tag_namespace_name"] = standard_tag_namespace_name
        __props__.__dict__["work_request_id"] = work_request_id
        return ImportStandardTagsManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment where the bulk create request is submitted and where the tag namespaces will be created.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="standardTagNamespaceName")
    def standard_tag_namespace_name(self) -> pulumi.Output[str]:
        """
        The name of standard tag namespace that will be imported in bulk 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "standard_tag_namespace_name")

    @property
    @pulumi.getter(name="workRequestId")
    def work_request_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "work_request_id")

