# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetProductLicenseConsumersResult',
    'AwaitableGetProductLicenseConsumersResult',
    'get_product_license_consumers',
    'get_product_license_consumers_output',
]

@pulumi.output_type
class GetProductLicenseConsumersResult:
    """
    A collection of values returned by getProductLicenseConsumers.
    """
    def __init__(__self__, compartment_id=None, id=None, is_compartment_id_in_subtree=None, items=None, product_license_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_compartment_id_in_subtree and not isinstance(is_compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'is_compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "is_compartment_id_in_subtree", is_compartment_id_in_subtree)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if product_license_id and not isinstance(product_license_id, str):
            raise TypeError("Expected argument 'product_license_id' to be a str")
        pulumi.set(__self__, "product_license_id", product_license_id)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isCompartmentIdInSubtree")
    def is_compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "is_compartment_id_in_subtree")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetProductLicenseConsumersItemResult']:
        """
        Collection of product license consumers.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="productLicenseId")
    def product_license_id(self) -> str:
        return pulumi.get(self, "product_license_id")


class AwaitableGetProductLicenseConsumersResult(GetProductLicenseConsumersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductLicenseConsumersResult(
            compartment_id=self.compartment_id,
            id=self.id,
            is_compartment_id_in_subtree=self.is_compartment_id_in_subtree,
            items=self.items,
            product_license_id=self.product_license_id)


def get_product_license_consumers(compartment_id: Optional[str] = None,
                                  is_compartment_id_in_subtree: Optional[bool] = None,
                                  product_license_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductLicenseConsumersResult:
    """
    This data source provides the list of Product License Consumers in Oracle Cloud Infrastructure License Manager service.

    Retrieves the product license consumers for a particular product license ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license_consumers = oci.LicenseManager.get_product_license_consumers(compartment_id=compartment_id,
        product_license_id=test_product_license["id"],
        is_compartment_id_in_subtree=product_license_consumer_is_compartment_id_in_subtree)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param str product_license_id: Unique product license identifier.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['isCompartmentIdInSubtree'] = is_compartment_id_in_subtree
    __args__['productLicenseId'] = product_license_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LicenseManager/getProductLicenseConsumers:getProductLicenseConsumers', __args__, opts=opts, typ=GetProductLicenseConsumersResult).value

    return AwaitableGetProductLicenseConsumersResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        id=pulumi.get(__ret__, 'id'),
        is_compartment_id_in_subtree=pulumi.get(__ret__, 'is_compartment_id_in_subtree'),
        items=pulumi.get(__ret__, 'items'),
        product_license_id=pulumi.get(__ret__, 'product_license_id'))


@_utilities.lift_output_func(get_product_license_consumers)
def get_product_license_consumers_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                         is_compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                         product_license_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProductLicenseConsumersResult]:
    """
    This data source provides the list of Product License Consumers in Oracle Cloud Infrastructure License Manager service.

    Retrieves the product license consumers for a particular product license ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_product_license_consumers = oci.LicenseManager.get_product_license_consumers(compartment_id=compartment_id,
        product_license_id=test_product_license["id"],
        is_compartment_id_in_subtree=product_license_consumer_is_compartment_id_in_subtree)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) used for the license record, product license, and configuration.
    :param bool is_compartment_id_in_subtree: Indicates if the given compartment is the root compartment.
    :param str product_license_id: Unique product license identifier.
    """
    ...
