# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetQuotaResult',
    'AwaitableGetQuotaResult',
    'get_quota',
    'get_quota_output',
]

@pulumi.output_type
class GetQuotaResult:
    """
    A collection of values returned by getQuota.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, description=None, freeform_tags=None, id=None, is_lock_override=None, locks=None, name=None, quota_id=None, state=None, statements=None, time_created=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_lock_override and not isinstance(is_lock_override, bool):
            raise TypeError("Expected argument 'is_lock_override' to be a bool")
        pulumi.set(__self__, "is_lock_override", is_lock_override)
        if locks and not isinstance(locks, list):
            raise TypeError("Expected argument 'locks' to be a list")
        pulumi.set(__self__, "locks", locks)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if quota_id and not isinstance(quota_id, str):
            raise TypeError("Expected argument 'quota_id' to be a str")
        pulumi.set(__self__, "quota_id", quota_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if statements and not isinstance(statements, list):
            raise TypeError("Expected argument 'statements' to be a list")
        pulumi.set(__self__, "statements", statements)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment containing the resource this quota applies to.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description you assign to the quota.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the quota.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> bool:
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def locks(self) -> Sequence['outputs.GetQuotaLockResult']:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name you assign to the quota during creation. The name must be unique across all quotas in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="quotaId")
    def quota_id(self) -> str:
        return pulumi.get(self, "quota_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The quota's current state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def statements(self) -> Sequence[str]:
        """
        An array of one or more quota statements written in the declarative quota statement language.
        """
        return pulumi.get(self, "statements")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date and time the quota was created, in the format defined by RFC 3339. Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetQuotaResult(GetQuotaResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetQuotaResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_lock_override=self.is_lock_override,
            locks=self.locks,
            name=self.name,
            quota_id=self.quota_id,
            state=self.state,
            statements=self.statements,
            time_created=self.time_created)


def get_quota(quota_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetQuotaResult:
    """
    This data source provides details about a specific Quota resource in Oracle Cloud Infrastructure Limits service.

    Gets the quota for the OCID specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_quota = oci.Limits.get_quota(quota_id=test_quota_oci_limits_quota["id"])
    ```


    :param str quota_id: The OCID of the quota.
    """
    __args__ = dict()
    __args__['quotaId'] = quota_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Limits/getQuota:getQuota', __args__, opts=opts, typ=GetQuotaResult).value

    return AwaitableGetQuotaResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_lock_override=pulumi.get(__ret__, 'is_lock_override'),
        locks=pulumi.get(__ret__, 'locks'),
        name=pulumi.get(__ret__, 'name'),
        quota_id=pulumi.get(__ret__, 'quota_id'),
        state=pulumi.get(__ret__, 'state'),
        statements=pulumi.get(__ret__, 'statements'),
        time_created=pulumi.get(__ret__, 'time_created'))


@_utilities.lift_output_func(get_quota)
def get_quota_output(quota_id: Optional[pulumi.Input[str]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetQuotaResult]:
    """
    This data source provides details about a specific Quota resource in Oracle Cloud Infrastructure Limits service.

    Gets the quota for the OCID specified.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_quota = oci.Limits.get_quota(quota_id=test_quota_oci_limits_quota["id"])
    ```


    :param str quota_id: The OCID of the quota.
    """
    ...
