# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetHealthResult',
    'AwaitableGetHealthResult',
    'get_health',
    'get_health_output',
]

@pulumi.output_type
class GetHealthResult:
    """
    A collection of values returned by getHealth.
    """
    def __init__(__self__, critical_state_backend_set_names=None, id=None, load_balancer_id=None, status=None, total_backend_set_count=None, unknown_state_backend_set_names=None, warning_state_backend_set_names=None):
        if critical_state_backend_set_names and not isinstance(critical_state_backend_set_names, list):
            raise TypeError("Expected argument 'critical_state_backend_set_names' to be a list")
        pulumi.set(__self__, "critical_state_backend_set_names", critical_state_backend_set_names)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if load_balancer_id and not isinstance(load_balancer_id, str):
            raise TypeError("Expected argument 'load_balancer_id' to be a str")
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if total_backend_set_count and not isinstance(total_backend_set_count, int):
            raise TypeError("Expected argument 'total_backend_set_count' to be a int")
        pulumi.set(__self__, "total_backend_set_count", total_backend_set_count)
        if unknown_state_backend_set_names and not isinstance(unknown_state_backend_set_names, list):
            raise TypeError("Expected argument 'unknown_state_backend_set_names' to be a list")
        pulumi.set(__self__, "unknown_state_backend_set_names", unknown_state_backend_set_names)
        if warning_state_backend_set_names and not isinstance(warning_state_backend_set_names, list):
            raise TypeError("Expected argument 'warning_state_backend_set_names' to be a list")
        pulumi.set(__self__, "warning_state_backend_set_names", warning_state_backend_set_names)

    @property
    @pulumi.getter(name="criticalStateBackendSetNames")
    def critical_state_backend_set_names(self) -> Sequence[str]:
        """
        A list of backend sets that are currently in the `CRITICAL` health state. The list identifies each backend set by the friendly name you assigned when you created it.  Example: `example_backend_set`
        """
        return pulumi.get(self, "critical_state_backend_set_names")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> str:
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The overall health status of the load balancer.
        *  **OK:** All backend sets associated with the load balancer return a status of `OK`.
        *  **WARNING:** At least one of the backend sets associated with the load balancer returns a status of `WARNING`, no backend sets return a status of `CRITICAL`, and the load balancer life cycle state is `ACTIVE`.
        *  **CRITICAL:** One or more of the backend sets associated with the load balancer return a status of `CRITICAL`.
        *  **UNKNOWN:** If any one of the following conditions is true:
        *  The load balancer life cycle state is not `ACTIVE`.
        *  No backend sets are defined for the load balancer.
        *  More than half of the backend sets associated with the load balancer return a status of `UNKNOWN`, none of the backend sets return a status of `WARNING` or `CRITICAL`, and the load balancer life cycle state is `ACTIVE`.
        *  The system could not retrieve metrics for any reason.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalBackendSetCount")
    def total_backend_set_count(self) -> int:
        """
        The total number of backend sets associated with this load balancer.  Example: `4`
        """
        return pulumi.get(self, "total_backend_set_count")

    @property
    @pulumi.getter(name="unknownStateBackendSetNames")
    def unknown_state_backend_set_names(self) -> Sequence[str]:
        """
        A list of backend sets that are currently in the `UNKNOWN` health state. The list identifies each backend set by the friendly name you assigned when you created it.  Example: `example_backend_set2`
        """
        return pulumi.get(self, "unknown_state_backend_set_names")

    @property
    @pulumi.getter(name="warningStateBackendSetNames")
    def warning_state_backend_set_names(self) -> Sequence[str]:
        """
        A list of backend sets that are currently in the `WARNING` health state. The list identifies each backend set by the friendly name you assigned when you created it.  Example: `example_backend_set3`
        """
        return pulumi.get(self, "warning_state_backend_set_names")


class AwaitableGetHealthResult(GetHealthResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetHealthResult(
            critical_state_backend_set_names=self.critical_state_backend_set_names,
            id=self.id,
            load_balancer_id=self.load_balancer_id,
            status=self.status,
            total_backend_set_count=self.total_backend_set_count,
            unknown_state_backend_set_names=self.unknown_state_backend_set_names,
            warning_state_backend_set_names=self.warning_state_backend_set_names)


def get_health(load_balancer_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetHealthResult:
    """
    This data source provides details about a specific Load Balancer Health resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the health status for the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_load_balancer_health = oci.LoadBalancer.get_health(load_balancer_id=test_load_balancer["id"])
    ```


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to return health status for.
    """
    __args__ = dict()
    __args__['loadBalancerId'] = load_balancer_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:LoadBalancer/getHealth:getHealth', __args__, opts=opts, typ=GetHealthResult).value

    return AwaitableGetHealthResult(
        critical_state_backend_set_names=pulumi.get(__ret__, 'critical_state_backend_set_names'),
        id=pulumi.get(__ret__, 'id'),
        load_balancer_id=pulumi.get(__ret__, 'load_balancer_id'),
        status=pulumi.get(__ret__, 'status'),
        total_backend_set_count=pulumi.get(__ret__, 'total_backend_set_count'),
        unknown_state_backend_set_names=pulumi.get(__ret__, 'unknown_state_backend_set_names'),
        warning_state_backend_set_names=pulumi.get(__ret__, 'warning_state_backend_set_names'))


@_utilities.lift_output_func(get_health)
def get_health_output(load_balancer_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetHealthResult]:
    """
    This data source provides details about a specific Load Balancer Health resource in Oracle Cloud Infrastructure Load Balancer service.

    Gets the health status for the specified load balancer.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_load_balancer_health = oci.LoadBalancer.get_health(load_balancer_id=test_load_balancer["id"])
    ```


    :param str load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer to return health status for.
    """
    ...
