# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmSuppressionInitArgs', 'AlarmSuppression']

@pulumi.input_type
class AlarmSuppressionInitArgs:
    def __init__(__self__, *,
                 alarm_suppression_target: pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'],
                 dimensions: pulumi.Input[Mapping[str, pulumi.Input[str]]],
                 display_name: pulumi.Input[str],
                 time_suppress_from: pulumi.Input[str],
                 time_suppress_until: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AlarmSuppression resource.
        :param pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "alarm_suppression_target", alarm_suppression_target)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, value: pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']):
        pulumi.set(self, "alarm_suppression_target", value)

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Input[Mapping[str, pulumi.Input[str]]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: pulumi.Input[Mapping[str, pulumi.Input[str]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> pulumi.Input[str]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @time_suppress_from.setter
    def time_suppress_from(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_suppress_from", value)

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> pulumi.Input[str]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @time_suppress_until.setter
    def time_suppress_until(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_suppress_until", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AlarmSuppressionState:
    def __init__(__self__, *,
                 alarm_suppression_target: Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_suppress_from: Optional[pulumi.Input[str]] = None,
                 time_suppress_until: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AlarmSuppression resources.
        :param pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs'] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] state: The current lifecycle state of the alarm suppression.  Example: `DELETED`
        :param pulumi.Input[str] time_created: The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        if alarm_suppression_target is not None:
            pulumi.set(__self__, "alarm_suppression_target", alarm_suppression_target)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_suppress_from is not None:
            pulumi.set(__self__, "time_suppress_from", time_suppress_from)
        if time_suppress_until is not None:
            pulumi.set(__self__, "time_suppress_until", time_suppress_until)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']]:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @alarm_suppression_target.setter
    def alarm_suppression_target(self, value: Optional[pulumi.Input['AlarmSuppressionAlarmSuppressionTargetArgs']]):
        pulumi.set(self, "alarm_suppression_target", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> Optional[pulumi.Input[str]]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @time_suppress_from.setter
    def time_suppress_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_suppress_from", value)

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> Optional[pulumi.Input[str]]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @time_suppress_until.setter
    def time_suppress_until(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_suppress_until", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AlarmSuppression(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_suppress_from: Optional[pulumi.Input[str]] = None,
                 time_suppress_until: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a dimension-specific suppression for an alarm.

        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm_suppression = oci.monitoring.AlarmSuppression("test_alarm_suppression",
            alarm_suppression_target={
                "alarm_id": test_alarm["id"],
                "target_type": alarm_suppression_alarm_suppression_target_target_type,
            },
            dimensions=alarm_suppression_dimensions,
            display_name=alarm_suppression_display_name,
            time_suppress_from=alarm_suppression_time_suppress_from,
            time_suppress_until=alarm_suppression_time_suppress_until,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alarm_suppression_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AlarmSuppressions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarmSuppression:AlarmSuppression test_alarm_suppression "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmSuppressionInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Alarm Suppression resource in Oracle Cloud Infrastructure Monitoring service.

        Creates a dimension-specific suppression for an alarm.

        For important limits information, see
        [Limits on Monitoring](https://docs.cloud.oracle.com/iaas/Content/Monitoring/Concepts/monitoringoverview.htm#limits).

        This call is subject to a Monitoring limit that applies to the total number of requests across all alarm operations.
        Monitoring might throttle this call to reject an otherwise valid request when the total rate of alarm operations exceeds 10 requests,
        or transactions, per second (TPS) for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_alarm_suppression = oci.monitoring.AlarmSuppression("test_alarm_suppression",
            alarm_suppression_target={
                "alarm_id": test_alarm["id"],
                "target_type": alarm_suppression_alarm_suppression_target_target_type,
            },
            dimensions=alarm_suppression_dimensions,
            display_name=alarm_suppression_display_name,
            time_suppress_from=alarm_suppression_time_suppress_from,
            time_suppress_until=alarm_suppression_time_suppress_until,
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=alarm_suppression_description,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AlarmSuppressions can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Monitoring/alarmSuppression:AlarmSuppression test_alarm_suppression "id"
        ```

        :param str resource_name: The name of the resource.
        :param AlarmSuppressionInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmSuppressionInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_suppress_from: Optional[pulumi.Input[str]] = None,
                 time_suppress_until: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmSuppressionInitArgs.__new__(AlarmSuppressionInitArgs)

            if alarm_suppression_target is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_suppression_target'")
            __props__.__dict__["alarm_suppression_target"] = alarm_suppression_target
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if dimensions is None and not opts.urn:
                raise TypeError("Missing required property 'dimensions'")
            __props__.__dict__["dimensions"] = dimensions
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if time_suppress_from is None and not opts.urn:
                raise TypeError("Missing required property 'time_suppress_from'")
            __props__.__dict__["time_suppress_from"] = time_suppress_from
            if time_suppress_until is None and not opts.urn:
                raise TypeError("Missing required property 'time_suppress_until'")
            __props__.__dict__["time_suppress_until"] = time_suppress_until
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AlarmSuppression, __self__).__init__(
            'oci:Monitoring/alarmSuppression:AlarmSuppression',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_suppression_target: Optional[pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_suppress_from: Optional[pulumi.Input[str]] = None,
            time_suppress_until: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AlarmSuppression':
        """
        Get an existing AlarmSuppression resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['AlarmSuppressionAlarmSuppressionTargetArgs', 'AlarmSuppressionAlarmSuppressionTargetArgsDict']] alarm_suppression_target: The target of the alarm suppression.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
               
               Oracle recommends including tracking information for the event or associated work, such as a ticket number.
               
               Example: `Planned outage due to change IT-1234.`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions: A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.
               
               The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        :param pulumi.Input[str] display_name: A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] state: The current lifecycle state of the alarm suppression.  Example: `DELETED`
        :param pulumi.Input[str] time_created: The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_from: The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        :param pulumi.Input[str] time_suppress_until: The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_updated: The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmSuppressionState.__new__(_AlarmSuppressionState)

        __props__.__dict__["alarm_suppression_target"] = alarm_suppression_target
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_suppress_from"] = time_suppress_from
        __props__.__dict__["time_suppress_until"] = time_suppress_until
        __props__.__dict__["time_updated"] = time_updated
        return AlarmSuppression(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmSuppressionTarget")
    def alarm_suppression_target(self) -> pulumi.Output['outputs.AlarmSuppressionAlarmSuppressionTarget']:
        """
        The target of the alarm suppression.
        """
        return pulumi.get(self, "alarm_suppression_target")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the alarm suppression.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Usage of predefined tag keys. These predefined keys are scoped to namespaces. Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Human-readable reason for this alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.

        Oracle recommends including tracking information for the event or associated work, such as a ticket number.

        Example: `Planned outage due to change IT-1234.`
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Mapping[str, str]]:
        """
        A filter to suppress only alarm state entries that include the set of specified dimension key-value pairs. If you specify {"availabilityDomain": "phx-ad-1"} and the alarm state entry corresponds to the set {"availabilityDomain": "phx-ad-1" and "resourceId": "instance.region1.phx.exampleuniqueID"}, then this alarm will be included for suppression.

        The value cannot be an empty object. Only a single value is allowed per key. No grouping of multiple values is allowed under the same key. Maximum characters (after serialization): 4000. This maximum satisfies typical use cases. The response for an exceeded maximum is `HTTP 400` with an "dimensions values are too long" message.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name for the alarm suppression. It does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifecycle state of the alarm suppression.  Example: `DELETED`
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the alarm suppression was created. Format defined by RFC3339.  Example: `2018-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeSuppressFrom")
    def time_suppress_from(self) -> pulumi.Output[str]:
        """
        The start date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T01:02:29.600Z`
        """
        return pulumi.get(self, "time_suppress_from")

    @property
    @pulumi.getter(name="timeSuppressUntil")
    def time_suppress_until(self) -> pulumi.Output[str]:
        """
        The end date and time for the suppression to take place, inclusive. Format defined by RFC3339.  Example: `2023-02-01T02:02:29.600Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_suppress_until")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the alarm suppression was last updated (deleted). Format defined by RFC3339.  Example: `2018-02-03T01:02:29.600Z`
        """
        return pulumi.get(self, "time_updated")

