# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetMysqlDbSystemResult',
    'AwaitableGetMysqlDbSystemResult',
    'get_mysql_db_system',
    'get_mysql_db_system_output',
]

@pulumi.output_type
class GetMysqlDbSystemResult:
    """
    A collection of values returned by getMysqlDbSystem.
    """
    def __init__(__self__, admin_password=None, admin_username=None, availability_domain=None, backup_policies=None, channels=None, compartment_id=None, configuration_id=None, crash_recovery=None, current_placements=None, customer_contacts=None, data_storage_size_in_gb=None, data_storages=None, database_management=None, db_system_id=None, defined_tags=None, deletion_policies=None, description=None, display_name=None, endpoints=None, fault_domain=None, freeform_tags=None, heat_wave_clusters=None, hostname_label=None, id=None, ip_address=None, is_heat_wave_cluster_attached=None, is_highly_available=None, lifecycle_details=None, maintenances=None, mysql_version=None, point_in_time_recovery_details=None, port=None, port_x=None, secure_connections=None, shape_name=None, shutdown_type=None, sources=None, state=None, subnet_id=None, time_created=None, time_updated=None):
        if admin_password and not isinstance(admin_password, str):
            raise TypeError("Expected argument 'admin_password' to be a str")
        pulumi.set(__self__, "admin_password", admin_password)
        if admin_username and not isinstance(admin_username, str):
            raise TypeError("Expected argument 'admin_username' to be a str")
        pulumi.set(__self__, "admin_username", admin_username)
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_policies and not isinstance(backup_policies, list):
            raise TypeError("Expected argument 'backup_policies' to be a list")
        pulumi.set(__self__, "backup_policies", backup_policies)
        if channels and not isinstance(channels, list):
            raise TypeError("Expected argument 'channels' to be a list")
        pulumi.set(__self__, "channels", channels)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if configuration_id and not isinstance(configuration_id, str):
            raise TypeError("Expected argument 'configuration_id' to be a str")
        pulumi.set(__self__, "configuration_id", configuration_id)
        if crash_recovery and not isinstance(crash_recovery, str):
            raise TypeError("Expected argument 'crash_recovery' to be a str")
        pulumi.set(__self__, "crash_recovery", crash_recovery)
        if current_placements and not isinstance(current_placements, list):
            raise TypeError("Expected argument 'current_placements' to be a list")
        pulumi.set(__self__, "current_placements", current_placements)
        if customer_contacts and not isinstance(customer_contacts, list):
            raise TypeError("Expected argument 'customer_contacts' to be a list")
        pulumi.set(__self__, "customer_contacts", customer_contacts)
        if data_storage_size_in_gb and not isinstance(data_storage_size_in_gb, int):
            raise TypeError("Expected argument 'data_storage_size_in_gb' to be a int")
        pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if data_storages and not isinstance(data_storages, list):
            raise TypeError("Expected argument 'data_storages' to be a list")
        pulumi.set(__self__, "data_storages", data_storages)
        if database_management and not isinstance(database_management, str):
            raise TypeError("Expected argument 'database_management' to be a str")
        pulumi.set(__self__, "database_management", database_management)
        if db_system_id and not isinstance(db_system_id, str):
            raise TypeError("Expected argument 'db_system_id' to be a str")
        pulumi.set(__self__, "db_system_id", db_system_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if deletion_policies and not isinstance(deletion_policies, list):
            raise TypeError("Expected argument 'deletion_policies' to be a list")
        pulumi.set(__self__, "deletion_policies", deletion_policies)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if endpoints and not isinstance(endpoints, list):
            raise TypeError("Expected argument 'endpoints' to be a list")
        pulumi.set(__self__, "endpoints", endpoints)
        if fault_domain and not isinstance(fault_domain, str):
            raise TypeError("Expected argument 'fault_domain' to be a str")
        pulumi.set(__self__, "fault_domain", fault_domain)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if heat_wave_clusters and not isinstance(heat_wave_clusters, list):
            raise TypeError("Expected argument 'heat_wave_clusters' to be a list")
        pulumi.set(__self__, "heat_wave_clusters", heat_wave_clusters)
        if hostname_label and not isinstance(hostname_label, str):
            raise TypeError("Expected argument 'hostname_label' to be a str")
        pulumi.set(__self__, "hostname_label", hostname_label)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_address and not isinstance(ip_address, str):
            raise TypeError("Expected argument 'ip_address' to be a str")
        pulumi.set(__self__, "ip_address", ip_address)
        if is_heat_wave_cluster_attached and not isinstance(is_heat_wave_cluster_attached, bool):
            raise TypeError("Expected argument 'is_heat_wave_cluster_attached' to be a bool")
        pulumi.set(__self__, "is_heat_wave_cluster_attached", is_heat_wave_cluster_attached)
        if is_highly_available and not isinstance(is_highly_available, bool):
            raise TypeError("Expected argument 'is_highly_available' to be a bool")
        pulumi.set(__self__, "is_highly_available", is_highly_available)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if maintenances and not isinstance(maintenances, list):
            raise TypeError("Expected argument 'maintenances' to be a list")
        pulumi.set(__self__, "maintenances", maintenances)
        if mysql_version and not isinstance(mysql_version, str):
            raise TypeError("Expected argument 'mysql_version' to be a str")
        pulumi.set(__self__, "mysql_version", mysql_version)
        if point_in_time_recovery_details and not isinstance(point_in_time_recovery_details, list):
            raise TypeError("Expected argument 'point_in_time_recovery_details' to be a list")
        pulumi.set(__self__, "point_in_time_recovery_details", point_in_time_recovery_details)
        if port and not isinstance(port, int):
            raise TypeError("Expected argument 'port' to be a int")
        pulumi.set(__self__, "port", port)
        if port_x and not isinstance(port_x, int):
            raise TypeError("Expected argument 'port_x' to be a int")
        pulumi.set(__self__, "port_x", port_x)
        if secure_connections and not isinstance(secure_connections, list):
            raise TypeError("Expected argument 'secure_connections' to be a list")
        pulumi.set(__self__, "secure_connections", secure_connections)
        if shape_name and not isinstance(shape_name, str):
            raise TypeError("Expected argument 'shape_name' to be a str")
        pulumi.set(__self__, "shape_name", shape_name)
        if shutdown_type and not isinstance(shutdown_type, str):
            raise TypeError("Expected argument 'shutdown_type' to be a str")
        pulumi.set(__self__, "shutdown_type", shutdown_type)
        if sources and not isinstance(sources, list):
            raise TypeError("Expected argument 'sources' to be a list")
        pulumi.set(__self__, "sources", sources)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> str:
        return pulumi.get(self, "admin_password")

    @property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> str:
        return pulumi.get(self, "admin_username")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain in which the DB System is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupPolicies")
    def backup_policies(self) -> Sequence['outputs.GetMysqlDbSystemBackupPolicyResult']:
        """
        The Backup policy for the DB System.
        """
        return pulumi.get(self, "backup_policies")

    @property
    @pulumi.getter
    def channels(self) -> Sequence['outputs.GetMysqlDbSystemChannelResult']:
        """
        A list with a summary of all the Channels attached to the DB System.
        """
        return pulumi.get(self, "channels")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment the DB System belongs in.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configurationId")
    def configuration_id(self) -> str:
        """
        The OCID of the Configuration to be used for Instances in this DB System.
        """
        return pulumi.get(self, "configuration_id")

    @property
    @pulumi.getter(name="crashRecovery")
    def crash_recovery(self) -> str:
        """
        Whether to run the DB System with InnoDB Redo Logs and the Double Write Buffer enabled or disabled, and whether to enable or disable syncing of the Binary Logs.
        """
        return pulumi.get(self, "crash_recovery")

    @property
    @pulumi.getter(name="currentPlacements")
    def current_placements(self) -> Sequence['outputs.GetMysqlDbSystemCurrentPlacementResult']:
        """
        The availability domain and fault domain a DB System is placed in.
        """
        return pulumi.get(self, "current_placements")

    @property
    @pulumi.getter(name="customerContacts")
    def customer_contacts(self) -> Sequence['outputs.GetMysqlDbSystemCustomerContactResult']:
        """
        The list of customer email addresses that receive information from Oracle about the specified Oracle Cloud Infrastructure DB System resource.  Oracle uses these email addresses to send notifications about planned and unplanned software maintenance updates, information about system hardware, and other information needed by administrators.  Up to 10 email addresses can be added to the customer contacts for a DB System.
        """
        return pulumi.get(self, "customer_contacts")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> int:
        """
        Initial size of the data volume in GiBs that will be created and attached.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="dataStorages")
    def data_storages(self) -> Sequence['outputs.GetMysqlDbSystemDataStorageResult']:
        """
        Data Storage information.
        """
        return pulumi.get(self, "data_storages")

    @property
    @pulumi.getter(name="databaseManagement")
    def database_management(self) -> str:
        """
        Whether to enable monitoring via the Database Management service.
        """
        return pulumi.get(self, "database_management")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> str:
        """
        The OCID of the DB System from which a backup shall be selected to be restored when creating the new DB System. Use this together with recovery point to perform a point in time recovery operation.
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deletionPolicies")
    def deletion_policies(self) -> Sequence['outputs.GetMysqlDbSystemDeletionPolicyResult']:
        """
        The Deletion policy for the DB System.
        """
        return pulumi.get(self, "deletion_policies")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        User-provided data about the DB System.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        The user-friendly name for the DB System. It does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetMysqlDbSystemEndpointResult']:
        """
        The network endpoints available for this DB System.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> str:
        """
        The fault domain on which to deploy the Read/Write endpoint. This defines the preferred primary instance.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="heatWaveClusters")
    def heat_wave_clusters(self) -> Sequence['outputs.GetMysqlDbSystemHeatWaveClusterResult']:
        """
        A summary of a HeatWave cluster.
        """
        return pulumi.get(self, "heat_wave_clusters")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> str:
        """
        The hostname for the primary endpoint of the DB System. Used for DNS. The value is the hostname portion of the primary private IP's fully qualified domain name (FQDN) (for example, "dbsystem-1" in FQDN "dbsystem-1.subnet123.vcn1.oraclevcn.com"). Must be unique across all VNICs in the subnet and comply with RFC 952 and RFC 1123.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the DB System.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP address the DB System is configured to listen on. A private IP address of the primary endpoint of the DB System. Must be an available IP address within the subnet's CIDR. This will be a "dotted-quad" style IPv4 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isHeatWaveClusterAttached")
    def is_heat_wave_cluster_attached(self) -> bool:
        """
        If the DB System has a HeatWave Cluster attached.
        """
        return pulumi.get(self, "is_heat_wave_cluster_attached")

    @property
    @pulumi.getter(name="isHighlyAvailable")
    def is_highly_available(self) -> bool:
        """
        Specifies if the DB System is highly available.
        """
        return pulumi.get(self, "is_highly_available")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Additional information about the current lifecycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def maintenances(self) -> Sequence['outputs.GetMysqlDbSystemMaintenanceResult']:
        """
        The Maintenance Policy for the DB System or Read Replica that this model is included in.
        """
        return pulumi.get(self, "maintenances")

    @property
    @pulumi.getter(name="mysqlVersion")
    def mysql_version(self) -> str:
        """
        Name of the MySQL Version in use for the DB System.
        """
        return pulumi.get(self, "mysql_version")

    @property
    @pulumi.getter(name="pointInTimeRecoveryDetails")
    def point_in_time_recovery_details(self) -> Sequence['outputs.GetMysqlDbSystemPointInTimeRecoveryDetailResult']:
        """
        Point-in-time Recovery details like earliest and latest recovery time point for the DB System.
        """
        return pulumi.get(self, "point_in_time_recovery_details")

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        The port for primary endpoint of the DB System to listen on.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="portX")
    def port_x(self) -> int:
        """
        The network port on which X Plugin listens for TCP/IP connections. This is the X Plugin equivalent of port.
        """
        return pulumi.get(self, "port_x")

    @property
    @pulumi.getter(name="secureConnections")
    def secure_connections(self) -> Sequence['outputs.GetMysqlDbSystemSecureConnectionResult']:
        """
        Secure connection configuration details.
        """
        return pulumi.get(self, "secure_connections")

    @property
    @pulumi.getter(name="shapeName")
    def shape_name(self) -> str:
        """
        The shape of the primary instances of the DB System. The shape determines resources allocated to a DB System - CPU cores and memory for VM shapes; CPU cores, memory and storage for non-VM (or bare metal) shapes. To get a list of shapes, use (the [ListShapes](https://docs.cloud.oracle.com/iaas/api/#/en/mysql/20181021/ShapeSummary/ListShapes) operation.
        """
        return pulumi.get(self, "shape_name")

    @property
    @pulumi.getter(name="shutdownType")
    def shutdown_type(self) -> str:
        return pulumi.get(self, "shutdown_type")

    @property
    @pulumi.getter
    def sources(self) -> Sequence['outputs.GetMysqlDbSystemSourceResult']:
        """
        Parameters detailing how to provision the initial data of the DB System.
        """
        return pulumi.get(self, "sources")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the DB System.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet the DB System is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the DB System was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the DB System was last updated.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetMysqlDbSystemResult(GetMysqlDbSystemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMysqlDbSystemResult(
            admin_password=self.admin_password,
            admin_username=self.admin_username,
            availability_domain=self.availability_domain,
            backup_policies=self.backup_policies,
            channels=self.channels,
            compartment_id=self.compartment_id,
            configuration_id=self.configuration_id,
            crash_recovery=self.crash_recovery,
            current_placements=self.current_placements,
            customer_contacts=self.customer_contacts,
            data_storage_size_in_gb=self.data_storage_size_in_gb,
            data_storages=self.data_storages,
            database_management=self.database_management,
            db_system_id=self.db_system_id,
            defined_tags=self.defined_tags,
            deletion_policies=self.deletion_policies,
            description=self.description,
            display_name=self.display_name,
            endpoints=self.endpoints,
            fault_domain=self.fault_domain,
            freeform_tags=self.freeform_tags,
            heat_wave_clusters=self.heat_wave_clusters,
            hostname_label=self.hostname_label,
            id=self.id,
            ip_address=self.ip_address,
            is_heat_wave_cluster_attached=self.is_heat_wave_cluster_attached,
            is_highly_available=self.is_highly_available,
            lifecycle_details=self.lifecycle_details,
            maintenances=self.maintenances,
            mysql_version=self.mysql_version,
            point_in_time_recovery_details=self.point_in_time_recovery_details,
            port=self.port,
            port_x=self.port_x,
            secure_connections=self.secure_connections,
            shape_name=self.shape_name,
            shutdown_type=self.shutdown_type,
            sources=self.sources,
            state=self.state,
            subnet_id=self.subnet_id,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_mysql_db_system(db_system_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMysqlDbSystemResult:
    """
    This data source provides details about a specific Mysql Db System resource in Oracle Cloud Infrastructure MySQL Database service.

    Get information about the specified DB System.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_db_system = oci.Mysql.get_mysql_db_system(db_system_id=test_db_system["id"])
    ```


    :param str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['dbSystemId'] = db_system_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Mysql/getMysqlDbSystem:getMysqlDbSystem', __args__, opts=opts, typ=GetMysqlDbSystemResult).value

    return AwaitableGetMysqlDbSystemResult(
        admin_password=pulumi.get(__ret__, 'admin_password'),
        admin_username=pulumi.get(__ret__, 'admin_username'),
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        backup_policies=pulumi.get(__ret__, 'backup_policies'),
        channels=pulumi.get(__ret__, 'channels'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        configuration_id=pulumi.get(__ret__, 'configuration_id'),
        crash_recovery=pulumi.get(__ret__, 'crash_recovery'),
        current_placements=pulumi.get(__ret__, 'current_placements'),
        customer_contacts=pulumi.get(__ret__, 'customer_contacts'),
        data_storage_size_in_gb=pulumi.get(__ret__, 'data_storage_size_in_gb'),
        data_storages=pulumi.get(__ret__, 'data_storages'),
        database_management=pulumi.get(__ret__, 'database_management'),
        db_system_id=pulumi.get(__ret__, 'db_system_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        deletion_policies=pulumi.get(__ret__, 'deletion_policies'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        endpoints=pulumi.get(__ret__, 'endpoints'),
        fault_domain=pulumi.get(__ret__, 'fault_domain'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        heat_wave_clusters=pulumi.get(__ret__, 'heat_wave_clusters'),
        hostname_label=pulumi.get(__ret__, 'hostname_label'),
        id=pulumi.get(__ret__, 'id'),
        ip_address=pulumi.get(__ret__, 'ip_address'),
        is_heat_wave_cluster_attached=pulumi.get(__ret__, 'is_heat_wave_cluster_attached'),
        is_highly_available=pulumi.get(__ret__, 'is_highly_available'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        maintenances=pulumi.get(__ret__, 'maintenances'),
        mysql_version=pulumi.get(__ret__, 'mysql_version'),
        point_in_time_recovery_details=pulumi.get(__ret__, 'point_in_time_recovery_details'),
        port=pulumi.get(__ret__, 'port'),
        port_x=pulumi.get(__ret__, 'port_x'),
        secure_connections=pulumi.get(__ret__, 'secure_connections'),
        shape_name=pulumi.get(__ret__, 'shape_name'),
        shutdown_type=pulumi.get(__ret__, 'shutdown_type'),
        sources=pulumi.get(__ret__, 'sources'),
        state=pulumi.get(__ret__, 'state'),
        subnet_id=pulumi.get(__ret__, 'subnet_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_mysql_db_system)
def get_mysql_db_system_output(db_system_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMysqlDbSystemResult]:
    """
    This data source provides details about a specific Mysql Db System resource in Oracle Cloud Infrastructure MySQL Database service.

    Get information about the specified DB System.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_mysql_db_system = oci.Mysql.get_mysql_db_system(db_system_id=test_db_system["id"])
    ```


    :param str db_system_id: The DB System [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
