# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NetworkFirewallPolicyApplicationArgs', 'NetworkFirewallPolicyApplication']

@pulumi.input_type
class NetworkFirewallPolicyApplicationArgs:
    def __init__(__self__, *,
                 icmp_type: pulumi.Input[int],
                 network_firewall_policy_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a NetworkFirewallPolicyApplication resource.
        :param pulumi.Input[int] icmp_type: (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] type: Describes the type of application. The accepted values are - * ICMP * ICMP_V6
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[int] icmp_code: (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[str] name: Name of the application
        """
        pulumi.set(__self__, "icmp_type", icmp_type)
        pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        pulumi.set(__self__, "type", type)
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> pulumi.Input[int]:
        """
        (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_type")

    @icmp_type.setter
    def icmp_type(self, value: pulumi.Input[int]):
        pulumi.set(self, "icmp_type", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Input[str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Describes the type of application. The accepted values are - * ICMP * ICMP_V6


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_code")

    @icmp_code.setter
    def icmp_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_code", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NetworkFirewallPolicyApplicationState:
    def __init__(__self__, *,
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 icmp_type: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 parent_resource_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering NetworkFirewallPolicyApplication resources.
        :param pulumi.Input[int] icmp_code: (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[int] icmp_type: (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this application belongs to.
        :param pulumi.Input[str] type: Describes the type of application. The accepted values are - * ICMP * ICMP_V6
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if icmp_code is not None:
            pulumi.set(__self__, "icmp_code", icmp_code)
        if icmp_type is not None:
            pulumi.set(__self__, "icmp_type", icmp_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_firewall_policy_id is not None:
            pulumi.set(__self__, "network_firewall_policy_id", network_firewall_policy_id)
        if parent_resource_id is not None:
            pulumi.set(__self__, "parent_resource_id", parent_resource_id)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_code")

    @icmp_code.setter
    def icmp_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_code", value)

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_type")

    @icmp_type.setter
    def icmp_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "icmp_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @network_firewall_policy_id.setter
    def network_firewall_policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_firewall_policy_id", value)

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Network Firewall Policy this application belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @parent_resource_id.setter
    def parent_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_resource_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Describes the type of application. The accepted values are - * ICMP * ICMP_V6


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class NetworkFirewallPolicyApplication(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 icmp_type: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Network Firewall Policy Application resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Application inside the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_application = oci.network_firewall.NetworkFirewallPolicyApplication("test_network_firewall_policy_application",
            icmp_type=network_firewall_policy_application_icmp_type,
            name=network_firewall_policy_application_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_application_type,
            icmp_code=network_firewall_policy_application_icmp_code)
        ```

        ## Import

        NetworkFirewallPolicyApplications can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyApplication:NetworkFirewallPolicyApplication test_network_firewall_policy_application "networkFirewallPolicies/{networkFirewallPolicyId}/applications/{applicationName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] icmp_code: (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[int] icmp_type: (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] type: Describes the type of application. The accepted values are - * ICMP * ICMP_V6
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NetworkFirewallPolicyApplicationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Network Firewall Policy Application resource in Oracle Cloud Infrastructure Network Firewall service.

        Creates a new Application inside the Network Firewall Policy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_network_firewall_policy_application = oci.network_firewall.NetworkFirewallPolicyApplication("test_network_firewall_policy_application",
            icmp_type=network_firewall_policy_application_icmp_type,
            name=network_firewall_policy_application_name,
            network_firewall_policy_id=test_network_firewall_policy["id"],
            type=network_firewall_policy_application_type,
            icmp_code=network_firewall_policy_application_icmp_code)
        ```

        ## Import

        NetworkFirewallPolicyApplications can be imported using the `name`, e.g.

        ```sh
        $ pulumi import oci:NetworkFirewall/networkFirewallPolicyApplication:NetworkFirewallPolicyApplication test_network_firewall_policy_application "networkFirewallPolicies/{networkFirewallPolicyId}/applications/{applicationName}"
        ```

        :param str resource_name: The name of the resource.
        :param NetworkFirewallPolicyApplicationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NetworkFirewallPolicyApplicationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 icmp_code: Optional[pulumi.Input[int]] = None,
                 icmp_type: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NetworkFirewallPolicyApplicationArgs.__new__(NetworkFirewallPolicyApplicationArgs)

            __props__.__dict__["icmp_code"] = icmp_code
            if icmp_type is None and not opts.urn:
                raise TypeError("Missing required property 'icmp_type'")
            __props__.__dict__["icmp_type"] = icmp_type
            __props__.__dict__["name"] = name
            if network_firewall_policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_firewall_policy_id'")
            __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["parent_resource_id"] = None
        super(NetworkFirewallPolicyApplication, __self__).__init__(
            'oci:NetworkFirewall/networkFirewallPolicyApplication:NetworkFirewallPolicyApplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            icmp_code: Optional[pulumi.Input[int]] = None,
            icmp_type: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_firewall_policy_id: Optional[pulumi.Input[str]] = None,
            parent_resource_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'NetworkFirewallPolicyApplication':
        """
        Get an existing NetworkFirewallPolicyApplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] icmp_code: (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[int] icmp_type: (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        :param pulumi.Input[str] name: Name of the application
        :param pulumi.Input[str] network_firewall_policy_id: Unique Network Firewall Policy identifier
        :param pulumi.Input[str] parent_resource_id: OCID of the Network Firewall Policy this application belongs to.
        :param pulumi.Input[str] type: Describes the type of application. The accepted values are - * ICMP * ICMP_V6
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NetworkFirewallPolicyApplicationState.__new__(_NetworkFirewallPolicyApplicationState)

        __props__.__dict__["icmp_code"] = icmp_code
        __props__.__dict__["icmp_type"] = icmp_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_firewall_policy_id"] = network_firewall_policy_id
        __props__.__dict__["parent_resource_id"] = parent_resource_id
        __props__.__dict__["type"] = type
        return NetworkFirewallPolicyApplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="icmpCode")
    def icmp_code(self) -> pulumi.Output[int]:
        """
        (Updatable) The value of the ICMP/ICMP_V6 message Code (subtype) field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_code")

    @property
    @pulumi.getter(name="icmpType")
    def icmp_type(self) -> pulumi.Output[int]:
        """
        (Updatable) The value of the ICMP/IMCP_V6 message Type field as defined by [RFC 4443](https://www.rfc-editor.org/rfc/rfc4443.html#section-2.1).
        """
        return pulumi.get(self, "icmp_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the application
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkFirewallPolicyId")
    def network_firewall_policy_id(self) -> pulumi.Output[str]:
        """
        Unique Network Firewall Policy identifier
        """
        return pulumi.get(self, "network_firewall_policy_id")

    @property
    @pulumi.getter(name="parentResourceId")
    def parent_resource_id(self) -> pulumi.Output[str]:
        """
        OCID of the Network Firewall Policy this application belongs to.
        """
        return pulumi.get(self, "parent_resource_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Describes the type of application. The accepted values are - * ICMP * ICMP_V6


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

