# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNewsReportResult',
    'AwaitableGetNewsReportResult',
    'get_news_report',
    'get_news_report_output',
]

@pulumi.output_type
class GetNewsReportResult:
    """
    A collection of values returned by getNewsReport.
    """
    def __init__(__self__, are_child_compartments_included=None, compartment_id=None, content_types=None, day_of_week=None, defined_tags=None, description=None, freeform_tags=None, id=None, lifecycle_details=None, locale=None, name=None, news_frequency=None, news_report_id=None, ons_topic_id=None, state=None, status=None, system_tags=None, time_created=None, time_updated=None):
        if are_child_compartments_included and not isinstance(are_child_compartments_included, bool):
            raise TypeError("Expected argument 'are_child_compartments_included' to be a bool")
        pulumi.set(__self__, "are_child_compartments_included", are_child_compartments_included)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content_types and not isinstance(content_types, list):
            raise TypeError("Expected argument 'content_types' to be a list")
        pulumi.set(__self__, "content_types", content_types)
        if day_of_week and not isinstance(day_of_week, str):
            raise TypeError("Expected argument 'day_of_week' to be a str")
        pulumi.set(__self__, "day_of_week", day_of_week)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locale and not isinstance(locale, str):
            raise TypeError("Expected argument 'locale' to be a str")
        pulumi.set(__self__, "locale", locale)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if news_frequency and not isinstance(news_frequency, str):
            raise TypeError("Expected argument 'news_frequency' to be a str")
        pulumi.set(__self__, "news_frequency", news_frequency)
        if news_report_id and not isinstance(news_report_id, str):
            raise TypeError("Expected argument 'news_report_id' to be a str")
        pulumi.set(__self__, "news_report_id", news_report_id)
        if ons_topic_id and not isinstance(ons_topic_id, str):
            raise TypeError("Expected argument 'ons_topic_id' to be a str")
        pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="areChildCompartmentsIncluded")
    def are_child_compartments_included(self) -> bool:
        """
        A flag to consider the resources within a given compartment and all sub-compartments.
        """
        return pulumi.get(self, "are_child_compartments_included")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contentTypes")
    def content_types(self) -> Sequence['outputs.GetNewsReportContentTypeResult']:
        """
        Content types that the news report can handle.
        """
        return pulumi.get(self, "content_types")

    @property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> str:
        """
        Day of the week in which the news report will be sent if the frequency is set to WEEKLY.
        """
        return pulumi.get(self, "day_of_week")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the news report.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the news report resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locale(self) -> str:
        """
        Language of the news report.
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The news report name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="newsFrequency")
    def news_frequency(self) -> str:
        """
        News report frequency.
        """
        return pulumi.get(self, "news_frequency")

    @property
    @pulumi.getter(name="newsReportId")
    def news_report_id(self) -> str:
        return pulumi.get(self, "news_report_id")

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the ONS topic.
        """
        return pulumi.get(self, "ons_topic_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the news report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Indicates the status of a news report in Ops Insights.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the the news report was first enabled. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the news report was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetNewsReportResult(GetNewsReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNewsReportResult(
            are_child_compartments_included=self.are_child_compartments_included,
            compartment_id=self.compartment_id,
            content_types=self.content_types,
            day_of_week=self.day_of_week,
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            locale=self.locale,
            name=self.name,
            news_frequency=self.news_frequency,
            news_report_id=self.news_report_id,
            ons_topic_id=self.ons_topic_id,
            state=self.state,
            status=self.status,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_news_report(news_report_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNewsReportResult:
    """
    This data source provides details about a specific News Report resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of a news report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_news_report = oci.Opsi.get_news_report(news_report_id=test_news_report_oci_opsi_news_report["id"])
    ```


    :param str news_report_id: Unique news report identifier.
    """
    __args__ = dict()
    __args__['newsReportId'] = news_report_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getNewsReport:getNewsReport', __args__, opts=opts, typ=GetNewsReportResult).value

    return AwaitableGetNewsReportResult(
        are_child_compartments_included=pulumi.get(__ret__, 'are_child_compartments_included'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        content_types=pulumi.get(__ret__, 'content_types'),
        day_of_week=pulumi.get(__ret__, 'day_of_week'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        locale=pulumi.get(__ret__, 'locale'),
        name=pulumi.get(__ret__, 'name'),
        news_frequency=pulumi.get(__ret__, 'news_frequency'),
        news_report_id=pulumi.get(__ret__, 'news_report_id'),
        ons_topic_id=pulumi.get(__ret__, 'ons_topic_id'),
        state=pulumi.get(__ret__, 'state'),
        status=pulumi.get(__ret__, 'status'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_news_report)
def get_news_report_output(news_report_id: Optional[pulumi.Input[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNewsReportResult]:
    """
    This data source provides details about a specific News Report resource in Oracle Cloud Infrastructure Opsi service.

    Gets details of a news report.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_news_report = oci.Opsi.get_news_report(news_report_id=test_news_report_oci_opsi_news_report["id"])
    ```


    :param str news_report_id: Unique news report identifier.
    """
    ...
