# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStacksResult',
    'AwaitableGetStacksResult',
    'get_stacks',
    'get_stacks_output',
]

@pulumi.output_type
class GetStacksResult:
    """
    A collection of values returned by getStacks.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, stacks=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if stacks and not isinstance(stacks, list):
            raise TypeError("Expected argument 'stacks' to be a list")
        pulumi.set(__self__, "stacks", stacks)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Unique identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) for the compartment where the stack is located.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Human-readable display name for the stack.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStacksFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)) for the stack.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def stacks(self) -> Sequence['outputs.GetStacksStackResult']:
        """
        The list of stacks.
        """
        return pulumi.get(self, "stacks")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current lifecycle state of the stack.
        """
        return pulumi.get(self, "state")


class AwaitableGetStacksResult(GetStacksResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStacksResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            stacks=self.stacks,
            state=self.state)


def get_stacks(compartment_id: Optional[str] = None,
               display_name: Optional[str] = None,
               filters: Optional[Sequence[Union['GetStacksFilterArgs', 'GetStacksFilterArgsDict']]] = None,
               id: Optional[str] = None,
               state: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStacksResult:
    """
    This data source provides the list of Stacks in Oracle Cloud Infrastructure Resource Manager service.

    Returns a list of stacks.
    - If called using the compartment ID, returns all stacks in the specified compartment.
    - If called using the stack ID, returns the specified stack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stacks = oci.ResourceManager.get_stacks(compartment_id=compartment_id,
        display_name=stack_display_name,
        id=stack_id,
        state=stack_state)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to filter.
    :param str display_name: Display name on which to query.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to query for a stack.
    :param str state: A filter that returns only those resources that match the specified lifecycle state. The state value is case-insensitive.
           
           Allowable values:
           * CREATING
           * ACTIVE
           * DELETING
           * DELETED
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ResourceManager/getStacks:getStacks', __args__, opts=opts, typ=GetStacksResult).value

    return AwaitableGetStacksResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        stacks=pulumi.get(__ret__, 'stacks'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_stacks)
def get_stacks_output(compartment_id: Optional[pulumi.Input[str]] = None,
                      display_name: Optional[pulumi.Input[Optional[str]]] = None,
                      filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStacksFilterArgs', 'GetStacksFilterArgsDict']]]]] = None,
                      id: Optional[pulumi.Input[Optional[str]]] = None,
                      state: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetStacksResult]:
    """
    This data source provides the list of Stacks in Oracle Cloud Infrastructure Resource Manager service.

    Returns a list of stacks.
    - If called using the compartment ID, returns all stacks in the specified compartment.
    - If called using the stack ID, returns the specified stack.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stacks = oci.ResourceManager.get_stacks(compartment_id=compartment_id,
        display_name=stack_display_name,
        id=stack_id,
        state=stack_state)
    ```


    :param str compartment_id: The compartment [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to filter.
    :param str display_name: Display name on which to query.
    :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) on which to query for a stack.
    :param str state: A filter that returns only those resources that match the specified lifecycle state. The state value is case-insensitive.
           
           Allowable values:
           * CREATING
           * ACTIVE
           * DELETING
           * DELETED
    """
    ...
