# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['MetricExtensionsTestManagementArgs', 'MetricExtensionsTestManagement']

@pulumi.input_type
class MetricExtensionsTestManagementArgs:
    def __init__(__self__, *,
                 metric_extension_id: pulumi.Input[str],
                 resource_ids: pulumi.Input[str]):
        """
        The set of arguments for constructing a MetricExtensionsTestManagement resource.
        :param pulumi.Input[str] metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        :param pulumi.Input[str] resource_ids: List of Resource IDs [OCID]. Currently, supports only one resource id per request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "metric_extension_id", metric_extension_id)
        pulumi.set(__self__, "resource_ids", resource_ids)

    @property
    @pulumi.getter(name="metricExtensionId")
    def metric_extension_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        """
        return pulumi.get(self, "metric_extension_id")

    @metric_extension_id.setter
    def metric_extension_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_extension_id", value)

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Input[str]:
        """
        List of Resource IDs [OCID]. Currently, supports only one resource id per request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_ids", value)


@pulumi.input_type
class _MetricExtensionsTestManagementState:
    def __init__(__self__, *,
                 metric_extension_id: Optional[pulumi.Input[str]] = None,
                 resource_ids: Optional[pulumi.Input[str]] = None,
                 test_run_id: Optional[pulumi.Input[str]] = None,
                 test_run_metric_suffix: Optional[pulumi.Input[str]] = None,
                 test_run_namespace_name: Optional[pulumi.Input[str]] = None,
                 test_run_resource_group_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MetricExtensionsTestManagement resources.
        :param pulumi.Input[str] metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        :param pulumi.Input[str] resource_ids: List of Resource IDs [OCID]. Currently, supports only one resource id per request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] test_run_id: Test Run Id
        :param pulumi.Input[str] test_run_metric_suffix: Test Run Metric Suffix
        :param pulumi.Input[str] test_run_namespace_name: Test Run Namespace name
        :param pulumi.Input[str] test_run_resource_group_name: Test Run Resource Group name
        """
        if metric_extension_id is not None:
            pulumi.set(__self__, "metric_extension_id", metric_extension_id)
        if resource_ids is not None:
            pulumi.set(__self__, "resource_ids", resource_ids)
        if test_run_id is not None:
            pulumi.set(__self__, "test_run_id", test_run_id)
        if test_run_metric_suffix is not None:
            pulumi.set(__self__, "test_run_metric_suffix", test_run_metric_suffix)
        if test_run_namespace_name is not None:
            pulumi.set(__self__, "test_run_namespace_name", test_run_namespace_name)
        if test_run_resource_group_name is not None:
            pulumi.set(__self__, "test_run_resource_group_name", test_run_resource_group_name)

    @property
    @pulumi.getter(name="metricExtensionId")
    def metric_extension_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        """
        return pulumi.get(self, "metric_extension_id")

    @metric_extension_id.setter
    def metric_extension_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_extension_id", value)

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Optional[pulumi.Input[str]]:
        """
        List of Resource IDs [OCID]. Currently, supports only one resource id per request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_ids")

    @resource_ids.setter
    def resource_ids(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_ids", value)

    @property
    @pulumi.getter(name="testRunId")
    def test_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        Test Run Id
        """
        return pulumi.get(self, "test_run_id")

    @test_run_id.setter
    def test_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_run_id", value)

    @property
    @pulumi.getter(name="testRunMetricSuffix")
    def test_run_metric_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Test Run Metric Suffix
        """
        return pulumi.get(self, "test_run_metric_suffix")

    @test_run_metric_suffix.setter
    def test_run_metric_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_run_metric_suffix", value)

    @property
    @pulumi.getter(name="testRunNamespaceName")
    def test_run_namespace_name(self) -> Optional[pulumi.Input[str]]:
        """
        Test Run Namespace name
        """
        return pulumi.get(self, "test_run_namespace_name")

    @test_run_namespace_name.setter
    def test_run_namespace_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_run_namespace_name", value)

    @property
    @pulumi.getter(name="testRunResourceGroupName")
    def test_run_resource_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        Test Run Resource Group name
        """
        return pulumi.get(self, "test_run_resource_group_name")

    @test_run_resource_group_name.setter
    def test_run_resource_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "test_run_resource_group_name", value)


class MetricExtensionsTestManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metric_extension_id: Optional[pulumi.Input[str]] = None,
                 resource_ids: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Metric Extensions Test Management resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Performs test of Metric Extension on a specific resource Id

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_metric_extensions_test_management = oci.stack_monitoring.MetricExtensionsTestManagement("test_metric_extensions_test_management",
            metric_extension_id=test_metric_extension["id"],
            resource_ids=metric_extensions_test_management_resource_ids[0])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        :param pulumi.Input[str] resource_ids: List of Resource IDs [OCID]. Currently, supports only one resource id per request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MetricExtensionsTestManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Metric Extensions Test Management resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Performs test of Metric Extension on a specific resource Id

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_metric_extensions_test_management = oci.stack_monitoring.MetricExtensionsTestManagement("test_metric_extensions_test_management",
            metric_extension_id=test_metric_extension["id"],
            resource_ids=metric_extensions_test_management_resource_ids[0])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param MetricExtensionsTestManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MetricExtensionsTestManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 metric_extension_id: Optional[pulumi.Input[str]] = None,
                 resource_ids: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MetricExtensionsTestManagementArgs.__new__(MetricExtensionsTestManagementArgs)

            if metric_extension_id is None and not opts.urn:
                raise TypeError("Missing required property 'metric_extension_id'")
            __props__.__dict__["metric_extension_id"] = metric_extension_id
            if resource_ids is None and not opts.urn:
                raise TypeError("Missing required property 'resource_ids'")
            __props__.__dict__["resource_ids"] = resource_ids
            __props__.__dict__["test_run_id"] = None
            __props__.__dict__["test_run_metric_suffix"] = None
            __props__.__dict__["test_run_namespace_name"] = None
            __props__.__dict__["test_run_resource_group_name"] = None
        super(MetricExtensionsTestManagement, __self__).__init__(
            'oci:StackMonitoring/metricExtensionsTestManagement:MetricExtensionsTestManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            metric_extension_id: Optional[pulumi.Input[str]] = None,
            resource_ids: Optional[pulumi.Input[str]] = None,
            test_run_id: Optional[pulumi.Input[str]] = None,
            test_run_metric_suffix: Optional[pulumi.Input[str]] = None,
            test_run_namespace_name: Optional[pulumi.Input[str]] = None,
            test_run_resource_group_name: Optional[pulumi.Input[str]] = None) -> 'MetricExtensionsTestManagement':
        """
        Get an existing MetricExtensionsTestManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] metric_extension_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        :param pulumi.Input[str] resource_ids: List of Resource IDs [OCID]. Currently, supports only one resource id per request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] test_run_id: Test Run Id
        :param pulumi.Input[str] test_run_metric_suffix: Test Run Metric Suffix
        :param pulumi.Input[str] test_run_namespace_name: Test Run Namespace name
        :param pulumi.Input[str] test_run_resource_group_name: Test Run Resource Group name
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MetricExtensionsTestManagementState.__new__(_MetricExtensionsTestManagementState)

        __props__.__dict__["metric_extension_id"] = metric_extension_id
        __props__.__dict__["resource_ids"] = resource_ids
        __props__.__dict__["test_run_id"] = test_run_id
        __props__.__dict__["test_run_metric_suffix"] = test_run_metric_suffix
        __props__.__dict__["test_run_namespace_name"] = test_run_namespace_name
        __props__.__dict__["test_run_resource_group_name"] = test_run_resource_group_name
        return MetricExtensionsTestManagement(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="metricExtensionId")
    def metric_extension_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the metric extension resource.
        """
        return pulumi.get(self, "metric_extension_id")

    @property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> pulumi.Output[str]:
        """
        List of Resource IDs [OCID]. Currently, supports only one resource id per request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "resource_ids")

    @property
    @pulumi.getter(name="testRunId")
    def test_run_id(self) -> pulumi.Output[str]:
        """
        Test Run Id
        """
        return pulumi.get(self, "test_run_id")

    @property
    @pulumi.getter(name="testRunMetricSuffix")
    def test_run_metric_suffix(self) -> pulumi.Output[str]:
        """
        Test Run Metric Suffix
        """
        return pulumi.get(self, "test_run_metric_suffix")

    @property
    @pulumi.getter(name="testRunNamespaceName")
    def test_run_namespace_name(self) -> pulumi.Output[str]:
        """
        Test Run Namespace name
        """
        return pulumi.get(self, "test_run_namespace_name")

    @property
    @pulumi.getter(name="testRunResourceGroupName")
    def test_run_resource_group_name(self) -> pulumi.Output[str]:
        """
        Test Run Resource Group name
        """
        return pulumi.get(self, "test_run_resource_group_name")

