# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StreamPoolArgs', 'StreamPool']

@pulumi.input_type
class StreamPoolArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 custom_encryption_key: Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kafka_settings: Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_endpoint_settings: Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']] = None):
        """
        The set of arguments for constructing a StreamPool resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input['StreamPoolCustomEncryptionKeyArgs'] custom_encryption_key: (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['StreamPoolKafkaSettingsArgs'] kafka_settings: (Updatable) Settings for the Kafka compatibility layer.
        :param pulumi.Input[str] name: (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        :param pulumi.Input['StreamPoolPrivateEndpointSettingsArgs'] private_endpoint_settings: Optional parameters if a private stream pool is requested.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_encryption_key is not None:
            pulumi.set(__self__, "custom_encryption_key", custom_encryption_key)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if kafka_settings is not None:
            pulumi.set(__self__, "kafka_settings", kafka_settings)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_settings is not None:
            pulumi.set(__self__, "private_endpoint_settings", private_endpoint_settings)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="customEncryptionKey")
    def custom_encryption_key(self) -> Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']]:
        """
        (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        """
        return pulumi.get(self, "custom_encryption_key")

    @custom_encryption_key.setter
    def custom_encryption_key(self, value: Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']]):
        pulumi.set(self, "custom_encryption_key", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']]:
        """
        (Updatable) Settings for the Kafka compatibility layer.
        """
        return pulumi.get(self, "kafka_settings")

    @kafka_settings.setter
    def kafka_settings(self, value: Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']]):
        pulumi.set(self, "kafka_settings", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateEndpointSettings")
    def private_endpoint_settings(self) -> Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']]:
        """
        Optional parameters if a private stream pool is requested.
        """
        return pulumi.get(self, "private_endpoint_settings")

    @private_endpoint_settings.setter
    def private_endpoint_settings(self, value: Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']]):
        pulumi.set(self, "private_endpoint_settings", value)


@pulumi.input_type
class _StreamPoolState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_encryption_key: Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 endpoint_fqdn: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 is_private: Optional[pulumi.Input[bool]] = None,
                 kafka_settings: Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']] = None,
                 lifecycle_state_details: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_endpoint_settings: Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering StreamPool resources.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input['StreamPoolCustomEncryptionKeyArgs'] custom_encryption_key: (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] endpoint_fqdn: The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_private: True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        :param pulumi.Input['StreamPoolKafkaSettingsArgs'] kafka_settings: (Updatable) Settings for the Kafka compatibility layer.
        :param pulumi.Input[str] lifecycle_state_details: Any additional details about the current state of the stream.
        :param pulumi.Input[str] name: (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        :param pulumi.Input['StreamPoolPrivateEndpointSettingsArgs'] private_endpoint_settings: Optional parameters if a private stream pool is requested.
        :param pulumi.Input[str] state: The current state of the stream pool.
        :param pulumi.Input[str] time_created: The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if custom_encryption_key is not None:
            pulumi.set(__self__, "custom_encryption_key", custom_encryption_key)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if endpoint_fqdn is not None:
            pulumi.set(__self__, "endpoint_fqdn", endpoint_fqdn)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_private is not None:
            pulumi.set(__self__, "is_private", is_private)
        if kafka_settings is not None:
            pulumi.set(__self__, "kafka_settings", kafka_settings)
        if lifecycle_state_details is not None:
            pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_endpoint_settings is not None:
            pulumi.set(__self__, "private_endpoint_settings", private_endpoint_settings)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="customEncryptionKey")
    def custom_encryption_key(self) -> Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']]:
        """
        (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        """
        return pulumi.get(self, "custom_encryption_key")

    @custom_encryption_key.setter
    def custom_encryption_key(self, value: Optional[pulumi.Input['StreamPoolCustomEncryptionKeyArgs']]):
        pulumi.set(self, "custom_encryption_key", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @endpoint_fqdn.setter
    def endpoint_fqdn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint_fqdn", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> Optional[pulumi.Input[bool]]:
        """
        True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        """
        return pulumi.get(self, "is_private")

    @is_private.setter
    def is_private(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_private", value)

    @property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']]:
        """
        (Updatable) Settings for the Kafka compatibility layer.
        """
        return pulumi.get(self, "kafka_settings")

    @kafka_settings.setter
    def kafka_settings(self, value: Optional[pulumi.Input['StreamPoolKafkaSettingsArgs']]):
        pulumi.set(self, "kafka_settings", value)

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> Optional[pulumi.Input[str]]:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_state_details", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateEndpointSettings")
    def private_endpoint_settings(self) -> Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']]:
        """
        Optional parameters if a private stream pool is requested.
        """
        return pulumi.get(self, "private_endpoint_settings")

    @private_endpoint_settings.setter
    def private_endpoint_settings(self, value: Optional[pulumi.Input['StreamPoolPrivateEndpointSettingsArgs']]):
        pulumi.set(self, "private_endpoint_settings", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the stream pool.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class StreamPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_encryption_key: Optional[pulumi.Input[Union['StreamPoolCustomEncryptionKeyArgs', 'StreamPoolCustomEncryptionKeyArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kafka_settings: Optional[pulumi.Input[Union['StreamPoolKafkaSettingsArgs', 'StreamPoolKafkaSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_endpoint_settings: Optional[pulumi.Input[Union['StreamPoolPrivateEndpointSettingsArgs', 'StreamPoolPrivateEndpointSettingsArgsDict']]] = None,
                 __props__=None):
        """
        This resource provides the Stream Pool resource in Oracle Cloud Infrastructure Streaming service.

        Starts the provisioning of a new stream pool.
        To track the progress of the provisioning, you can periodically call GetStreamPool.
        In the response, the `lifecycleState` parameter of the object tells you its current state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_pool = oci.streaming.StreamPool("test_stream_pool",
            compartment_id=compartment_id,
            name=stream_pool_name,
            custom_encryption_key={
                "kms_key_id": test_key["id"],
            },
            defined_tags=stream_pool_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            kafka_settings={
                "auto_create_topics_enable": stream_pool_kafka_settings_auto_create_topics_enable,
                "bootstrap_servers": stream_pool_kafka_settings_bootstrap_servers,
                "log_retention_hours": stream_pool_kafka_settings_log_retention_hours,
                "num_partitions": stream_pool_kafka_settings_num_partitions,
            },
            private_endpoint_settings={
                "nsg_ids": stream_pool_private_endpoint_settings_nsg_ids,
                "private_endpoint_ip": stream_pool_private_endpoint_settings_private_endpoint_ip,
                "subnet_id": test_subnet["id"],
            })
        ```

        ## Import

        StreamPools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Streaming/streamPool:StreamPool test_stream_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Union['StreamPoolCustomEncryptionKeyArgs', 'StreamPoolCustomEncryptionKeyArgsDict']] custom_encryption_key: (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['StreamPoolKafkaSettingsArgs', 'StreamPoolKafkaSettingsArgsDict']] kafka_settings: (Updatable) Settings for the Kafka compatibility layer.
        :param pulumi.Input[str] name: (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        :param pulumi.Input[Union['StreamPoolPrivateEndpointSettingsArgs', 'StreamPoolPrivateEndpointSettingsArgsDict']] private_endpoint_settings: Optional parameters if a private stream pool is requested.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StreamPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Stream Pool resource in Oracle Cloud Infrastructure Streaming service.

        Starts the provisioning of a new stream pool.
        To track the progress of the provisioning, you can periodically call GetStreamPool.
        In the response, the `lifecycleState` parameter of the object tells you its current state.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_stream_pool = oci.streaming.StreamPool("test_stream_pool",
            compartment_id=compartment_id,
            name=stream_pool_name,
            custom_encryption_key={
                "kms_key_id": test_key["id"],
            },
            defined_tags=stream_pool_defined_tags,
            freeform_tags={
                "Department": "Finance",
            },
            kafka_settings={
                "auto_create_topics_enable": stream_pool_kafka_settings_auto_create_topics_enable,
                "bootstrap_servers": stream_pool_kafka_settings_bootstrap_servers,
                "log_retention_hours": stream_pool_kafka_settings_log_retention_hours,
                "num_partitions": stream_pool_kafka_settings_num_partitions,
            },
            private_endpoint_settings={
                "nsg_ids": stream_pool_private_endpoint_settings_nsg_ids,
                "private_endpoint_ip": stream_pool_private_endpoint_settings_private_endpoint_ip,
                "subnet_id": test_subnet["id"],
            })
        ```

        ## Import

        StreamPools can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Streaming/streamPool:StreamPool test_stream_pool "id"
        ```

        :param str resource_name: The name of the resource.
        :param StreamPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StreamPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 custom_encryption_key: Optional[pulumi.Input[Union['StreamPoolCustomEncryptionKeyArgs', 'StreamPoolCustomEncryptionKeyArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kafka_settings: Optional[pulumi.Input[Union['StreamPoolKafkaSettingsArgs', 'StreamPoolKafkaSettingsArgsDict']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_endpoint_settings: Optional[pulumi.Input[Union['StreamPoolPrivateEndpointSettingsArgs', 'StreamPoolPrivateEndpointSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StreamPoolArgs.__new__(StreamPoolArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["custom_encryption_key"] = custom_encryption_key
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["kafka_settings"] = kafka_settings
            __props__.__dict__["name"] = name
            __props__.__dict__["private_endpoint_settings"] = private_endpoint_settings
            __props__.__dict__["endpoint_fqdn"] = None
            __props__.__dict__["is_private"] = None
            __props__.__dict__["lifecycle_state_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(StreamPool, __self__).__init__(
            'oci:Streaming/streamPool:StreamPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            custom_encryption_key: Optional[pulumi.Input[Union['StreamPoolCustomEncryptionKeyArgs', 'StreamPoolCustomEncryptionKeyArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            endpoint_fqdn: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            is_private: Optional[pulumi.Input[bool]] = None,
            kafka_settings: Optional[pulumi.Input[Union['StreamPoolKafkaSettingsArgs', 'StreamPoolKafkaSettingsArgsDict']]] = None,
            lifecycle_state_details: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            private_endpoint_settings: Optional[pulumi.Input[Union['StreamPoolPrivateEndpointSettingsArgs', 'StreamPoolPrivateEndpointSettingsArgsDict']]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'StreamPool':
        """
        Get an existing StreamPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the stream.
        :param pulumi.Input[Union['StreamPoolCustomEncryptionKeyArgs', 'StreamPoolCustomEncryptionKeyArgsDict']] custom_encryption_key: (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] endpoint_fqdn: The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[bool] is_private: True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        :param pulumi.Input[Union['StreamPoolKafkaSettingsArgs', 'StreamPoolKafkaSettingsArgsDict']] kafka_settings: (Updatable) Settings for the Kafka compatibility layer.
        :param pulumi.Input[str] lifecycle_state_details: Any additional details about the current state of the stream.
        :param pulumi.Input[str] name: (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        :param pulumi.Input[Union['StreamPoolPrivateEndpointSettingsArgs', 'StreamPoolPrivateEndpointSettingsArgsDict']] private_endpoint_settings: Optional parameters if a private stream pool is requested.
        :param pulumi.Input[str] state: The current state of the stream pool.
        :param pulumi.Input[str] time_created: The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StreamPoolState.__new__(_StreamPoolState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["custom_encryption_key"] = custom_encryption_key
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["endpoint_fqdn"] = endpoint_fqdn
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_private"] = is_private
        __props__.__dict__["kafka_settings"] = kafka_settings
        __props__.__dict__["lifecycle_state_details"] = lifecycle_state_details
        __props__.__dict__["name"] = name
        __props__.__dict__["private_endpoint_settings"] = private_endpoint_settings
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        return StreamPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the stream.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="customEncryptionKey")
    def custom_encryption_key(self) -> pulumi.Output['outputs.StreamPoolCustomEncryptionKey']:
        """
        (Updatable) The OCID of the custom encryption key to be used or deleted if currently being used.
        """
        return pulumi.get(self, "custom_encryption_key")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointFqdn")
    def endpoint_fqdn(self) -> pulumi.Output[str]:
        """
        The FQDN used to access the streams inside the stream pool (same FQDN as the messagesEndpoint attribute of a [Stream](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/Stream) object). If the stream pool is private, the FQDN is customized and can only be accessed from inside the associated subnetId, otherwise the FQDN is publicly resolvable. Depending on which protocol you attempt to use, you need to either prepend https or append the Kafka port.
        """
        return pulumi.get(self, "endpoint_fqdn")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair that is applied with no predefined name, type, or namespace. Exists for cross-compatibility only. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPrivate")
    def is_private(self) -> pulumi.Output[bool]:
        """
        True if the stream pool is private, false otherwise. The associated endpoint and subnetId of a private stream pool can be retrieved through the [GetStreamPool](https://docs.cloud.oracle.com/iaas/api/#/en/streaming/20180418/StreamPool/GetStreamPool) API.
        """
        return pulumi.get(self, "is_private")

    @property
    @pulumi.getter(name="kafkaSettings")
    def kafka_settings(self) -> pulumi.Output['outputs.StreamPoolKafkaSettings']:
        """
        (Updatable) Settings for the Kafka compatibility layer.
        """
        return pulumi.get(self, "kafka_settings")

    @property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> pulumi.Output[str]:
        """
        Any additional details about the current state of the stream.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        (Updatable) The name of the stream pool. Avoid entering confidential information.  Example: `MyStreamPool`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateEndpointSettings")
    def private_endpoint_settings(self) -> pulumi.Output['outputs.StreamPoolPrivateEndpointSettings']:
        """
        Optional parameters if a private stream pool is requested.
        """
        return pulumi.get(self, "private_endpoint_settings")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the stream pool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the stream pool was created, expressed in in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2018-04-20T00:00:07.405Z`
        """
        return pulumi.get(self, "time_created")

