import os
import pathlib
from . import base
from ..core.base import AbstractNestedEntity, ExecutorEntity
from ..core.formatter import FormattedEntity
from _typeshed import Incomplete
from pathlib import PurePath

class AsyncFile:
    fd: Incomplete
    storage: Incomplete
    def __init__(self, fd, storage: Incomplete | None = ...) -> None: ...
    async def read(self, *args, **kwargs): ...
    async def write(self, *args, **kwargs): ...
    async def __aenter__(self): ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> None: ...
    async def close(self) -> None: ...
    def __aiter__(self): ...
    async def __anext__(self): ...

class AsyncFileContextManager:
    path: Incomplete
    af: Incomplete
    mode: Incomplete
    def __init__(self, path, *args, **kwargs) -> None: ...
    async def __aenter__(self): ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> None: ...
    def __await__(self): ...

class AsyncGlob:
    storage: Incomplete
    def __init__(self, path, pattern) -> None: ...
    def __aiter__(self): ...
    async def __anext__(self): ...

class AsyncPath(PurePath):
    def __new__(cls, *args, storage: Incomplete | None = ...): ...
    async def exists(self) -> bool: ...
    async def mkdir(self, *args, **kwargs): ...
    async def stat(self) -> os.stat_result: ...
    async def unlink(self): ...
    async def read_text(self, *args, **kwargs): ...
    async def write_text(self, *args, **kwargs): ...
    async def read_bytes(self, *args, **kwargs): ...
    async def write_bytes(self, *args, **kwargs): ...
    def open(self, *args, **kwargs): ...
    @property
    def parent(self): ...
    @property
    def normpath(self): ...
    def glob(self, pattern): ...

class AsyncPosixPath(AsyncPath, pathlib.PurePosixPath): ...
class AsyncWindowsPath(AsyncPath, pathlib.PureWindowsPath): ...

class MockFileSystemStorage(ExecutorEntity):
    def set_config(self, config) -> None: ...
    @property
    def loop(self): ...
    async def next_space_waiter(self) -> None: ...

class BaseFileSystemStorage(AbstractNestedEntity, ExecutorEntity, FormattedEntity, base.AbstractStorage):
    PARAM_LIMIT_FREE_SPACE: str
    def __init__(self, *args, **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    def factory(self, item, config: Incomplete | None = ...): ...
    def disk_usage(self): ...
    async def get_free_space(self): ...
    async def wait_free_space(self, size: Incomplete | None = ...) -> None: ...
    async def next_space_waiter(self) -> None: ...
    def path_transform(self, rel_path: str): ...
    def raw_key(self, *key): ...
    async def set(self, key, value) -> None: ...
    async def get(self, key): ...
    def open(self, key, *args, **kwargs): ...
    def copy(self, key_source, storage_dest, key_dest): ...
    def move(self, key_source, storage_dest, key_dest): ...

class FileSystemStorage(BaseFileSystemStorage, base.AbstractListedStorage):
    def list(self, glob: str = ...): ...
    async def length(self, glob: str = ...): ...

class NestedFileSystemStorage(BaseFileSystemStorage):
    def path_transform(self, rel_path: str): ...

class HashFileSystemStorage(NestedFileSystemStorage):
    def path_transform(self, rel_path: str): ...
