from .base import AbstractQueue as AbstractQueue, ScoreQueueMixin as ScoreQueueMixin
from _typeshed import Incomplete
from typing import Any, NamedTuple

class Item(NamedTuple):
    value: Any
    timestamp: float
    scheduled: bool
    def __lt__(self, other) -> bool: ...

class TimestampQueue(ScoreQueueMixin, AbstractQueue):
    default_score: str
    def __init__(self, *args, add_score: float = ..., maxsize: int = ..., **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    def set_context(self, context): ...
    async def cleanup(self) -> None: ...
    async def __aenter__(self): ...
    async def __aexit__(self, exc_type, exc_val, exc_tb) -> None: ...
    def __len__(self): ...
    def empty(self) -> bool: ...
    def full(self) -> bool: ...
    async def get(self, score: bool = ..., *, timeout: float = ...): ...
    async def put(self, value, score: Incomplete | None = ...) -> None: ...

class UniqueQueue(TimestampQueue):
    def __init__(self, *args, **kwargs) -> None: ...
    def __len__(self) -> int: ...
    def empty(self) -> bool: ...
