import abc
from ..core.base import AbstractNamedEntity as AbstractNamedEntity, LoggingEntity as LoggingEntity
from ..utils import import_name as import_name
from _typeshed import Incomplete
from abc import abstractmethod
from typing import Dict

class AbstractWorker(LoggingEntity, AbstractNamedEntity, metaclass=abc.ABCMeta):
    @abstractmethod
    async def start(self): ...
    @abstractmethod
    async def stop(self): ...
    @abstractmethod
    async def status(self): ...

class Worker(AbstractWorker):
    counter: Dict
    def __init__(self, *args, **kwargs) -> None: ...
    def set_config(self, config) -> None: ...
    async def init(self) -> None: ...
    @property
    def input(self): ...
    @property
    def output(self): ...
    async def work(self) -> None: ...
    async def runner(self) -> None: ...
    async def run(self, value: Incomplete | None = ...) -> None: ...
    def __call__(self, *args, **kwargs): ...
    @property
    def started_at(self): ...
    @property
    def stopped_at(self): ...
    def running(self): ...
    async def start(self) -> None: ...
    async def stop(self, force: bool = ...) -> None: ...
    async def status(self): ...
