# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, conint, constr

class Leftover(BaseModel):
    """
    A leftover. 
    """
    crop_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Crop key.")
    humidity: conint(strict=True, le=999, ge=1) = Field(..., description="Humidity crop, in ppm (‰).")
    target_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Target key.")
    target_detail_key: Optional[constr(strict=True, max_length=1024, min_length=1)] = Field(None, description="Target storage key.")
    amount: conint(strict=True, le=10000000, ge=0) = Field(..., description="Weight, in tn.")
    __properties = ["crop_key", "humidity", "target_key", "target_detail_key", "amount"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Leftover:
        """Create an instance of Leftover from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if target_detail_key (nullable) is None
        # and __fields_set__ contains the field
        if self.target_detail_key is None and "target_detail_key" in self.__fields_set__:
            _dict['target_detail_key'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Leftover:
        """Create an instance of Leftover from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Leftover.parse_obj(obj)

        _obj = Leftover.parse_obj({
            "crop_key": obj.get("crop_key"),
            "humidity": obj.get("humidity"),
            "target_key": obj.get("target_key"),
            "target_detail_key": obj.get("target_detail_key"),
            "amount": obj.get("amount")
        })
        return _obj

