# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, constr
from vrt_lss_agro.models.operation_measurements import OperationMeasurements
from vrt_lss_agro.models.operation_target import OperationTarget
from vrt_lss_agro.models.operation_type import OperationType

class Operation(BaseModel):
    """
    Grain processing operation. 
    """
    type: OperationType = Field(...)
    crop_key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Crop key.")
    source: OperationTarget = Field(...)
    destination: OperationTarget = Field(...)
    measurements: OperationMeasurements = Field(...)
    __properties = ["type", "crop_key", "source", "destination", "measurements"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Operation:
        """Create an instance of Operation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of source
        if self.source:
            _dict['source'] = self.source.to_dict()
        # override the default output from pydantic by calling `to_dict()` of destination
        if self.destination:
            _dict['destination'] = self.destination.to_dict()
        # override the default output from pydantic by calling `to_dict()` of measurements
        if self.measurements:
            _dict['measurements'] = self.measurements.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Operation:
        """Create an instance of Operation from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Operation.parse_obj(obj)

        _obj = Operation.parse_obj({
            "type": obj.get("type"),
            "crop_key": obj.get("crop_key"),
            "source": OperationTarget.from_dict(obj.get("source")) if obj.get("source") is not None else None,
            "destination": OperationTarget.from_dict(obj.get("destination")) if obj.get("destination") is not None else None,
            "measurements": OperationMeasurements.from_dict(obj.get("measurements")) if obj.get("measurements") is not None else None
        })
        return _obj

