# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conint, conlist, constr
from vrt_lss_agro.models.attribute import Attribute
from vrt_lss_agro.models.capacity_forecast_element import CapacityForecastElement
from vrt_lss_agro.models.cost_forecast_element import CostForecastElement

class Silo(BaseModel):
    """
    A long-term storage. 
    """
    key: constr(strict=True, max_length=1024, min_length=1) = Field(..., description="Key, unique identifier.")
    type: constr(strict=True, max_length=256, min_length=1) = Field(..., description="The type of long-term storage location.")
    capacity_forecast: conlist(CapacityForecastElement, max_items=3653, min_items=0) = Field(..., description="Capacity forecast.")
    cost_forecast: Optional[conlist(CostForecastElement, max_items=3653, min_items=0)] = Field(None, description="Cost forecast.")
    deployment_cost: Optional[conint(strict=True, le=1000000, ge=0)] = Field(0, description="The total cost of deployment, in conventional monetary units. ")
    collapse_cost: Optional[conint(strict=True, le=1000000, ge=0)] = Field(0, description="The total cost of collapse, in conventional monetary units. ")
    attributes: Optional[conlist(Attribute, max_items=1000, min_items=0, unique_items=True)] = Field(None, description="Attributes. Used to add service information.")
    __properties = ["key", "type", "capacity_forecast", "cost_forecast", "deployment_cost", "collapse_cost", "attributes"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Silo:
        """Create an instance of Silo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in capacity_forecast (list)
        _items = []
        if self.capacity_forecast:
            for _item in self.capacity_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['capacity_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in cost_forecast (list)
        _items = []
        if self.cost_forecast:
            for _item in self.cost_forecast:
                if _item:
                    _items.append(_item.to_dict())
            _dict['cost_forecast'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in attributes (list)
        _items = []
        if self.attributes:
            for _item in self.attributes:
                if _item:
                    _items.append(_item.to_dict())
            _dict['attributes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Silo:
        """Create an instance of Silo from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Silo.parse_obj(obj)

        _obj = Silo.parse_obj({
            "key": obj.get("key"),
            "type": obj.get("type"),
            "capacity_forecast": [CapacityForecastElement.from_dict(_item) for _item in obj.get("capacity_forecast")] if obj.get("capacity_forecast") is not None else None,
            "cost_forecast": [CostForecastElement.from_dict(_item) for _item in obj.get("cost_forecast")] if obj.get("cost_forecast") is not None else None,
            "deployment_cost": obj.get("deployment_cost") if obj.get("deployment_cost") is not None else 0,
            "collapse_cost": obj.get("collapse_cost") if obj.get("collapse_cost") is not None else 0,
            "attributes": [Attribute.from_dict(_item) for _item in obj.get("attributes")] if obj.get("attributes") is not None else None
        })
        return _obj

