# coding: utf-8

"""
    VRt.Agro [AG]

    The version of the OpenAPI document: 6.11.2097

    Generated by OpenAPI Generator: 6.6.0

    Do not edit the code manually

    2023 Veeroute
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, conlist, constr

class UnplannedItems(BaseModel):
    """
    Unplanned items list.
    """
    crop_keys: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=501, min_items=0, unique_items=True)] = Field(None, description="Unplanned crop keys.")
    field_keys: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=20001, min_items=0, unique_items=True)] = Field(None, description="Unplanned field keys.")
    elevator_keys: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=501, min_items=0, unique_items=True)] = Field(None, description="Unplanned elevator keys.")
    factory_keys: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=501, min_items=0, unique_items=True)] = Field(None, description="Unplanned factory keys.")
    market_keys: Optional[conlist(constr(strict=True, max_length=1024, min_length=1), max_items=501, min_items=0, unique_items=True)] = Field(None, description="Unplanned market keys.")
    __properties = ["crop_keys", "field_keys", "elevator_keys", "factory_keys", "market_keys"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> UnplannedItems:
        """Create an instance of UnplannedItems from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> UnplannedItems:
        """Create an instance of UnplannedItems from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return UnplannedItems.parse_obj(obj)

        _obj = UnplannedItems.parse_obj({
            "crop_keys": obj.get("crop_keys"),
            "field_keys": obj.get("field_keys"),
            "elevator_keys": obj.get("elevator_keys"),
            "factory_keys": obj.get("factory_keys"),
            "market_keys": obj.get("market_keys")
        })
        return _obj

