# -*- coding: utf-8 -*-

# Mathmaker creates automatically maths exercises sheets
# with their answers
# Copyright 2006-2017 Nicolas Hainaux <nh.techn@gmail.com>

# This file is part of Mathmaker.

# Mathmaker is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# any later version.

# Mathmaker is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Mathmaker; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


ALL_TRIPLES_5_100 = [
    [3, 4, 5],
    [6, 8, 10],
    [5, 12, 13],
    [9, 12, 15],
    [8, 15, 17],
    [12, 16, 20],
    [7, 24, 25],
    [15, 20, 25],
    [10, 24, 26],
    [20, 21, 29],
    [18, 24, 30],
    [16, 30, 34],
    [21, 28, 35],
    [12, 35, 37],
    [15, 36, 39],
    [24, 32, 40],
    [9, 40, 41],
    [27, 36, 45],
    [14, 48, 50],
    [24, 45, 51],
    [20, 48, 52],
    [28, 45, 53],
    [33, 44, 55],
    [40, 42, 58],
    [36, 48, 60],
    [11, 60, 61],
    [16, 63, 65],
    [25, 60, 65],
    [33, 56, 65],
    [39, 52, 65],
    [32, 60, 68],
    [42, 56, 70],
    [48, 55, 73],
    [24, 70, 74],
    [21, 72, 75],
    [45, 60, 75],
    [30, 72, 78],
    [48, 64, 80],
    [18, 80, 82],
    [13, 84, 85],
    [36, 77, 85],
    [40, 75, 85],
    [51, 68, 85],
    [60, 63, 87],
    [39, 80, 89],
    [54, 72, 90],
    [35, 84, 91],
    [57, 76, 95],
    [65, 72, 97],
    [28, 96, 100]]

TRIPLES_101_200_WO_TEN_MULTIPLES = [
    [20, 99, 101],
    [48, 90, 102],
    [40, 96, 104],
    [63, 84, 105],
    [56, 90, 106],
    [60, 91, 109],
    [66, 88, 110],
    [36, 105, 111],
    [15, 112, 113],
    [69, 92, 115],
    [80, 84, 116],
    [45, 108, 117],
    [56, 105, 119],
    [72, 96, 120],
    [22, 120, 122],
    [27, 120, 123],
    [35, 120, 125],
    [44, 117, 125],
    [75, 100, 125],
    [32, 126, 130],
    [66, 112, 130],
    [78, 104, 130],
    [81, 108, 135],
    [64, 120, 136],
    [88, 105, 137],
    [84, 112, 140],
    [55, 132, 143],
    [17, 144, 145],
    [24, 143, 145],
    [87, 116, 145],
    [100, 105, 145],
    [96, 110, 146],
    [48, 140, 148],
    [51, 140, 149],
    [42, 144, 150],
    [72, 135, 153],
    [93, 124, 155],
    [60, 144, 156],
    [85, 132, 157],
    [84, 135, 159],
    [96, 128, 160],
    [36, 160, 164],
    [99, 132, 165],
    [65, 156, 169],
    [119, 120, 169],
    [26, 168, 170],
    [72, 154, 170],
    [102, 136, 170],
    [52, 165, 173],
    [120, 126, 174],
    [49, 168, 175],
    [105, 140, 175],
    [78, 160, 178],
    [108, 144, 180],
    [19, 180, 181],
    [70, 168, 182],
    [33, 180, 183],
    [57, 176, 185],
    [60, 175, 185],
    [104, 153, 185],
    [111, 148, 185],
    [88, 165, 187],
    [114, 152, 190],
    [95, 168, 193],
    [130, 144, 194],
    [48, 189, 195],
    [75, 180, 195],
    [99, 168, 195],
    [117, 156, 195],
    [28, 195, 197],
    [56, 192, 200],
]

ALL_TRIPLES_5_200 = [
    [3, 4, 5],
    [6, 8, 10],
    [5, 12, 13],
    [9, 12, 15],
    [8, 15, 17],
    [12, 16, 20],
    [7, 24, 25],
    [15, 20, 25],
    [10, 24, 26],
    [20, 21, 29],
    [18, 24, 30],
    [16, 30, 34],
    [21, 28, 35],
    [12, 35, 37],
    [15, 36, 39],
    [24, 32, 40],
    [9, 40, 41],
    [27, 36, 45],
    [14, 48, 50],
    [30, 40, 50],
    [24, 45, 51],
    [20, 48, 52],
    [28, 45, 53],
    [33, 44, 55],
    [40, 42, 58],
    [36, 48, 60],
    [11, 60, 61],
    [16, 63, 65],
    [25, 60, 65],
    [33, 56, 65],
    [39, 52, 65],
    [32, 60, 68],
    [42, 56, 70],
    [48, 55, 73],
    [24, 70, 74],
    [21, 72, 75],
    [45, 60, 75],
    [30, 72, 78],
    [48, 64, 80],
    [18, 80, 82],
    [13, 84, 85],
    [36, 77, 85],
    [40, 75, 85],
    [51, 68, 85],
    [60, 63, 87],
    [39, 80, 89],
    [54, 72, 90],
    [35, 84, 91],
    [57, 76, 95],
    [65, 72, 97],
    [28, 96, 100],
    [60, 80, 100],
    [20, 99, 101],
    [48, 90, 102],
    [40, 96, 104],
    [63, 84, 105],
    [56, 90, 106],
    [60, 91, 109],
    [66, 88, 110],
    [36, 105, 111],
    [15, 112, 113],
    [69, 92, 115],
    [80, 84, 116],
    [45, 108, 117],
    [56, 105, 119],
    [72, 96, 120],
    [22, 120, 122],
    [27, 120, 123],
    [35, 120, 125],
    [44, 117, 125],
    [75, 100, 125],
    [32, 126, 130],
    [50, 120, 130],
    [66, 112, 130],
    [78, 104, 130],
    [81, 108, 135],
    [64, 120, 136],
    [88, 105, 137],
    [84, 112, 140],
    [55, 132, 143],
    [17, 144, 145],
    [24, 143, 145],
    [87, 116, 145],
    [100, 105, 145],
    [96, 110, 146],
    [48, 140, 148],
    [51, 140, 149],
    [42, 144, 150],
    [90, 120, 150],
    [72, 135, 153],
    [93, 124, 155],
    [60, 144, 156],
    [85, 132, 157],
    [84, 135, 159],
    [96, 128, 160],
    [36, 160, 164],
    [99, 132, 165],
    [65, 156, 169],
    [119, 120, 169],
    [26, 168, 170],
    [72, 154, 170],
    [80, 150, 170],
    [102, 136, 170],
    [52, 165, 173],
    [120, 126, 174],
    [49, 168, 175],
    [105, 140, 175],
    [78, 160, 178],
    [108, 144, 180],
    [19, 180, 181],
    [70, 168, 182],
    [33, 180, 183],
    [57, 176, 185],
    [60, 175, 185],
    [104, 153, 185],
    [111, 148, 185],
    [88, 165, 187],
    [114, 152, 190],
    [95, 168, 193],
    [130, 144, 194],
    [48, 189, 195],
    [75, 180, 195],
    [99, 168, 195],
    [117, 156, 195],
    [28, 195, 197],
    [56, 192, 200],
    [120, 160, 200]
]

NO_TRIPLES_LEGS_1_200 = \
    [(1, 2, 0), (1, 3, 0), (1, 4, 0), (1, 6, 0), (1, 7, 0), (2, 2, 0),
     (2, 6, 0), (2, 8, 0), (2, 9, 0), (2, 10, 0), (3, 3, 0), (3, 6, 0),
     (3, 9, 0), (3, 10, 0), (4, 6, 0), (4, 9, 0), (4, 10, 0), (5, 5, 0),
     (5, 7, 0), (5, 8, 0), (5, 10, 0), (6, 6, 0), (6, 7, 0), (6, 9, 0),
     (7, 7, 0), (7, 8, 0), (7, 10, 0), (8, 9, 0), (8, 10, 0), (9, 10, 0),
     (11, 15, 0), (11, 17, 0), (11, 19, 0), (11, 24, 0), (11, 26, 0),
     (11, 28, 0), (11, 29, 0), (11, 30, 0), (12, 14, 0), (12, 19, 0),
     (12, 20, 0), (12, 25, 0), (12, 26, 0), (12, 27, 0), (12, 28, 0),
     (12, 30, 0), (13, 13, 0), (13, 16, 0), (13, 17, 0), (13, 19, 0),
     (13, 24, 0), (13, 26, 0), (13, 27, 0), (13, 29, 0), (13, 30, 0),
     (14, 15, 0), (14, 16, 0), (14, 18, 0), (14, 21, 0), (14, 23, 0),
     (14, 24, 0), (14, 27, 0), (14, 29, 0), (15, 17, 0), (15, 18, 0),
     (15, 19, 0), (15, 21, 0), (15, 23, 0), (15, 24, 0), (15, 25, 0),
     (16, 16, 0), (16, 17, 0), (16, 19, 0), (16, 20, 0), (16, 21, 0),
     (16, 23, 0), (16, 24, 0), (16, 25, 0), (16, 26, 0), (16, 29, 0),
     (17, 17, 0), (17, 19, 0), (17, 20, 0), (17, 21, 0), (17, 22, 0),
     (17, 24, 0), (17, 26, 0), (17, 28, 0), (17, 29, 0), (18, 19, 0),
     (18, 20, 0), (18, 21, 0), (18, 22, 0), (18, 23, 0), (18, 26, 0),
     (18, 28, 0), (18, 29, 0), (19, 20, 0), (19, 21, 0), (19, 22, 0),
     (19, 24, 0), (19, 26, 0), (19, 30, 0), (20, 20, 0), (20, 22, 0),
     (20, 23, 0), (20, 24, 0), (20, 25, 0), (20, 26, 0), (20, 29, 0),
     (20, 30, 0), (21, 21, 0), (21, 22, 0), (21, 23, 0), (21, 24, 0),
     (21, 25, 0), (21, 26, 0), (21, 29, 0), (21, 30, 0), (22, 22, 0),
     (22, 23, 0), (22, 25, 0), (22, 27, 0), (22, 28, 0), (22, 29, 0),
     (22, 30, 0), (23, 23, 0), (23, 24, 0), (23, 25, 0), (23, 27, 0),
     (23, 28, 0), (23, 29, 0), (23, 30, 0), (24, 25, 0), (24, 26, 0),
     (24, 29, 0), (24, 30, 0), (25, 25, 0), (25, 26, 0), (25, 27, 0),
     (25, 29, 0), (25, 30, 0), (26, 26, 0), (26, 27, 0), (26, 29, 0),
     (26, 30, 0), (27, 28, 0), (27, 30, 0), (28, 28, 0), (28, 29, 0),
     (29, 29, 0), (29, 30, 0), (31, 61, 0), (31, 65, 0), (32, 40, 0),
     (32, 63, 0), (32, 77, 0), (33, 51, 0), (33, 81, 0), (35, 45, 0),
     (35, 47, 0), (35, 70, 0), (35, 92, 0), (36, 46, 0), (37, 51, 0),
     (38, 64, 0), (38, 65, 0), (39, 39, 0), (39, 66, 0), (40, 47, 0),
     (40, 56, 0), (40, 79, 0), (41, 59, 0), (41, 73, 0), (42, 98, 0),
     (42, 100, 0), (43, 43, 0), (43, 48, 0), (45, 88, 0), (46, 49, 0),
     (47, 49, 0), (47, 52, 0), (47, 63, 0), (49, 54, 0), (49, 81, 0),
     (49, 83, 0), (50, 54, 0), (52, 70, 0), (52, 89, 0), (52, 94, 0),
     (53, 61, 0), (54, 57, 0), (55, 67, 0), (55, 80, 0), (56, 80, 0),
     (56, 82, 0), (57, 78, 0), (58, 76, 0), (58, 84, 0), (59, 65, 0),
     (59, 87, 0), (59, 94, 0), (60, 76, 0), (60, 82, 0), (60, 88, 0),
     (60, 97, 0), (61, 67, 0), (61, 70, 0), (62, 78, 0), (63, 93, 0),
     (64, 73, 0), (65, 66, 0), (65, 88, 0), (66, 83, 0), (66, 89, 0),
     (67, 75, 0), (69, 100, 0), (70, 95, 0), (71, 73, 0), (71, 77, 0),
     (72, 87, 0), (72, 98, 0), (74, 81, 0), (74, 92, 0), (75, 79, 0),
     (76, 81, 0), (76, 82, 0), (78, 82, 0), (79, 95, 0), (79, 98, 0),
     (80, 91, 0), (80, 94, 0), (81, 99, 0), (84, 84, 0), (87, 90, 0),
     (87, 93, 0), (88, 96, 0), (93, 94, 0), (94, 99, 0), (99, 100, 0),
     (102, 118, 0), (103, 171, 0), (104, 156, 0), (105, 113, 0), (105, 147, 0),
     (106, 114, 0), (107, 153, 0), (107, 197, 0), (108, 151, 0), (109, 121, 0),
     (109, 187, 0), (110, 124, 0), (114, 160, 0), (116, 136, 0), (116, 149, 0),
     (117, 135, 0), (117, 198, 0), (117, 200, 0), (120, 134, 0), (120, 149, 0),
     (120, 153, 0), (121, 170, 0), (121, 192, 0), (122, 195, 0), (125, 140, 0),
     (126, 167, 0), (130, 160, 0), (130, 194, 0), (131, 144, 0), (131, 160, 0),
     (133, 164, 0), (133, 180, 0), (133, 181, 0), (135, 149, 0), (135, 198, 0),
     (136, 181, 0), (138, 166, 0), (138, 182, 0), (139, 169, 0), (139, 170, 0),
     (140, 181, 0), (140, 185, 0), (140, 187, 0), (141, 158, 0), (144, 170, 0),
     (146, 165, 0), (147, 162, 0), (147, 168, 0), (148, 156, 0), (149, 151, 0),
     (152, 172, 0), (153, 163, 0), (153, 173, 0), (156, 184, 0), (156, 189, 0),
     (157, 159, 0), (159, 179, 0), (160, 200, 0), (162, 191, 0), (164, 197, 0),
     (169, 170, 0), (169, 186, 0), (170, 180, 0), (171, 172, 0), (176, 200, 0),
     (177, 199, 0), (182, 198, 0), (187, 190, 0)]

NO_TRIPLES_HYPS_1_200 =\
    [(0, 9, 23), (0, 10, 34), (0, 10, 49), (0, 13, 55), (0, 14, 25),
     (0, 14, 26), (0, 14, 45), (0, 14, 58), (0, 15, 35), (0, 15, 64),
     (0, 16, 47), (0, 17, 43), (0, 17, 62), (0, 17, 69), (0, 17, 73),
     (0, 19, 58), (0, 20, 50), (0, 20, 76), (0, 20, 86), (0, 21, 64),
     (0, 21, 72), (0, 22, 58), (0, 22, 68), (0, 23, 55), (0, 23, 111),
     (0, 24, 54), (0, 24, 114), (0, 25, 54), (0, 25, 127), (0, 26, 51),
     (0, 26, 52), (0, 26, 101), (0, 26, 108), (0, 26, 113), (0, 26, 125),
     (0, 27, 71), (0, 27, 112), (0, 28, 54), (0, 28, 88), (0, 28, 117),
     (0, 28, 143), (0, 29, 58), (0, 29, 83), (0, 30, 48), (0, 30, 60),
     (0, 30, 87), (0, 30, 103), (0, 30, 107), (0, 30, 118), (0, 30, 154),
     (0, 31, 61), (0, 31, 101), (0, 32, 81), (0, 33, 39), (0, 33, 83),
     (0, 33, 113), (0, 33, 116), (0, 33, 131), (0, 34, 97), (0, 34, 137),
     (0, 34, 172), (0, 35, 50), (0, 35, 67), (0, 36, 52), (0, 36, 112),
     (0, 36, 113), (0, 36, 150), (0, 36, 156), (0, 36, 160), (0, 36, 180),
     (0, 37, 49), (0, 37, 74), (0, 37, 146), (0, 38, 64), (0, 38, 117),
     (0, 38, 128), (0, 38, 151), (0, 38, 171), (0, 39, 55), (0, 39, 56),
     (0, 39, 66), (0, 39, 91), (0, 39, 131), (0, 39, 138), (0, 40, 88),
     (0, 40, 107), (0, 40, 108), (0, 40, 137), (0, 40, 151), (0, 40, 198),
     (0, 41, 110), (0, 41, 138), (0, 42, 49), (0, 42, 105), (0, 42, 136),
     (0, 42, 172), (0, 42, 189), (0, 42, 194), (0, 43, 119), (0, 44, 69),
     (0, 44, 90), (0, 44, 117), (0, 44, 135), (0, 44, 137), (0, 44, 157),
     (0, 44, 172), (0, 44, 175), (0, 44, 178), (0, 44, 190), (0, 44, 194),
     (0, 45, 62), (0, 45, 83), (0, 45, 85), (0, 45, 157), (0, 46, 95),
     (0, 46, 103), (0, 46, 169), (0, 46, 175), (0, 47, 81), (0, 47, 165),
     (0, 48, 88), (0, 48, 198), (0, 49, 71), (0, 49, 123), (0, 49, 134),
     (0, 49, 143), (0, 49, 155), (0, 49, 177), (0, 49, 189), (0, 50, 94),
     (0, 50, 103), (0, 51, 139), (0, 51, 171), (0, 51, 193), (0, 52, 117),
     (0, 52, 139), (0, 52, 156), (0, 53, 152), (0, 53, 161), (0, 53, 168),
     (0, 54, 73), (0, 54, 107), (0, 54, 143), (0, 54, 175), (0, 54, 191),
     (0, 55, 74), (0, 55, 87), (0, 56, 71), (0, 56, 85), (0, 56, 101),
     (0, 56, 140), (0, 56, 166), (0, 57, 82), (0, 57, 127), (0, 57, 190),
     (0, 58, 82), (0, 58, 86), (0, 58, 123), (0, 58, 138), (0, 59, 151),
     (0, 59, 195), (0, 60, 143), (0, 60, 147), (0, 62, 85), (0, 62, 106),
     (0, 62, 119), (0, 62, 123), (0, 62, 147), (0, 62, 152), (0, 62, 178),
     (0, 62, 185), (0, 63, 120), (0, 63, 123), (0, 63, 168), (0, 63, 187),
     (0, 64, 91), (0, 64, 92), (0, 64, 94), (0, 64, 140), (0, 64, 156),
     (0, 64, 186), (0, 64, 192), (0, 65, 119), (0, 65, 162), (0, 66, 95),
     (0, 66, 117), (0, 66, 136), (0, 66, 157), (0, 66, 177), (0, 67, 81),
     (0, 67, 108), (0, 67, 120), (0, 67, 142), (0, 67, 149), (0, 67, 158),
     (0, 68, 80), (0, 68, 89), (0, 68, 135), (0, 69, 118), (0, 69, 142),
     (0, 69, 152), (0, 69, 192), (0, 70, 198), (0, 71, 81), (0, 71, 144),
     (0, 71, 146), (0, 71, 153), (0, 71, 162), (0, 71, 174), (0, 72, 92),
     (0, 72, 105), (0, 72, 187), (0, 73, 103), (0, 73, 116), (0, 73, 140),
     (0, 73, 155), (0, 73, 159), (0, 73, 169), (0, 74, 103), (0, 74, 182),
     (0, 74, 195), (0, 75, 138), (0, 75, 154), (0, 75, 155), (0, 76, 160),
     (0, 76, 171), (0, 76, 194), (0, 76, 200), (0, 77, 133), (0, 77, 180),
     (0, 77, 190), (0, 77, 191), (0, 78, 93), (0, 78, 147), (0, 78, 167),
     (0, 78, 169), (0, 79, 145), (0, 79, 155), (0, 80, 124), (0, 80, 173),
     (0, 80, 186), (0, 81, 103), (0, 81, 122), (0, 81, 161), (0, 81, 200),
     (0, 82, 116), (0, 82, 118), (0, 82, 134), (0, 82, 140), (0, 82, 167),
     (0, 83, 98), (0, 83, 160), (0, 83, 166), (0, 84, 124), (0, 84, 139),
     (0, 85, 140), (0, 85, 150), (0, 85, 164), (0, 85, 167), (0, 86, 111),
     (0, 86, 139), (0, 86, 180), (0, 87, 109), (0, 87, 134), (0, 87, 149),
     (0, 87, 193), (0, 88, 151), (0, 88, 158), (0, 88, 162), (0, 88, 168),
     (0, 89, 109), (0, 89, 133), (0, 90, 187), (0, 91, 110), (0, 91, 142),
     (0, 91, 154), (0, 92, 143), (0, 92, 178), (0, 93, 112), (0, 93, 149),
     (0, 94, 186), (0, 94, 195), (0, 95, 108), (0, 95, 128), (0, 95, 136),
     (0, 95, 157), (0, 95, 167), (0, 95, 169), (0, 96, 109), (0, 96, 117),
     (0, 96, 132), (0, 96, 153), (0, 96, 183), (0, 96, 191), (0, 97, 143),
     (0, 97, 163), (0, 97, 172), (0, 97, 182), (0, 98, 111), (0, 98, 125),
     (0, 98, 150), (0, 98, 168), (0, 99, 136), (0, 99, 190), (0, 100, 152),
     (0, 101, 164), (0, 101, 172), (0, 101, 179), (0, 103, 117), (0, 106, 146),
     (0, 106, 175), (0, 107, 135), (0, 107, 143), (0, 107, 149), (0, 107, 181),
     (0, 107, 198), (0, 108, 127), (0, 108, 148), (0, 108, 184), (0, 108, 191),
     (0, 109, 128), (0, 109, 149), (0, 109, 152), (0, 109, 160), (0, 109, 190),
     (0, 109, 193), (0, 110, 149), (0, 110, 154), (0, 110, 161), (0, 110, 196),
     (0, 111, 199), (0, 112, 138), (0, 112, 141), (0, 112, 143), (0, 112, 151),
     (0, 112, 200), (0, 113, 144), (0, 113, 148), (0, 113, 196), (0, 114, 137),
     (0, 114, 158), (0, 114, 176), (0, 115, 134), (0, 115, 178), (0, 115, 183),
     (0, 115, 189), (0, 116, 132), (0, 116, 136), (0, 116, 154), (0, 117, 151),
     (0, 117, 168), (0, 117, 180), (0, 117, 181), (0, 118, 139), (0, 118, 150),
     (0, 119, 189), (0, 120, 184), (0, 121, 143), (0, 121, 167), (0, 122, 148),
     (0, 122, 150), (0, 123, 181), (0, 123, 185), (0, 123, 197), (0, 124, 153),
     (0, 125, 145), (0, 125, 157), (0, 125, 184), (0, 126, 153), (0, 126, 171),
     (0, 126, 173), (0, 127, 160), (0, 127, 184), (0, 128, 194), (0, 129, 145),
     (0, 130, 188), (0, 130, 200), (0, 131, 164), (0, 132, 178), (0, 132, 183),
     (0, 132, 186), (0, 132, 193), (0, 133, 160), (0, 133, 186), (0, 134, 183),
     (0, 134, 188), (0, 134, 198), (0, 134, 200), (0, 135, 193), (0, 135, 196),
     (0, 136, 160), (0, 136, 174), (0, 136, 180), (0, 137, 159), (0, 137, 168),
     (0, 137, 171), (0, 137, 185), (0, 137, 194), (0, 138, 164), (0, 139, 180),
     (0, 139, 185), (0, 139, 192), (0, 139, 199), (0, 140, 170), (0, 141, 175),
     (0, 143, 160), (0, 143, 165), (0, 143, 178), (0, 143, 198), (0, 144, 168),
     (0, 144, 169), (0, 147, 177), (0, 147, 193), (0, 148, 190), (0, 149, 169),
     (0, 149, 190), (0, 150, 175), (0, 150, 184), (0, 151, 169), (0, 151, 184),
     (0, 151, 188), (0, 152, 185), (0, 153, 181), (0, 153, 186), (0, 155, 194),
     (0, 156, 180), (0, 156, 189), (0, 158, 182), (0, 164, 189), (0, 165, 188),
     (0, 168, 189), (0, 168, 196), (0, 170, 198)]


# --------------------------------------------------------------------------
##
#   @brief Will return all [first_leg, second_leg] matching a given hypotenuse
def get_legs_matching_given_hypotenuse(side_length):
    if type(side_length) is not int:
        raise ValueError('side_length must be int')

    result = []

    for elt in ALL_TRIPLES_5_200:
        if elt[2] == side_length:
            result += [elt[0], elt[1]]

    return result


# --------------------------------------------------------------------------
##
#   @brief Will return all leg values matching a given one
def get_legs_matching_given_leg(side_length):
    if type(side_length) is not int:
        raise ValueError('side_length must be int')

    result = []

    for elt in ALL_TRIPLES_5_200:
        if elt[0] == side_length:
            result += [elt[1]]

        elif elt[1] == side_length:
            result += [elt[0]]

    return result
