from .resourceUse_utils import run_resource_use

REQUIREMENTS = {
    "ImpactAssessment": {
        "Site": {
            "management": [{"@type": "Management", "value": ">=0", "term.termType": "landCover", "endDate": ""}]
        },
        "emissionsResourceUse": [
            {
                "@type": "Indicator",
                "term.@id": "landOccupationDuringCycle",
                "landCover": {
                    "@type": "Term",
                    "termType": "landCover"
                },
                "value": ">=0"
            }
        ],
        "endDate": ""
    }
}
RETURNS = {
    "Indicator": [{
        "value": "",
        "landCover": "",
        "previousLandCover": ""
    }]
}
TERM_ID = 'landTransformation20YearAverageDuringCycle'
_HISTORIC_DATE_OFFSET = 20


def run(impact_assessment: dict):
    return run_resource_use(
        impact_assessment=impact_assessment,
        historic_date_offset=_HISTORIC_DATE_OFFSET,
        term_id=TERM_ID
    )
