# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/03_oauth.ipynb.

# %% auto 0
__all__ = ['GoogleAppClient', 'GitHubAppClient', 'retr_code']

# %% ../nbs/03_oauth.ipynb 2
import json, uuid
from httpx import get,post

from fastcore.utils import *
from fastcore.net import recv_once
from fastcore.xtras import parse_env

from oauthlib.oauth2 import WebApplicationClient
from urllib.parse import urlparse, parse_qs

# %% ../nbs/03_oauth.ipynb 5
class _AppClient(WebApplicationClient):
    def __init__(self, client_id, client_secret, redirect_uri, code=None, scope=None, **kwargs):
        super().__init__(client_id, code=code, scope=scope, **kwargs)
        self.client_secret,self.redirect_uri = client_secret,redirect_uri

# %% ../nbs/03_oauth.ipynb 6
class GoogleAppClient(_AppClient):
    "A `WebApplicationClient` for Google oauth2"
    pre = "https://www.googleapis.com/oauth2"
    acct_pre = "https://accounts.google.com/o/oauth2"
    scope_pre = "https://www.googleapis.com/auth/userinfo"

    base_url = f"{acct_pre}/v2/auth"
    token_url = f"{pre}/v4/token"
    info_url = f"{pre}/v3/userinfo"
    id_key = 'sub'
    
    def __init__(self, client_id, client_secret, redirect_uri=None, redirect_uris=None, code=None, scope=None, **kwargs):
        if redirect_uris and not redirect_uri: redirect_uri = redirect_uris[0]
        if not scope: scope=["openid", f"{self.scope_pre}.email", f"{self.scope_pre}.profile"]
        super().__init__(client_id, client_secret, redirect_uri, code=code, scope=scope, **kwargs)

# %% ../nbs/03_oauth.ipynb 7
class GitHubAppClient(_AppClient):
    "A `WebApplicationClient` for GitHub oauth2"
    pre = "https://github.com/login/oauth"
    base_url = f"{pre}/authorize"
    token_url = f"{pre}/access_token"
    info_url = "https://api.github.com/user"
    id_key = 'id'

    def __init__(self, client_id, client_secret, redirect_uri, code=None, scope=None, **kwargs):
        if not scope: scope="user"
        super().__init__(client_id, client_secret, redirect_uri, code=code, scope=scope, **kwargs)

# %% ../nbs/03_oauth.ipynb 8
@patch
def login_link(self:WebApplicationClient, scope=None):
    "Get a login link for this client"
    if not scope: scope=self.scope
    return self.prepare_request_uri(self.base_url, self.redirect_uri, scope)

# %% ../nbs/03_oauth.ipynb 11
def retr_code(ret):
    "Parse a request to get the code -- mainly used for testing"
    url = ret.decode()
    if url.startswith('GET'): url = url.split(' ')[1]
    query_params = parse_qs(urlparse(url).query)
    return query_params.get('code', [None])[0]

# %% ../nbs/03_oauth.ipynb 13
@patch
def parse_response(self:_AppClient, code):
    "Get the token from the oauth2 server response"
    payload = dict(code=code, redirect_uri=self.redirect_uri, client_id=self.client_id,
                   client_secret=self.client_secret, grant_type='authorization_code')
    self.parse_request_body_response(post(self.token_url, json=payload).text)

# %% ../nbs/03_oauth.ipynb 14
@patch
def get_info(self:_AppClient):
    "Get the info for authenticated user"
    headers = {'Authorization': f'Bearer {self.token["access_token"]}'}
    return get(self.info_url, headers=headers).json()

# %% ../nbs/03_oauth.ipynb 15
@patch
def retr_info(self:_AppClient, code):
    "Combines `parse_response` and `get_info`"
    self.parse_response(code)
    return self.get_info()

# %% ../nbs/03_oauth.ipynb 16
@patch
def retr_id(self:_AppClient, code):
    "Call `retr_info` and then return id/subcriber value"
    return self.retr_info()[self.id_key]
