"""Main module"""
from .descuentos import Descuentos
from .impuestos import Impuestos
from .precios import Precios

class GestorVentas:
    def __init__(self,precio_base,impuesto_porcentaje,descuento_porcentaje):
        self.precio_base=precio_base
        self.impuesto=Impuestos(impuesto_porcentaje) #el atributo es como si fuera un objeto apartir de la clase
        self.descuento=Descuentos(descuento_porcentaje)
    
    def calcular_precio_final(self):
        impuesto_aplicado=self.impuesto.aplicar_impuesto(self.precio_base) #basicamente llama a su metodo desde el objeto creado
        descuento_aplicado=self.descuento.aplicar_descuento(self.precio_base)
        precio_final=Precios.calcular_precio_final(self.precio_base,impuesto_aplicado,descuento_aplicado) #el metodo funciona directamente desde la clase
        return round(precio_final,2)