# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['NgwafAccountListArgs', 'NgwafAccountList']

@pulumi.input_type
class NgwafAccountListArgs:
    def __init__(__self__, *,
                 entries: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a NgwafAccountList resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        """
        pulumi.set(__self__, "entries", entries)
        pulumi.set(__self__, "type", type)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _NgwafAccountListState:
    def __init__(__self__, *,
                 applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering NgwafAccountList resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: INTERNAL: Used to build scope for account-scoped lists. Not user-configurable.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        if applies_tos is not None:
            pulumi.set(__self__, "applies_tos", applies_tos)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entries is not None:
            pulumi.set(__self__, "entries", entries)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="appliesTos")
    def applies_tos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        INTERNAL: Used to build scope for account-scoped lists. Not user-configurable.
        """
        return pulumi.get(self, "applies_tos")

    @applies_tos.setter
    def applies_tos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "applies_tos", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def entries(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @entries.setter
    def entries(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "entries", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("fastly:index/ngwafAccountList:NgwafAccountList")
class NgwafAccountList(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Provides a Fastly Next-Gen WAF **List** resource scoped to an **account**.

        Account-scoped lists are reusable across all workspaces in the account and can be referenced in account-level or workspace-level rules.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafAccountList("example",
            name="shared-bot-ip-list",
            description="List of known bot IPs shared across workspaces",
            type="ip",
            entries=[
                "1.2.3.4",
                "5.6.7.8",
                "203.0.113.42",
            ])
        ```

        ## Import

        Fastly Next-Gen WAF account-scoped lists can be imported using just the list ID, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafAccountList:NgwafAccountList demo <listID>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NgwafAccountListArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a Fastly Next-Gen WAF **List** resource scoped to an **account**.

        Account-scoped lists are reusable across all workspaces in the account and can be referenced in account-level or workspace-level rules.

        ## Example Usage

        Basic usage:

        ```python
        import pulumi
        import pulumi_fastly as fastly

        example = fastly.NgwafAccountList("example",
            name="shared-bot-ip-list",
            description="List of known bot IPs shared across workspaces",
            type="ip",
            entries=[
                "1.2.3.4",
                "5.6.7.8",
                "203.0.113.42",
            ])
        ```

        ## Import

        Fastly Next-Gen WAF account-scoped lists can be imported using just the list ID, e.g.:

        ```sh
        $ pulumi import fastly:index/ngwafAccountList:NgwafAccountList demo <listID>
        ```

        :param str resource_name: The name of the resource.
        :param NgwafAccountListArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NgwafAccountListArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NgwafAccountListArgs.__new__(NgwafAccountListArgs)

            __props__.__dict__["description"] = description
            if entries is None and not opts.urn:
                raise TypeError("Missing required property 'entries'")
            __props__.__dict__["entries"] = entries
            __props__.__dict__["name"] = name
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["applies_tos"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["appliesTos"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(NgwafAccountList, __self__).__init__(
            'fastly:index/ngwafAccountList:NgwafAccountList',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            applies_tos: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            entries: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'NgwafAccountList':
        """
        Get an existing NgwafAccountList resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] applies_tos: INTERNAL: Used to build scope for account-scoped lists. Not user-configurable.
        :param pulumi.Input[_builtins.str] description: The description of the list.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] entries: The values in the list.
        :param pulumi.Input[_builtins.str] name: The name of the list.
        :param pulumi.Input[_builtins.str] type: The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NgwafAccountListState.__new__(_NgwafAccountListState)

        __props__.__dict__["applies_tos"] = applies_tos
        __props__.__dict__["description"] = description
        __props__.__dict__["entries"] = entries
        __props__.__dict__["name"] = name
        __props__.__dict__["type"] = type
        return NgwafAccountList(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appliesTos")
    def applies_tos(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        INTERNAL: Used to build scope for account-scoped lists. Not user-configurable.
        """
        return pulumi.get(self, "applies_tos")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the list.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def entries(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The values in the list.
        """
        return pulumi.get(self, "entries")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the list.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of list. Accepted values are `string`, `wildcard`, `ip`, `country`, and `signal`.
        """
        return pulumi.get(self, "type")

