import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermServicebusSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#name DataAzurermServicebusSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#namespace_name DataAzurermServicebusSubscription#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#resource_group_name DataAzurermServicebusSubscription#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#topic_name DataAzurermServicebusSubscription#topic_name}.
     *
     * @stability stable
     */
    readonly topicName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#timeouts DataAzurermServicebusSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermServicebusSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermServicebusSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html#read DataAzurermServicebusSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermServicebusSubscriptionTimeoutsToTerraform(struct?: DataAzurermServicebusSubscriptionTimeoutsOutputReference | DataAzurermServicebusSubscriptionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermServicebusSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermServicebusSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermServicebusSubscriptionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html azurerm_servicebus_subscription}.
 *
 * @stability stable
 */
export declare class DataAzurermServicebusSubscription extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_subscription.html azurerm_servicebus_subscription} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusSubscriptionConfig);
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    get deadLetteringOnFilterEvaluationError(): any;
    /**
     * @stability stable
     */
    get deadLetteringOnMessageExpiration(): any;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): any;
    /**
     * @stability stable
     */
    get forwardDeadLetteredMessagesTo(): string;
    /**
     * @stability stable
     */
    get forwardTo(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get lockDuration(): string;
    /**
     * @stability stable
     */
    get maxDeliveryCount(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get requiresSession(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _topicName?;
    /**
     * @stability stable
     */
    get topicName(): string;
    /**
     * @stability stable
     */
    set topicName(value: string);
    /**
     * @stability stable
     */
    get topicNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermServicebusSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermServicebusSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermServicebusSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
