import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MssqlVirtualMachineConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#r_services_enabled MssqlVirtualMachine#r_services_enabled}.
     *
     * @stability stable
     */
    readonly rServicesEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#sql_connectivity_port MssqlVirtualMachine#sql_connectivity_port}.
     *
     * @stability stable
     */
    readonly sqlConnectivityPort?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#sql_connectivity_type MssqlVirtualMachine#sql_connectivity_type}.
     *
     * @stability stable
     */
    readonly sqlConnectivityType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#sql_connectivity_update_password MssqlVirtualMachine#sql_connectivity_update_password}.
     *
     * @stability stable
     */
    readonly sqlConnectivityUpdatePassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#sql_connectivity_update_username MssqlVirtualMachine#sql_connectivity_update_username}.
     *
     * @stability stable
     */
    readonly sqlConnectivityUpdateUsername?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#sql_license_type MssqlVirtualMachine#sql_license_type}.
     *
     * @stability stable
     */
    readonly sqlLicenseType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#tags MssqlVirtualMachine#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#virtual_machine_id MssqlVirtualMachine#virtual_machine_id}.
     *
     * @stability stable
     */
    readonly virtualMachineId: string;
    /**
     * auto_backup block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#auto_backup MssqlVirtualMachine#auto_backup}
     *
     * @stability stable
     */
    readonly autoBackup?: MssqlVirtualMachineAutoBackup;
    /**
     * auto_patching block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#auto_patching MssqlVirtualMachine#auto_patching}
     *
     * @stability stable
     */
    readonly autoPatching?: MssqlVirtualMachineAutoPatching;
    /**
     * key_vault_credential block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#key_vault_credential MssqlVirtualMachine#key_vault_credential}
     *
     * @stability stable
     */
    readonly keyVaultCredential?: MssqlVirtualMachineKeyVaultCredential;
    /**
     * storage_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#storage_configuration MssqlVirtualMachine#storage_configuration}
     *
     * @stability stable
     */
    readonly storageConfiguration?: MssqlVirtualMachineStorageConfiguration;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#timeouts MssqlVirtualMachine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MssqlVirtualMachineTimeouts;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineAutoBackupManualSchedule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#full_backup_frequency MssqlVirtualMachine#full_backup_frequency}.
     *
     * @stability stable
     */
    readonly fullBackupFrequency: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#full_backup_start_hour MssqlVirtualMachine#full_backup_start_hour}.
     *
     * @stability stable
     */
    readonly fullBackupStartHour: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#full_backup_window_in_hours MssqlVirtualMachine#full_backup_window_in_hours}.
     *
     * @stability stable
     */
    readonly fullBackupWindowInHours: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#log_backup_frequency_in_minutes MssqlVirtualMachine#log_backup_frequency_in_minutes}.
     *
     * @stability stable
     */
    readonly logBackupFrequencyInMinutes: number;
}
export declare function mssqlVirtualMachineAutoBackupManualScheduleToTerraform(struct?: MssqlVirtualMachineAutoBackupManualScheduleOutputReference | MssqlVirtualMachineAutoBackupManualSchedule): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineAutoBackupManualScheduleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineAutoBackupManualSchedule | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineAutoBackupManualSchedule | undefined);
    private _fullBackupFrequency?;
    /**
     * @stability stable
     */
    get fullBackupFrequency(): string;
    /**
     * @stability stable
     */
    set fullBackupFrequency(value: string);
    /**
     * @stability stable
     */
    get fullBackupFrequencyInput(): string | undefined;
    private _fullBackupStartHour?;
    /**
     * @stability stable
     */
    get fullBackupStartHour(): number;
    /**
     * @stability stable
     */
    set fullBackupStartHour(value: number);
    /**
     * @stability stable
     */
    get fullBackupStartHourInput(): number | undefined;
    private _fullBackupWindowInHours?;
    /**
     * @stability stable
     */
    get fullBackupWindowInHours(): number;
    /**
     * @stability stable
     */
    set fullBackupWindowInHours(value: number);
    /**
     * @stability stable
     */
    get fullBackupWindowInHoursInput(): number | undefined;
    private _logBackupFrequencyInMinutes?;
    /**
     * @stability stable
     */
    get logBackupFrequencyInMinutes(): number;
    /**
     * @stability stable
     */
    set logBackupFrequencyInMinutes(value: number);
    /**
     * @stability stable
     */
    get logBackupFrequencyInMinutesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineAutoBackup {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#encryption_enabled MssqlVirtualMachine#encryption_enabled}.
     *
     * @stability stable
     */
    readonly encryptionEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#encryption_password MssqlVirtualMachine#encryption_password}.
     *
     * @stability stable
     */
    readonly encryptionPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#retention_period_in_days MssqlVirtualMachine#retention_period_in_days}.
     *
     * @stability stable
     */
    readonly retentionPeriodInDays: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#storage_account_access_key MssqlVirtualMachine#storage_account_access_key}.
     *
     * @stability stable
     */
    readonly storageAccountAccessKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#storage_blob_endpoint MssqlVirtualMachine#storage_blob_endpoint}.
     *
     * @stability stable
     */
    readonly storageBlobEndpoint: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#system_databases_backup_enabled MssqlVirtualMachine#system_databases_backup_enabled}.
     *
     * @stability stable
     */
    readonly systemDatabasesBackupEnabled?: boolean | cdktf.IResolvable;
    /**
     * manual_schedule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#manual_schedule MssqlVirtualMachine#manual_schedule}
     *
     * @stability stable
     */
    readonly manualSchedule?: MssqlVirtualMachineAutoBackupManualSchedule;
}
export declare function mssqlVirtualMachineAutoBackupToTerraform(struct?: MssqlVirtualMachineAutoBackupOutputReference | MssqlVirtualMachineAutoBackup): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineAutoBackupOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineAutoBackup | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineAutoBackup | undefined);
    private _encryptionEnabled?;
    /**
     * @stability stable
     */
    get encryptionEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryptionPassword?;
    /**
     * @stability stable
     */
    get encryptionPassword(): string;
    /**
     * @stability stable
     */
    set encryptionPassword(value: string);
    /**
     * @stability stable
     */
    resetEncryptionPassword(): void;
    /**
     * @stability stable
     */
    get encryptionPasswordInput(): string | undefined;
    private _retentionPeriodInDays?;
    /**
     * @stability stable
     */
    get retentionPeriodInDays(): number;
    /**
     * @stability stable
     */
    set retentionPeriodInDays(value: number);
    /**
     * @stability stable
     */
    get retentionPeriodInDaysInput(): number | undefined;
    private _storageAccountAccessKey?;
    /**
     * @stability stable
     */
    get storageAccountAccessKey(): string;
    /**
     * @stability stable
     */
    set storageAccountAccessKey(value: string);
    /**
     * @stability stable
     */
    get storageAccountAccessKeyInput(): string | undefined;
    private _storageBlobEndpoint?;
    /**
     * @stability stable
     */
    get storageBlobEndpoint(): string;
    /**
     * @stability stable
     */
    set storageBlobEndpoint(value: string);
    /**
     * @stability stable
     */
    get storageBlobEndpointInput(): string | undefined;
    private _systemDatabasesBackupEnabled?;
    /**
     * @stability stable
     */
    get systemDatabasesBackupEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set systemDatabasesBackupEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSystemDatabasesBackupEnabled(): void;
    /**
     * @stability stable
     */
    get systemDatabasesBackupEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _manualSchedule;
    /**
     * @stability stable
     */
    get manualSchedule(): MssqlVirtualMachineAutoBackupManualScheduleOutputReference;
    /**
     * @stability stable
     */
    putManualSchedule(value: MssqlVirtualMachineAutoBackupManualSchedule): void;
    /**
     * @stability stable
     */
    resetManualSchedule(): void;
    /**
     * @stability stable
     */
    get manualScheduleInput(): MssqlVirtualMachineAutoBackupManualSchedule | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineAutoPatching {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#day_of_week MssqlVirtualMachine#day_of_week}.
     *
     * @stability stable
     */
    readonly dayOfWeek: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#maintenance_window_duration_in_minutes MssqlVirtualMachine#maintenance_window_duration_in_minutes}.
     *
     * @stability stable
     */
    readonly maintenanceWindowDurationInMinutes: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#maintenance_window_starting_hour MssqlVirtualMachine#maintenance_window_starting_hour}.
     *
     * @stability stable
     */
    readonly maintenanceWindowStartingHour: number;
}
export declare function mssqlVirtualMachineAutoPatchingToTerraform(struct?: MssqlVirtualMachineAutoPatchingOutputReference | MssqlVirtualMachineAutoPatching): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineAutoPatchingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineAutoPatching | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineAutoPatching | undefined);
    private _dayOfWeek?;
    /**
     * @stability stable
     */
    get dayOfWeek(): string;
    /**
     * @stability stable
     */
    set dayOfWeek(value: string);
    /**
     * @stability stable
     */
    get dayOfWeekInput(): string | undefined;
    private _maintenanceWindowDurationInMinutes?;
    /**
     * @stability stable
     */
    get maintenanceWindowDurationInMinutes(): number;
    /**
     * @stability stable
     */
    set maintenanceWindowDurationInMinutes(value: number);
    /**
     * @stability stable
     */
    get maintenanceWindowDurationInMinutesInput(): number | undefined;
    private _maintenanceWindowStartingHour?;
    /**
     * @stability stable
     */
    get maintenanceWindowStartingHour(): number;
    /**
     * @stability stable
     */
    set maintenanceWindowStartingHour(value: number);
    /**
     * @stability stable
     */
    get maintenanceWindowStartingHourInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineKeyVaultCredential {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#key_vault_url MssqlVirtualMachine#key_vault_url}.
     *
     * @stability stable
     */
    readonly keyVaultUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#name MssqlVirtualMachine#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#service_principal_name MssqlVirtualMachine#service_principal_name}.
     *
     * @stability stable
     */
    readonly servicePrincipalName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#service_principal_secret MssqlVirtualMachine#service_principal_secret}.
     *
     * @stability stable
     */
    readonly servicePrincipalSecret: string;
}
export declare function mssqlVirtualMachineKeyVaultCredentialToTerraform(struct?: MssqlVirtualMachineKeyVaultCredentialOutputReference | MssqlVirtualMachineKeyVaultCredential): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineKeyVaultCredentialOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineKeyVaultCredential | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineKeyVaultCredential | undefined);
    private _keyVaultUrl?;
    /**
     * @stability stable
     */
    get keyVaultUrl(): string;
    /**
     * @stability stable
     */
    set keyVaultUrl(value: string);
    /**
     * @stability stable
     */
    get keyVaultUrlInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _servicePrincipalName?;
    /**
     * @stability stable
     */
    get servicePrincipalName(): string;
    /**
     * @stability stable
     */
    set servicePrincipalName(value: string);
    /**
     * @stability stable
     */
    get servicePrincipalNameInput(): string | undefined;
    private _servicePrincipalSecret?;
    /**
     * @stability stable
     */
    get servicePrincipalSecret(): string;
    /**
     * @stability stable
     */
    set servicePrincipalSecret(value: string);
    /**
     * @stability stable
     */
    get servicePrincipalSecretInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineStorageConfigurationDataSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#default_file_path MssqlVirtualMachine#default_file_path}.
     *
     * @stability stable
     */
    readonly defaultFilePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#luns MssqlVirtualMachine#luns}.
     *
     * @stability stable
     */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationDataSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference | MssqlVirtualMachineStorageConfigurationDataSettings): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineStorageConfigurationDataSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineStorageConfigurationDataSettings | undefined);
    private _defaultFilePath?;
    /**
     * @stability stable
     */
    get defaultFilePath(): string;
    /**
     * @stability stable
     */
    set defaultFilePath(value: string);
    /**
     * @stability stable
     */
    get defaultFilePathInput(): string | undefined;
    private _luns?;
    /**
     * @stability stable
     */
    get luns(): number[];
    /**
     * @stability stable
     */
    set luns(value: number[]);
    /**
     * @stability stable
     */
    get lunsInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineStorageConfigurationLogSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#default_file_path MssqlVirtualMachine#default_file_path}.
     *
     * @stability stable
     */
    readonly defaultFilePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#luns MssqlVirtualMachine#luns}.
     *
     * @stability stable
     */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationLogSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference | MssqlVirtualMachineStorageConfigurationLogSettings): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineStorageConfigurationLogSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineStorageConfigurationLogSettings | undefined);
    private _defaultFilePath?;
    /**
     * @stability stable
     */
    get defaultFilePath(): string;
    /**
     * @stability stable
     */
    set defaultFilePath(value: string);
    /**
     * @stability stable
     */
    get defaultFilePathInput(): string | undefined;
    private _luns?;
    /**
     * @stability stable
     */
    get luns(): number[];
    /**
     * @stability stable
     */
    set luns(value: number[]);
    /**
     * @stability stable
     */
    get lunsInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineStorageConfigurationTempDbSettings {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#default_file_path MssqlVirtualMachine#default_file_path}.
     *
     * @stability stable
     */
    readonly defaultFilePath: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#luns MssqlVirtualMachine#luns}.
     *
     * @stability stable
     */
    readonly luns: number[];
}
export declare function mssqlVirtualMachineStorageConfigurationTempDbSettingsToTerraform(struct?: MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference | MssqlVirtualMachineStorageConfigurationTempDbSettings): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined);
    private _defaultFilePath?;
    /**
     * @stability stable
     */
    get defaultFilePath(): string;
    /**
     * @stability stable
     */
    set defaultFilePath(value: string);
    /**
     * @stability stable
     */
    get defaultFilePathInput(): string | undefined;
    private _luns?;
    /**
     * @stability stable
     */
    get luns(): number[];
    /**
     * @stability stable
     */
    set luns(value: number[]);
    /**
     * @stability stable
     */
    get lunsInput(): number[] | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineStorageConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#disk_type MssqlVirtualMachine#disk_type}.
     *
     * @stability stable
     */
    readonly diskType: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#storage_workload_type MssqlVirtualMachine#storage_workload_type}.
     *
     * @stability stable
     */
    readonly storageWorkloadType: string;
    /**
     * data_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#data_settings MssqlVirtualMachine#data_settings}
     *
     * @stability stable
     */
    readonly dataSettings?: MssqlVirtualMachineStorageConfigurationDataSettings;
    /**
     * log_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#log_settings MssqlVirtualMachine#log_settings}
     *
     * @stability stable
     */
    readonly logSettings?: MssqlVirtualMachineStorageConfigurationLogSettings;
    /**
     * temp_db_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#temp_db_settings MssqlVirtualMachine#temp_db_settings}
     *
     * @stability stable
     */
    readonly tempDbSettings?: MssqlVirtualMachineStorageConfigurationTempDbSettings;
}
export declare function mssqlVirtualMachineStorageConfigurationToTerraform(struct?: MssqlVirtualMachineStorageConfigurationOutputReference | MssqlVirtualMachineStorageConfiguration): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineStorageConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineStorageConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineStorageConfiguration | undefined);
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    set diskType(value: string);
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _storageWorkloadType?;
    /**
     * @stability stable
     */
    get storageWorkloadType(): string;
    /**
     * @stability stable
     */
    set storageWorkloadType(value: string);
    /**
     * @stability stable
     */
    get storageWorkloadTypeInput(): string | undefined;
    private _dataSettings;
    /**
     * @stability stable
     */
    get dataSettings(): MssqlVirtualMachineStorageConfigurationDataSettingsOutputReference;
    /**
     * @stability stable
     */
    putDataSettings(value: MssqlVirtualMachineStorageConfigurationDataSettings): void;
    /**
     * @stability stable
     */
    resetDataSettings(): void;
    /**
     * @stability stable
     */
    get dataSettingsInput(): MssqlVirtualMachineStorageConfigurationDataSettings | undefined;
    private _logSettings;
    /**
     * @stability stable
     */
    get logSettings(): MssqlVirtualMachineStorageConfigurationLogSettingsOutputReference;
    /**
     * @stability stable
     */
    putLogSettings(value: MssqlVirtualMachineStorageConfigurationLogSettings): void;
    /**
     * @stability stable
     */
    resetLogSettings(): void;
    /**
     * @stability stable
     */
    get logSettingsInput(): MssqlVirtualMachineStorageConfigurationLogSettings | undefined;
    private _tempDbSettings;
    /**
     * @stability stable
     */
    get tempDbSettings(): MssqlVirtualMachineStorageConfigurationTempDbSettingsOutputReference;
    /**
     * @stability stable
     */
    putTempDbSettings(value: MssqlVirtualMachineStorageConfigurationTempDbSettings): void;
    /**
     * @stability stable
     */
    resetTempDbSettings(): void;
    /**
     * @stability stable
     */
    get tempDbSettingsInput(): MssqlVirtualMachineStorageConfigurationTempDbSettings | undefined;
}
/**
 * @stability stable
 */
export interface MssqlVirtualMachineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#create MssqlVirtualMachine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#delete MssqlVirtualMachine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#read MssqlVirtualMachine#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html#update MssqlVirtualMachine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function mssqlVirtualMachineTimeoutsToTerraform(struct?: MssqlVirtualMachineTimeoutsOutputReference | MssqlVirtualMachineTimeouts): any;
/**
 * @stability stable
 */
export declare class MssqlVirtualMachineTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MssqlVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MssqlVirtualMachineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html azurerm_mssql_virtual_machine}.
 *
 * @stability stable
 */
export declare class MssqlVirtualMachine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/mssql_virtual_machine.html azurerm_mssql_virtual_machine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MssqlVirtualMachineConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _rServicesEnabled?;
    /**
     * @stability stable
     */
    get rServicesEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set rServicesEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRServicesEnabled(): void;
    /**
     * @stability stable
     */
    get rServicesEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _sqlConnectivityPort?;
    /**
     * @stability stable
     */
    get sqlConnectivityPort(): number;
    /**
     * @stability stable
     */
    set sqlConnectivityPort(value: number);
    /**
     * @stability stable
     */
    resetSqlConnectivityPort(): void;
    /**
     * @stability stable
     */
    get sqlConnectivityPortInput(): number | undefined;
    private _sqlConnectivityType?;
    /**
     * @stability stable
     */
    get sqlConnectivityType(): string;
    /**
     * @stability stable
     */
    set sqlConnectivityType(value: string);
    /**
     * @stability stable
     */
    resetSqlConnectivityType(): void;
    /**
     * @stability stable
     */
    get sqlConnectivityTypeInput(): string | undefined;
    private _sqlConnectivityUpdatePassword?;
    /**
     * @stability stable
     */
    get sqlConnectivityUpdatePassword(): string;
    /**
     * @stability stable
     */
    set sqlConnectivityUpdatePassword(value: string);
    /**
     * @stability stable
     */
    resetSqlConnectivityUpdatePassword(): void;
    /**
     * @stability stable
     */
    get sqlConnectivityUpdatePasswordInput(): string | undefined;
    private _sqlConnectivityUpdateUsername?;
    /**
     * @stability stable
     */
    get sqlConnectivityUpdateUsername(): string;
    /**
     * @stability stable
     */
    set sqlConnectivityUpdateUsername(value: string);
    /**
     * @stability stable
     */
    resetSqlConnectivityUpdateUsername(): void;
    /**
     * @stability stable
     */
    get sqlConnectivityUpdateUsernameInput(): string | undefined;
    private _sqlLicenseType?;
    /**
     * @stability stable
     */
    get sqlLicenseType(): string;
    /**
     * @stability stable
     */
    set sqlLicenseType(value: string);
    /**
     * @stability stable
     */
    get sqlLicenseTypeInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _virtualMachineId?;
    /**
     * @stability stable
     */
    get virtualMachineId(): string;
    /**
     * @stability stable
     */
    set virtualMachineId(value: string);
    /**
     * @stability stable
     */
    get virtualMachineIdInput(): string | undefined;
    private _autoBackup;
    /**
     * @stability stable
     */
    get autoBackup(): MssqlVirtualMachineAutoBackupOutputReference;
    /**
     * @stability stable
     */
    putAutoBackup(value: MssqlVirtualMachineAutoBackup): void;
    /**
     * @stability stable
     */
    resetAutoBackup(): void;
    /**
     * @stability stable
     */
    get autoBackupInput(): MssqlVirtualMachineAutoBackup | undefined;
    private _autoPatching;
    /**
     * @stability stable
     */
    get autoPatching(): MssqlVirtualMachineAutoPatchingOutputReference;
    /**
     * @stability stable
     */
    putAutoPatching(value: MssqlVirtualMachineAutoPatching): void;
    /**
     * @stability stable
     */
    resetAutoPatching(): void;
    /**
     * @stability stable
     */
    get autoPatchingInput(): MssqlVirtualMachineAutoPatching | undefined;
    private _keyVaultCredential;
    /**
     * @stability stable
     */
    get keyVaultCredential(): MssqlVirtualMachineKeyVaultCredentialOutputReference;
    /**
     * @stability stable
     */
    putKeyVaultCredential(value: MssqlVirtualMachineKeyVaultCredential): void;
    /**
     * @stability stable
     */
    resetKeyVaultCredential(): void;
    /**
     * @stability stable
     */
    get keyVaultCredentialInput(): MssqlVirtualMachineKeyVaultCredential | undefined;
    private _storageConfiguration;
    /**
     * @stability stable
     */
    get storageConfiguration(): MssqlVirtualMachineStorageConfigurationOutputReference;
    /**
     * @stability stable
     */
    putStorageConfiguration(value: MssqlVirtualMachineStorageConfiguration): void;
    /**
     * @stability stable
     */
    resetStorageConfiguration(): void;
    /**
     * @stability stable
     */
    get storageConfigurationInput(): MssqlVirtualMachineStorageConfiguration | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MssqlVirtualMachineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MssqlVirtualMachineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MssqlVirtualMachineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
