# -*- coding: utf-8 -*-
"""Metodo_FZI

Automatically generated by Colaboratory.

Original file is located at
    https://colab.research.google.com/drive/1lV-yO0GnT4Bjma64T3WtmOtt4WPB-yTl

#CLASS **FZI**
"""

class metodo_FZI():

  def __init__(self,DataFrame,columna_de_K,columna_de_PHI):

        self.df=DataFrame
        self.k=self.df.iloc[:,columna_de_K]
        self.phi=self.df.iloc[:,columna_de_PHI]

  @property
  def calculos(self):
    df=self.df
    k=self.k
    phi=self.phi
  
    def RQI():
      if np.mean(phi)>1:
        rqi=0.0314*((k/(phi/100))**(0.5))
      else:
        rqi=0.0314*((k/phi)**(0.5))  
      return rqi

    def PHI_N():
      if np.mean(phi)>1:
        phi_n= (phi/100)/(1-(phi/100))
      else:
        phi_n= phi/(1-phi)
      return phi_n 
      
    def PHI_R():
      if np.mean(phi)>1:
        phi_new=phi/100
        phi_r= phi_new**3/(1-phi_new)**2
      else:
        phi_r= phi**3/(1-phi)**2
      return phi_r

    def FZI(df):
      RQI=df['RQI (mm^2)']
      PHI_N=df['PHI N (FRACTION)']
      fzi= RQI/PHI_N
      return fzi 

    def IRREDUCIBLE_SATURATION(df):
      FZI=df['FZI']
      swir=1/(1+FZI)
      return swir
    
    def PHI__EFECTY(df):
      swir=df['Swir (Fraction)']
      phi_e=phi*(1-swir)
      return phi_e

    def k_phi_ratio():
      if np.mean(phi)>1:
        k_div_phi= k/(phi/100)
      else:
        k_div_phi= k/phi
      return k_div_phi


    df['RQI (mm^2)']=RQI()
    df['PHI N (FRACTION)']=PHI_N()
    df['PHI R (FRACTION)']=PHI_R()
    df['FZI']=FZI(df)
    df['Swir (Fraction)']=IRREDUCIBLE_SATURATION(df)
    df['PHI E (%)']=PHI__EFECTY(df)
    df['K/PHI']=k_phi_ratio()

    self.df=df
    return self.df

"""##Graficas para determinar UH"""

class PLOTS_BY_DETERMINE_UH(metodo_FZI):

    def __init__(self,DataFrame,columna_de_K,columna_de_PHI):
      super().__init__(DataFrame,columna_de_K,columna_de_PHI)
      self.df=metodo_FZI(DataFrame,columna_de_K,columna_de_PHI).calculos
      

      def values_s(df):
        #Valores Organizados según el FZI, ascendente
        values_sort=df.sort_values(by='FZI').reset_index(drop=True,inplace=False)
        return values_sort
      
      def values_n(values_sort):    
        #Valores Normalizados, sin FZI=0 y FZI=NaN
        values_normalized=values_sort.loc[values_sort['FZI']!=0]
        values_normalized=values_normalized.dropna(subset = ['FZI'], inplace=False).reset_index(drop=True,inplace=False)
        return values_normalized

      self.values_sort=values_s(self.df)
      self.values_normalized=values_n(self.values_sort)

    def Probability_FZI(self):
      k_y_phi_FZI=pd.DataFrame({'FZI':self.values_normalized['FZI']})
      df_probn=[]
      df_probn_100=[]
      for i in range(len(k_y_phi_FZI)):
        longitud=len(k_y_phi_FZI)
        Prob_N=((i+1)-0.5)/longitud
        Prob_N_100=100*((i+1)-0.5)/longitud
        df_probn.append(Prob_N)
        df_probn_100.append(Prob_N_100)
      k_y_phi_FZI['Probabilidad (Fracción)']=df_probn
      k_y_phi_FZI['Probabilidad (%)']=df_probn_100
      fig1=px.scatter(k_y_phi_FZI,x='FZI',y='Probabilidad (Fracción)',log_x=True,log_y=True,
            color='FZI',
            color_continuous_scale=[[0.00,'rgb(0, 255, 212)'],
                                    [0.0833, 'rgb(0, 100, 255)'], 
                                    [0.1666, 'rgb(0, 255, 42 )'], 
                                    [0.25, 'rgb(56, 142, 82)'],
                                    [0.3333, 'rgb(247, 123, 123)'],
                                    [0.4166, 'rgb(255, 0, 0)'], 
                                    [0.5, 'rgb(167, 88, 164)'],
                                    [0.5833, 'rgb(255, 0, 247 )'], 
                                    [0.6666, 'rgb(255, 182, 0 )'],
                                    [0.75, 'rgb(255, 139, 0  )'],
                                    [0.8333, 'rgb(66, 0, 255 )'], 
                                    [0.9166, 'rgb(184, 179, 15)'],
                                    [1, 'rgb(5, 255, 212)']],
                  title='PLOT PROBABILIDAD ACUMULADA',
                  template='plotly_dark')

      fig2=px.scatter(k_y_phi_FZI,x='FZI',y='Probabilidad (%)',color='FZI',log_x=True,
                  color_continuous_scale=[[0.00,'rgb(0, 255, 212)'],
                                    [0.0833, 'rgb(0, 100, 255)'], 
                                    [0.1666, 'rgb(0, 255, 42 )'], 
                                    [0.25, 'rgb(56, 142, 82)'],
                                    [0.3333, 'rgb(247, 123, 123)'],
                                    [0.4166, 'rgb(255, 0, 0)'], 
                                    [0.5, 'rgb(167, 88, 164)'],
                                    [0.5833, 'rgb(255, 0, 247 )'], 
                                    [0.6666, 'rgb(255, 182, 0 )'],
                                    [0.75, 'rgb(255, 139, 0  )'],
                                    [0.8333, 'rgb(66, 0, 255 )'], 
                                    [0.9166, 'rgb(184, 179, 15)'],
                                    [1, 'rgb(5, 255, 212)']],
                  title='PLOT PROBABILIDAD ACUMULADA',
                  template='plotly_dark')
      return  display(fig1,fig2)
    

    def RQI_vs_PHIN(self):
      fig=px.scatter(data_frame=self.df,x='PHI N (FRACTION)',y='RQI (mm^2)',color='FZI',
            log_x=True,log_y=True,
            color_continuous_scale=[[0.00,'rgb(0, 255, 212)'],
                                    [0.0833, 'rgb(0, 100, 255)'], 
                                    [0.1666, 'rgb(0, 255, 42 )'], 
                                    [0.25, 'rgb(56, 142, 82)'],
                                    [0.3333, 'rgb(247, 123, 123)'],
                                    [0.4166, 'rgb(255, 0, 0)'], 
                                    [0.5, 'rgb(167, 88, 164)'],
                                    [0.5833, 'rgb(255, 0, 247 )'], 
                                    [0.6666, 'rgb(255, 182, 0 )'],
                                    [0.75, 'rgb(255, 139, 0  )'],
                                    [0.8333, 'rgb(66, 0, 255 )'], 
                                    [0.9166, 'rgb(184, 179, 15)'],
                                    [1, 'rgb(5, 255, 212)']],
                    title='LOG-LOG  RQI VS PHI N'
            )
      
      return display(fig)

"""##Metodos para Regresiones

"""

class regressions():

  def equation_lineal(self,x,a,b):
      yp=a+(b*x)
      return yp
  
  def equation_potencial(self,x,a,b):
      yp=a*(x**b)
      return yp

  def linear_regression_manual(self,DataFrame,x_line=True,columns=None,method=None):
    self.DataFrame=DataFrame
    Table_for_lines=pd.DataFrame()
    Table_for_lines['UH']=['HU-%d' %(i+1) for i in range(len(self.DataFrame))]
    if columns==None:  
      a= str(input('El valor del intercepto en Y es cero (Y/N) \n'))
      datos= str(input('Una recta dada? (Y/N) \n'))
      name_column_x=str(input('Nombre de la columna X \n'))
      name_column_y=str(input('Nombre de la columna Y \n'))
    else:
      if method==1:    
          a= 'Y'
          datos= 'Y'
          name_column_x='PHI N (FRACTION)'
          name_column_y='RQI (mm^2)'

         
    def r2(tabla):
            R2=[]
            for i in range(len(tabla)):
              yp=tabla['SLOPE'][i]*self.DataFrame[i][name_column_x]
              y=self.DataFrame[i][name_column_y]
              r2=r2_score(y,yp)
              r2= '%0.4f' %(r2)
              R2.append(r2)
            return R2
    def pendiente(x,y):
        xmean=x.mean()
        ymean=y.mean()
        tabela=pd.DataFrame()
        X_XMEAN=[]
        Y_YMEAN=[]
        for i in range(len(x)):
          x_xmean=x[i]-xmean
          y_ymean=y[i]-ymean
          X_XMEAN.append(x_xmean)
          Y_YMEAN.append(y_ymean)
        tabela['X-XMEAN']=X_XMEAN
        tabela['Y-YMEAN']=Y_YMEAN
        tabela['(X-XMEAN)^2']=tabela['X-XMEAN']**2
        b=sum(tabela['X-XMEAN']*tabela['Y-YMEAN'])/sum(tabela['(X-XMEAN)^2'])
        return b,xmean,ymean
    def recta_inicial(a,b):
              delta_x=(a[1]-a[0])
              delta_y=(b[1]-b[0])
              m=float(delta_y/delta_x)
              return (delta_y,m)
    def calculoY1(m1,x1,delta_y_1,y2):
      a=float(y2/((m1*x1)+delta_y_1))
      y1=float(y2-(a*(delta_y_1)))
      valores_en_y=[y1,y2]
      return (a,valores_en_y)
    if x_line:
      x_line=[1e-2,1e0]
##############################################################
      if (a and datos)=='Y':
            X_RECTAS=[]
            Y_RECTAS=[]
            SLOPE=[]
            Y_mean=[]
            for i in range(len((self.DataFrame))):
              if i==0:
                y_line=([float(input('Valor inicial en  Y  para las rectas : \n')),
                      float(input('Valor final en  Y  para las rectas : \n'))])
                delta_y_1,m_1=recta_inicial(x_line,y_line)
                X_RECTAS.append(x_line)
                Y_RECTAS.append(y_line)
                SLOPE.append(m_1)
      
                
              else:
                valor_final_en_y=float(input('Valor final en Y '+ f' {i+1} : \n'))
                incremento,valores_de_y=calculoY1(m_1,x_line[0],delta_y_1,valor_final_en_y)
                delta_y,m=recta_inicial(x_line,valores_de_y)
                X_RECTAS.append(x_line)
                Y_RECTAS.append(valores_de_y)
                SLOPE.append(m)
             
            
            Table_for_lines['X']=X_RECTAS
            Table_for_lines['Y']=Y_RECTAS
            Table_for_lines['SLOPE']=SLOPE
            Table_for_lines['R2']=r2(Table_for_lines)

            self.lines_table=Table_for_lines
      #########################################################
      elif (a=='Y' and datos=='N'):
        SLOPE=[]
        X_RECTAS=[]
        for i in range(len(Table_for_lines)):
          x=self.DataFrame[i][name_column_x]
          y=self.DataFrame[i][name_column_y]
          slope,xmean,ymean=pendiente(x,y)
          X_RECTAS.append(x_line)
          SLOPE.append(slope)
          
        values_y=[]
        for i in range(len(SLOPE)):
          y_line=[x_line[0]*SLOPE[i],x_line[1]*SLOPE[i]]
          values_y.append(y_line)
        
        Table_for_lines['X']=X_RECTAS
        Table_for_lines['Y']=values_y
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines
       #########################################################   
      elif (a and datos)=='N':
        SLOPE=[]
        corte=[]
        X_RECTAS=[]
        for i in range(len(Table_for_lines)):
          x=self.DataFrame[i][name_column_x]
          y=self.DataFrame[i][name_column_y]
          slope,xmean,ymean=pendiente(x,y)
          a=ymean-(slope*xmean)
          SLOPE.append(slope)
          X_RECTAS.append(x_line)
          corte.append(a)
        values_y=[]
        for i in range(len(SLOPE)):
          y_line=[x_line[0]*SLOPE[i]+corte[i],x_line[1]*SLOPE[i]+corte[i]]
          values_y.append(y_line)

        Table_for_lines['X']=X_RECTAS
        Table_for_lines['Y']=values_y
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['CUT Y']=corte
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines
        #############################################################
      else:
        X_RECTAS=[]
        Y_RECTAS=[]
        SLOPE=[]
        Y_mean=[]
        corte=[]
        for i in range(len((self.DataFrame))):
          if i==0:
            y_line=([float(input('Valor inicial en  Y  para las rectas : \n')),
                  float(input('Valor final en  Y  para las rectas : \n'))])
            delta_y_1,m_1=recta_inicial(x_line,y_line)
            X_RECTAS.append(x_line)
            Y_RECTAS.append(y_line)
            SLOPE.append(m_1)
            y_mean=self.DataFrame[i][name_column_y].mean()
            Y_mean.append(y_mean)
            x_mean=self.DataFrame[i][name_column_x].mean()
            a=y_mean-(m_1*x_mean)
            corte.append(a)
            
          else:
            valor_final_en_y=float(input('Valor final en Y '+ f' {i+1} : \n'))
            incremento,valores_de_y=calculoY1(m_1,x_line[0],delta_y_1,valor_final_en_y)
            delta_y,m=recta_inicial(x_line,valores_de_y)
            X_RECTAS.append(x_line)
            Y_RECTAS.append(valores_de_y)
            SLOPE.append(m)
            y_mean=self.DataFrame[i][name_column_y].mean()
            Y_mean.append(y_mean)
            x_mean=self.DataFrame[i][name_column_x].mean()
            a=y_mean-(m*x_mean)
            corte.append(a)          
        
        Table_for_lines['X']=X_RECTAS
        Table_for_lines['Y']=Y_RECTAS
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['CUT Y']=corte
        Table_for_lines['Y MEAN']=Y_mean
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines
    
    #####  
    else:
      x_line=[input('Primer valor para evaluar el rango en X \n'),input('Segundo valor para evaluar el rango en X \n')]
      if (a and datos)=='Y':
            X_RECTAS=[]
            Y_RECTAS=[]
            SLOPE=[]
            Y_mean=[]
            for i in range(len((self.DataFrame))):
              if i==0:
                y_line=([float(input('Valor inicial en  Y  para las rectas : \n')),
                      float(input('Valor final en  Y  para las rectas : \n'))])
                delta_y_1,m_1=recta_inicial(x_line,y_line)
                X_RECTAS.append(x_line)
                Y_RECTAS.append(y_line)
                SLOPE.append(m_1)
                y_mean=self.DataFrame[i][name_column_y].mean()
                Y_mean.append(y_mean)
                
              else:
                valor_final_en_y=float(input('Valor final en Y '+ f' {i+1} : \n'))
                incremento,valores_de_y=calculoY1(m_1,x_line[0],delta_y_1,valor_final_en_y)
                delta_y,m=recta_inicial(x_line,valores_de_y)
                X_RECTAS.append(x_line)
                Y_RECTAS.append(valores_de_y)
                SLOPE.append(m)
                y_mean=self.DataFrame[i][name_column_y].mean()
                Y_mean.append(y_mean)          
            
            Table_for_lines['X']=X_RECTAS
            Table_for_lines['Y']=Y_RECTAS
            Table_for_lines['SLOPE']=SLOPE
            Table_for_lines['Y MEAN']=Y_mean
            Table_for_lines['R2']=r2(Table_for_lines)

            self.lines_table=Table_for_lines
      
      elif (a=='Y' and datos=='N'):
        SLOPE=[]

        for i in range(len(Table_for_lines)):
          x=self.DataFrame[i][name_column_x]
          y=self.DataFrame[i][name_column_y]
          slope,xmean,ymean=pendiente(x,y)
          SLOPE.append(slope)
          
        values_y=[]
        for i in range(len(SLOPE)):
          y_line=[x_line[0]*SLOPE[i],x_line[1]*SLOPE[i]]
          values_y.append(y_line)
        
        Table_for_lines['X']=x_line
        Table_for_lines['Y']=values_y
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines
          
      elif (a and datos)=='N':
        SLOPE=[]
        corte=[]
        for i in range(len(Table_for_lines)):
          x=self.DataFrame[i][name_column_x]
          y=self.DataFrame[i][name_column_y]
          slope,xmean,ymean=pendiente(x,y)
          a=ymean-(slope*xmean)
          SLOPE.append(slope)
          corte.append(a)
        values_y=[]
        for i in range(len(SLOPE)):
          y_line=[x_line[0]*SLOPE[i]+corte[i],x_line[1]*SLOPE[i]+corte[i]]
          values_y.append(y_line)

        Table_for_lines['X']=x_line
        Table_for_lines['Y']=values_y
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['CUT Y']=corte
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines
      else:
        X_RECTAS=[]
        Y_RECTAS=[]
        SLOPE=[]
        Y_mean=[]
        corte=[]
        for i in range(len((self.DataFrame))):
          if i==0:
            y_line=([float(input('Valor inicial en  Y  para las rectas : \n')),
                  float(input('Valor final en  Y  para las rectas : \n'))])
            delta_y_1,m_1=recta_inicial(x_line,y_line)
            X_RECTAS.append(x_line)
            Y_RECTAS.append(y_line)
            SLOPE.append(m_1)
            y_mean=self.DataFrame[i][name_column_y].mean()
            Y_mean.append(y_mean)
            x_mean=self.DataFrame[i][name_column_x].mean()
            a=y_mean-(m_1*x_mean)
            corte.append(a)
            
          else:
            valor_final_en_y=float(input('Valor final en Y '+ f' {i+1} : \n'))
            incremento,valores_de_y=calculoY1(m_1,x_line[0],delta_y_1,valor_final_en_y)
            delta_y,m=recta_inicial(x_line,valores_de_y)
            X_RECTAS.append(x_line)
            Y_RECTAS.append(valores_de_y)
            SLOPE.append(m)
            y_mean=self.DataFrame[i][name_column_y].mean()
            Y_mean.append(y_mean)
            x_mean=self.DataFrame[i][name_column_x].mean()
            a=y_mean-(m*x_mean)
            corte.append(a)          
        
        Table_for_lines['X']=X_RECTAS
        Table_for_lines['Y']=Y_RECTAS
        Table_for_lines['SLOPE']=SLOPE
        Table_for_lines['CUT Y']=corte
        Table_for_lines['Y MEAN']=Y_mean
        Table_for_lines['R2']=r2(Table_for_lines)

        self.lines_table=Table_for_lines

    return self.lines_table
################################################################

  def linear_regression_supervised(self,DataFrame,intercept=True,normalize=False,train_test=False,type_Dataframe=True,columns=None,method=None):
    self.DataFrame=DataFrame
    tabla_supervised=pd.DataFrame()
    if columns==None:  
      name_column_x=str(input('Nombre de la columna X \n'))
      name_column_y=str(input('Nombre de la columna Y \n'))
    else:
      if method==1:    
          name_column_x='PHI N (FRACTION)'
          name_column_y='RQI (mm^2)'
          
      elif method==2:
          name_column_x='PHI R (FRACTION)'
          name_column_y='K Air (md)'
          
      elif method==3:
          name_column_x='K WITH FZI'
          name_column_y='K Air (md)'

    if type_Dataframe:
        tabla_supervised['UH']=['HU-%d' %(i+1) for i in range(len(self.DataFrame))]
        if train_test:
          SLOPE=[]
          CUT=[]
          YP=[]
          MAE=[]
          MSR=[]
          R2=[]
          for i in range(len(self.DataFrame)):
              x=self.DataFrame[i][name_column_x].values.reshape(-1,1)
              y=self.DataFrame[i][name_column_y].values.reshape(-1,1)
              x_train,x_test,y_train,y_test=train_test_split(x,y,test_size=0.8,random_state=42)      
              lr=LinearRegression(fit_intercept=intercept,normalize=normalize)
              lr.fit(x_train,y_train)
              yp=lr.predict(x_test)
              r2=lr.score(x_test,y_test)
              b=lr.coef_
              a=lr.intercept_
              mae=mean_absolute_error(y_test,yp)
              msr=mean_squared_error(y_test,yp)
              SLOPE.append(b)
              CUT.append(a)
              MAE.append(mae)
              MSR.append(msr)
              R2.append(r2)
          
          tabla_supervised['SLOPE']=SLOPE
          if intercept!=0:
            tabla_supervised['CUT Y']=CUT
          tabla_supervised['MAE']=MAE
          tabla_supervised['MSR']=MSR
          tabla_supervised['R2']=R2
          self.tabla_supervised=tabla_supervised

        else:
          SLOPE=[]
          CUT=[]
          YP=[]
          MAE=[]
          MSR=[]
          R2=[]
          for i in range(len(self.DataFrame)):
              x=self.DataFrame[i][name_column_x].values.reshape(-1,1)
              y=self.DataFrame[i][name_column_y].values.reshape(-1,1)
              lr=LinearRegression(fit_intercept=intercept,normalize=normalize)
              lr.fit(x,y)
              yp=lr.predict(x)
              r2=lr.score(x,y)
              b=lr.coef_
              a=lr.intercept_
              mae=mean_absolute_error(y,yp)
              msr=mean_squared_error(y,yp)
              SLOPE.append(b)
              CUT.append(a)
              MAE.append(mae)
              MSR.append(msr)
              R2.append(r2)

          tabla_supervised['SLOPE']=SLOPE
          if intercept!=0:
            tabla_supervised['CUT Y']=CUT
          tabla_supervised['MAE']=MAE
          tabla_supervised['MSR']=MSR
          tabla_supervised['R2']=R2
          self.tabla_supervised=tabla_supervised
    else:
      if train_test:
          SLOPE=[]
          CUT=[]
          YP=[]
          MAE=[]
          MSR=[]
          R2=[]
          x=self.DataFrame[name_column_x].values.reshape(-1,1)
          y=self.DataFrame[name_column_y].values.reshape(-1,1)
          x_train,x_test,y_train,y_test=train_test_split(x,y,test_size=0.8,random_state=42)      
          lr=LinearRegression(fit_intercept=intercept,normalize=normalize)
          lr.fit(x_train,y_train)
          yp=lr.predict(x_test)
          r2=lr.score(x_test,y_test)
          b=lr.coef_
          a=lr.intercept_
          mae=mean_absolute_error(y_test,yp)
          msr=mean_squared_error(y_test,yp)
          SLOPE.append(b)
          CUT.append(a)
          MAE.append(mae)
          MSR.append(msr)
          R2.append(r2)
          
          tabla_supervised['SLOPE']=SLOPE
          if intercept!=0:
            tabla_supervised['CUT Y']=CUT
          tabla_supervised['MAE']=MAE
          tabla_supervised['MSR']=MSR
          tabla_supervised['R2']=R2
          self.tabla_supervised=tabla_supervised

      else:
          SLOPE=[]
          CUT=[]
          YP=[]
          MAE=[]
          MSR=[]
          R2=[]
          x=self.DataFrame[name_column_x].values.reshape(-1,1)
          y=self.DataFrame[name_column_y].values.reshape(-1,1)
          lr=LinearRegression(fit_intercept=intercept,normalize=normalize)
          lr.fit(x,y)
          yp=lr.predict(x)
          r2=lr.score(x,y)
          b=lr.coef_
          a=lr.intercept_
          mae=mean_absolute_error(y,yp)
          msr=mean_squared_error(y,yp)
          SLOPE.append(b)
          CUT.append(a)
          MAE.append(mae)
          MSR.append(msr)
          R2.append(r2)

          tabla_supervised['SLOPE']=SLOPE
          if intercept!=0:
            tabla_supervised['CUT Y']=CUT
          tabla_supervised['MAE']=MAE
          tabla_supervised['MSR']=MSR
          tabla_supervised['R2']=R2
          self.tabla_supervised=tabla_supervised
    return self.tabla_supervised
  
  def interceptos(self,x,y,b):
    y=np.log10(y)
    x=np.log10(x)
    a= y.mean() -(b*x.mean())
    return a

"""##METODO ACUMULADO"""

class FZI_PLOTS(PLOTS_BY_DETERMINE_UH,regressions):

  def __init__(self,DataFrame,columna_de_K,columna_de_PHI):
    super().__init__(DataFrame,columna_de_K,columna_de_PHI)
  
  def number_UH(self):
    values_by_UH=[]
    for i in range(int(input('Escriba el número de UH observadas:  \n'))):
      if i==0:
        valor_inicial=float(input(f'El valor inicial de FZI de la UH {i+1} es : \n'))
        valor_final=float(input(f'El valor final de FZI de la UH {i+1} es : \n'))
        values_by_UH.append([valor_inicial,valor_final])
        valor_inicial=valor_final
      else:
        valor_final=float(input(f'El valor final de FZI de la UH {i+1} es : \n'))
        values_by_UH.append([valor_inicial,valor_final])
        valor_inicial=valor_final
    
    unidades_hidraulicas=['HC-%d'%(i+1) for i in range(len(values_by_UH))]

    if values_by_UH[0][0]!=0:
      TVU=self.values_normalized # TABLA DE VALORES USADOS (TVU)
      TVU=TVU.loc[TVU['FZI']>=values_by_UH[0][0]].reset_index(drop=True,inplace=False) 
    else:
      TVU=self.values_sort.dropna(subset = ['FZI'], inplace=False)

    longitud=len(values_by_UH)-1
    maximo_valor_de_FZI=int(max(TVU['FZI']))

    if int(values_by_UH[longitud][1])!=maximo_valor_de_FZI:
      TVU=TVU.loc[TVU['FZI']<=values_by_UH[longitud][1]]
    else:
      pass
    
    copy_TVU=TVU

    for i in range(len(values_by_UH)):
      if values_by_UH[0][0]==0:
        unidades_hidraulicas[i]=copy_TVU.loc[copy_TVU['FZI']<=values_by_UH[i][1]]
        copy_TVU=copy_TVU.drop(copy_TVU[copy_TVU['FZI']<=values_by_UH[i][1]].index)
      elif i==0:
        copy_TVU=copy_TVU.loc[copy_TVU['FZI']!=0]
        unidades_hidraulicas[i]=copy_TVU.loc[copy_TVU['FZI']<=values_by_UH[i][1]]
        copy_TVU=copy_TVU.drop(copy_TVU[copy_TVU['FZI']<=values_by_UH[i][1]].index)
      else:
        unidades_hidraulicas[i]=copy_TVU.loc[copy_TVU['FZI']<=values_by_UH[i][1]]
        copy_TVU=copy_TVU.drop(copy_TVU[copy_TVU['FZI']<=values_by_UH[i][1]].index)

    for i in range(len(unidades_hidraulicas)):
      unidades_hidraulicas[i]=unidades_hidraulicas[i].reset_index(drop=True,inplace=False) 

    conteo=[]
    for i in range(len(unidades_hidraulicas)):
      name_uh=['HC%d'%(i+1) for i in range(len(values_by_UH))]
      length=len(unidades_hidraulicas[i])
      for m in range(length):
        ct=name_uh[i]
        conteo.append(ct)
    TVU['UH']=conteo
    TVU=TVU[['UH', 'WELL', 'K Air (md)', 'Porosity (%)', 'Facies', 'RQI (mm^2)' ,'PHI N (FRACTION)', 'PHI R (FRACTION)','K/PHI' ,'FZI', 'Swir (Fraction)', 'PHI E (%)']]
    self.TVU=TVU
    self.UH=unidades_hidraulicas
    return self.TVU,self.UH
  
  def RQI_vs_PHIN_Regression_dada(self):
    r=regressions()
    table=r.linear_regression_manual(DataFrame=self.UH,columns=True,method=1)
    fig=px.scatter(self.TVU,x='PHI N (FRACTION)',y='RQI (mm^2)',color='UH',
                   log_x=True,log_y=True,
                   marginal_x='box',marginal_y='box',
                   hover_name='UH',
                   hover_data=self.TVU.columns)
    for i in range(len(table)):
      fig.add_trace(go.Scatter(x=table['X'][i],
                                y=table['Y'][i],
                                mode="lines",
                                showlegend=False))

    fig2 = go.Figure(data=[go.Table( header=dict(values=list(table.columns),
                                                  fill_color='paleturquoise',
                                                  align='left'),
                                      cells=dict(values=[table.UH,table.X, table.Y, table.SLOPE,table.R2],
                                                fill_color='lavender',
                                                align='left'))
                            ])    

    fig3=px.scatter_3d(self.TVU,x='PHI N (FRACTION)',y='RQI (mm^2)',z='FZI',
                       symbol='UH',color='UH',size='FZI',
                       log_x=True,log_y=True,
                       hover_data=self.TVU.columns, 
                       template='plotly_dark')
    
    return display(fig, fig2, fig3)

  def RQI_vs_PHIN_Regression(self):
    r=regressions()
    table=r.linear_regression_supervised(self.UH,intercept=0,columns=True,method=1)     
    fig=px.scatter(self.TVU,x='PHI N (FRACTION)',y='RQI (mm^2)',color='UH',
                   log_x=True,log_y=True,
                   marginal_x='box',marginal_y='box',
                   hover_name='UH',
                   hover_data=self.TVU.columns)
    for i in range(len(table)):
      x_phin=pd.DataFrame({'X':self.UH[i]['PHI N (FRACTION)']})
      xi=pd.DataFrame({'X':[0.01,1]})
      values_x_adjust=pd.concat([x_phin,xi], axis=0,sort=True)
      values_x_adjust['Y']=r.equation_lineal(values_x_adjust,0,table.SLOPE[i])
      fig.add_trace(go.Scatter(x=values_x_adjust['X'],
                                y=values_x_adjust['Y'],
                                mode="lines",
                                showlegend=False))

    fig2 = go.Figure(data=[go.Table( header=dict(values=list(table.columns),
                                                  fill_color='paleturquoise',
                                                  align='left'),
                                      cells=dict(values=[table.UH,table.SLOPE,table.MAE, table.MSR, table.R2],
                                                fill_color='lavender',
                                                align='left'))
                            ])       
    return display(fig, fig2)

  def K_vs_PHIR_Regression(self):
      r=regressions()
      table=r.linear_regression_supervised(self.UH,intercept=0,columns=True,method=2)
      fig=px.scatter(self.TVU,x='PHI R (FRACTION)',y='K Air (md)',color='UH',
                    log_x=True,log_y=True,
                    #marginal_x='box',marginal_y='box',
                    hover_name='UH',
                    hover_data=self.TVU.columns)
      for i in range(len(table)):
        x_phin=pd.DataFrame({'X':self.UH[i]['PHI R (FRACTION)']})
        xi=pd.DataFrame({'X':[0.000001,1]})
        values_x_adjust=pd.concat([x_phin,xi], axis=0,sort=True)
        values_x_adjust['Y']=r.equation_lineal(values_x_adjust,0,table.SLOPE[i])
        fig.add_trace(go.Scatter(x=values_x_adjust['X'],
                                  y=values_x_adjust['Y'],
                                  mode="lines",
                                  showlegend=False))
      table.SLOPE=(table.SLOPE/1014)**0.5   
      fig2 = go.Figure(data=[go.Table( header=dict(values=list(table.columns),
                                                    fill_color='paleturquoise',
                                                    align='left'),
                                        cells=dict(values=[table.UH,table.SLOPE,table.MAE, table.MSR, table.R2],
                                                  fill_color='lavender',
                                                  align='left'))
                              ])       
      return display(fig, fig2)

  def KPHI_vs_PHIN_Regression(self):
      r=regressions()
      A=[]
      MAE=[]
      MSR=[]
      R2=[]
      for i in range(len(self.UH)):
        a=r.interceptos(self.UH[i]['PHI N (FRACTION)'],self.UH[i]['K/PHI'],2)
        a=10**(a)
        A.append(a)
        mae=mean_absolute_error(self.UH[i]['K/PHI'], a*((self.UH[i]['PHI N (FRACTION)'])**2) )
        msr=mean_squared_error(self.UH[i]['K/PHI'], a*((self.UH[i]['PHI N (FRACTION)'])**2) )
        MAE.append(mae)
        MSR.append(msr)
        r2=r2_score(self.UH[i]['K/PHI'], a*((self.UH[i]['PHI N (FRACTION)'])**2))
        r2='%0.4f' %(r2)
        R2.append(r2)
        

      table=pd.DataFrame()
      table['UH']=['HC-%d' %(i+1) for i in range(len(self.UH))]
      table['SLOPE']=A
      table['MAE']=MAE
      table['MSR']=MSR
      table['R2']=R2
      fig=px.scatter(self.TVU,x='PHI N (FRACTION)',y='K/PHI',color='UH',
                    log_x=True,log_y=True,
                    #marginal_x='box',marginal_y='box',
                    hover_name='UH',
                    hover_data=self.TVU.columns)
      for i in range(len(table)):
        x_phin=pd.DataFrame({'X':self.UH[i]['PHI N (FRACTION)']})
        xi=pd.DataFrame({'X':[0.01,1]})
        values_x_adjust=pd.concat([x_phin,xi], axis=0,sort=True)
        values_x_adjust['Y']=r.equation_potencial(values_x_adjust,table.SLOPE[i],2)
        fig.add_trace(go.Scatter(x=values_x_adjust['X'],
                                  y=values_x_adjust['Y'],
                                  mode="lines",
                                  showlegend=False))  
      table.SLOPE=(table.SLOPE/1014)**0.5  
      fig2 = go.Figure(data=[go.Table( header=dict(values=list(table.columns),
                                                    fill_color='paleturquoise',
                                                    align='left'),
                                        cells=dict(values=[table.UH,table.SLOPE,table.MAE, table.MSR, table.R2],
                                                  fill_color='lavender',
                                                  align='left'))
                              ])       
      return display(fig, fig2)

  def CHOICES_SLOPES(self):
    Slopes=[]
    for i in range(len(self.UH)):
      slope=float(input('VALOR DE LA PENDIENTE PARA HC-%d : '%(i+1)))
      Slopes.append(slope)
    self.Slopes=Slopes
    
  
  def K_WITH_FZI(self):
    def K_mean(fzi_mean,phi_r):
      k_mean=1014*((fzi_mean)**2)*(phi_r)
      return k_mean
    
    for i in range(len(self.UH)):
      k_mean=K_mean(self.Slopes[i],self.UH[i]['PHI R (FRACTION)'])
      self.UH[i]['K WITH FZI']=k_mean
    k=[]
    for i in range(len(self.UH)):
      porosidad=self.UH[i]['K WITH FZI']
      for m in range(len(porosidad)):
          k_mean=self.UH[i]['K WITH FZI'][m]
          k.append(k_mean)
          
    self.TVU['K WITH FZI']=k
    self.TVU.drop(['PHI R (FRACTION)','K/PHI'],axis=1)
    self.TVU=self.TVU[['UH', 'WELL', 'K Air (md)', 'Porosity (%)', 'Facies', 'RQI (mm^2)' ,'PHI N (FRACTION)', 'FZI', 'Swir (Fraction)', 'PHI E (%)','K WITH FZI']]

    r=regressions()
    table=r.linear_regression_supervised(self.TVU,intercept=0,type_Dataframe=False,columns=True,method=3)
    fig=px.scatter(self.TVU,x='K WITH FZI',y='K Air (md)',color='UH',
                    log_x=True,log_y=True,
                    marginal_x='box',marginal_y='box',
                    hover_name='UH',
                    hover_data=self.TVU.columns)
    x_k=pd.DataFrame({'X':self.TVU['K WITH FZI']})
    xi=pd.DataFrame({'X':[0.01,1.5e4]})
    values_x_adjust=pd.concat([x_k,xi], axis=0,sort=True)
    values_x_adjust['Y']=r.equation_lineal(values_x_adjust,0,table.SLOPE[0])
    fig.add_trace(go.Scatter(x=values_x_adjust['X'],
                              y=values_x_adjust['Y'],
                              mode="lines",
                              showlegend=False))
    fig2 = go.Figure(data=[go.Table( header=dict(values=list(table.columns),
                                                    fill_color='paleturquoise',
                                                    align='left'),
                                        cells=dict(values=[table.SLOPE,table.MAE, table.MSR, table.R2],
                                                  fill_color='lavender',
                                                  align='left'))
    ])

    return display(fig,fig2)

  def import_excel(self):
    self.TVU.to_excel('TABLA_DE_VALORES_USADOS.xlsx',index=False)
    for i in range(len(self.UH)):
      self.UH[i].to_excel('UH%d.xlsx' %(i+1),index=False)