"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const core_1 = require("@aws-cdk/core");
function parseBucketArn(construct, props) {
    // if we have an explicit bucket ARN, use it.
    if (props.bucketArn) {
        return props.bucketArn;
    }
    if (props.bucketName) {
        return core_1.Stack.of(construct).formatArn({
            // S3 Bucket names are globally unique in a partition,
            // and so their ARNs have empty region and account components
            region: '',
            account: '',
            service: 's3',
            resource: props.bucketName
        });
    }
    throw new Error('Cannot determine bucket ARN. At least `bucketArn` or `bucketName` is needed');
}
exports.parseBucketArn = parseBucketArn;
function parseBucketName(construct, props) {
    // if we have an explicit bucket name, use it.
    if (props.bucketName) {
        return props.bucketName;
    }
    // extract bucket name from bucket arn
    if (props.bucketArn) {
        return core_1.Stack.of(construct).parseArn(props.bucketArn).resource;
    }
    // no bucket name is okay since it's optional.
    return undefined;
}
exports.parseBucketName = parseBucketName;
//# sourceMappingURL=data:application/json;base64,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