/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CortexSearchServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the list of columns in the base table to enable filtering on when issuing queries to the service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#attributes CortexSearchService#attributes}
    */
    readonly attributes?: string[];
    /**
    * Specifies a comment for the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#comment CortexSearchService#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#database CortexSearchService#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#id CortexSearchService#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the Cortex search service. The name must be unique for the schema in which the service is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#name CortexSearchService#name}
    */
    readonly name: string;
    /**
    * Specifies the column to use as the search column for the Cortex search service; must be a text value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#on CortexSearchService#on}
    */
    readonly on: string;
    /**
    * Specifies the query to use to populate the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#query CortexSearchService#query}
    */
    readonly query: string;
    /**
    * The schema in which to create the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#schema CortexSearchService#schema}
    */
    readonly schema: string;
    /**
    * Specifies the maximum target lag time for the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#target_lag CortexSearchService#target_lag}
    */
    readonly targetLag: string;
    /**
    * The warehouse in which to create the Cortex search service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#warehouse CortexSearchService#warehouse}
    */
    readonly warehouse: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#timeouts CortexSearchService#timeouts}
    */
    readonly timeouts?: CortexSearchServiceTimeouts;
}
export interface CortexSearchServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#create CortexSearchService#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#update CortexSearchService#update}
    */
    readonly update?: string;
}
export declare function cortexSearchServiceTimeoutsToTerraform(struct?: CortexSearchServiceTimeouts | cdktf.IResolvable): any;
export declare function cortexSearchServiceTimeoutsToHclTerraform(struct?: CortexSearchServiceTimeouts | cdktf.IResolvable): any;
export declare class CortexSearchServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CortexSearchServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CortexSearchServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service snowflake_cortex_search_service}
*/
export declare class CortexSearchService extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_cortex_search_service";
    /**
    * Generates CDKTF code for importing a CortexSearchService resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the CortexSearchService to import
    * @param importFromId The id of the existing CortexSearchService that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the CortexSearchService to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/cortex_search_service snowflake_cortex_search_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CortexSearchServiceConfig
    */
    constructor(scope: Construct, id: string, config: CortexSearchServiceConfig);
    private _attributes?;
    get attributes(): string[];
    set attributes(value: string[]);
    resetAttributes(): void;
    get attributesInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _on?;
    get on(): string;
    set on(value: string);
    get onInput(): string | undefined;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _targetLag?;
    get targetLag(): string;
    set targetLag(value: string);
    get targetLagInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    get warehouseInput(): string | undefined;
    private _timeouts;
    get timeouts(): CortexSearchServiceTimeoutsOutputReference;
    putTimeouts(value: CortexSearchServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CortexSearchServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
