/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeConnectionsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/connections#id DataSnowflakeConnections#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/connections#like DataSnowflakeConnections#like}
    */
    readonly like?: string;
}
export interface DataSnowflakeConnectionsConnectionsShowOutput {
}
export declare function dataSnowflakeConnectionsConnectionsShowOutputToTerraform(struct?: DataSnowflakeConnectionsConnectionsShowOutput): any;
export declare function dataSnowflakeConnectionsConnectionsShowOutputToHclTerraform(struct?: DataSnowflakeConnectionsConnectionsShowOutput): any;
export declare class DataSnowflakeConnectionsConnectionsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeConnectionsConnectionsShowOutput | undefined;
    set internalValue(value: DataSnowflakeConnectionsConnectionsShowOutput | undefined);
    get accountLocator(): string;
    get accountName(): string;
    get comment(): string;
    get connectionUrl(): string;
    get createdOn(): string;
    get failoverAllowedToAccounts(): string[];
    get isPrimary(): cdktf.IResolvable;
    get name(): string;
    get organizationName(): string;
    get primary(): string;
    get regionGroup(): string;
    get snowflakeRegion(): string;
}
export declare class DataSnowflakeConnectionsConnectionsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeConnectionsConnectionsShowOutputOutputReference;
}
export interface DataSnowflakeConnectionsConnections {
}
export declare function dataSnowflakeConnectionsConnectionsToTerraform(struct?: DataSnowflakeConnectionsConnections): any;
export declare function dataSnowflakeConnectionsConnectionsToHclTerraform(struct?: DataSnowflakeConnectionsConnections): any;
export declare class DataSnowflakeConnectionsConnectionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeConnectionsConnections | undefined;
    set internalValue(value: DataSnowflakeConnectionsConnections | undefined);
    private _showOutput;
    get showOutput(): DataSnowflakeConnectionsConnectionsShowOutputList;
}
export declare class DataSnowflakeConnectionsConnectionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeConnectionsConnectionsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/connections snowflake_connections}
*/
export declare class DataSnowflakeConnections extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_connections";
    /**
    * Generates CDKTF code for importing a DataSnowflakeConnections resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeConnections to import
    * @param importFromId The id of the existing DataSnowflakeConnections that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/connections#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeConnections to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/connections snowflake_connections} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeConnectionsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeConnectionsConfig);
    private _connections;
    get connections(): DataSnowflakeConnectionsConnectionsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
