/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeCortexSearchServicesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#id DataSnowflakeCortexSearchServices#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#like DataSnowflakeCortexSearchServices#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#starts_with DataSnowflakeCortexSearchServices#starts_with}
    */
    readonly startsWith?: string;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#in DataSnowflakeCortexSearchServices#in}
    */
    readonly in?: DataSnowflakeCortexSearchServicesIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#limit DataSnowflakeCortexSearchServices#limit}
    */
    readonly limit?: DataSnowflakeCortexSearchServicesLimit;
}
export interface DataSnowflakeCortexSearchServicesCortexSearchServices {
}
export declare function dataSnowflakeCortexSearchServicesCortexSearchServicesToTerraform(struct?: DataSnowflakeCortexSearchServicesCortexSearchServices): any;
export declare function dataSnowflakeCortexSearchServicesCortexSearchServicesToHclTerraform(struct?: DataSnowflakeCortexSearchServicesCortexSearchServices): any;
export declare class DataSnowflakeCortexSearchServicesCortexSearchServicesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeCortexSearchServicesCortexSearchServices | undefined;
    set internalValue(value: DataSnowflakeCortexSearchServicesCortexSearchServices | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get schemaName(): string;
}
export declare class DataSnowflakeCortexSearchServicesCortexSearchServicesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeCortexSearchServicesCortexSearchServicesOutputReference;
}
export interface DataSnowflakeCortexSearchServicesIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#account DataSnowflakeCortexSearchServices#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database (db_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#database DataSnowflakeCortexSearchServices#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema (schema_name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#schema DataSnowflakeCortexSearchServices#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeCortexSearchServicesInToTerraform(struct?: DataSnowflakeCortexSearchServicesInOutputReference | DataSnowflakeCortexSearchServicesIn): any;
export declare function dataSnowflakeCortexSearchServicesInToHclTerraform(struct?: DataSnowflakeCortexSearchServicesInOutputReference | DataSnowflakeCortexSearchServicesIn): any;
export declare class DataSnowflakeCortexSearchServicesInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeCortexSearchServicesIn | undefined;
    set internalValue(value: DataSnowflakeCortexSearchServicesIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeCortexSearchServicesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#from DataSnowflakeCortexSearchServices#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#rows DataSnowflakeCortexSearchServices#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeCortexSearchServicesLimitToTerraform(struct?: DataSnowflakeCortexSearchServicesLimitOutputReference | DataSnowflakeCortexSearchServicesLimit): any;
export declare function dataSnowflakeCortexSearchServicesLimitToHclTerraform(struct?: DataSnowflakeCortexSearchServicesLimitOutputReference | DataSnowflakeCortexSearchServicesLimit): any;
export declare class DataSnowflakeCortexSearchServicesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeCortexSearchServicesLimit | undefined;
    set internalValue(value: DataSnowflakeCortexSearchServicesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services snowflake_cortex_search_services}
*/
export declare class DataSnowflakeCortexSearchServices extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_cortex_search_services";
    /**
    * Generates CDKTF code for importing a DataSnowflakeCortexSearchServices resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeCortexSearchServices to import
    * @param importFromId The id of the existing DataSnowflakeCortexSearchServices that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeCortexSearchServices to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/cortex_search_services snowflake_cortex_search_services} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeCortexSearchServicesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeCortexSearchServicesConfig);
    private _cortexSearchServices;
    get cortexSearchServices(): DataSnowflakeCortexSearchServicesCortexSearchServicesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _in;
    get in(): DataSnowflakeCortexSearchServicesInOutputReference;
    putIn(value: DataSnowflakeCortexSearchServicesIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeCortexSearchServicesIn | undefined;
    private _limit;
    get limit(): DataSnowflakeCortexSearchServicesLimitOutputReference;
    putLimit(value: DataSnowflakeCortexSearchServicesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeCortexSearchServicesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
