/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeGrantsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#id DataSnowflakeGrants#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * future_grants_in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#future_grants_in DataSnowflakeGrants#future_grants_in}
    */
    readonly futureGrantsIn?: DataSnowflakeGrantsFutureGrantsIn;
    /**
    * future_grants_to block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#future_grants_to DataSnowflakeGrants#future_grants_to}
    */
    readonly futureGrantsTo?: DataSnowflakeGrantsFutureGrantsTo;
    /**
    * grants_of block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#grants_of DataSnowflakeGrants#grants_of}
    */
    readonly grantsOf?: DataSnowflakeGrantsGrantsOf;
    /**
    * grants_on block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#grants_on DataSnowflakeGrants#grants_on}
    */
    readonly grantsOn?: DataSnowflakeGrantsGrantsOn;
    /**
    * grants_to block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#grants_to DataSnowflakeGrants#grants_to}
    */
    readonly grantsTo?: DataSnowflakeGrantsGrantsTo;
}
export interface DataSnowflakeGrantsGrants {
}
export declare function dataSnowflakeGrantsGrantsToTerraform(struct?: DataSnowflakeGrantsGrants): any;
export declare function dataSnowflakeGrantsGrantsToHclTerraform(struct?: DataSnowflakeGrantsGrants): any;
export declare class DataSnowflakeGrantsGrantsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeGrantsGrants | undefined;
    set internalValue(value: DataSnowflakeGrantsGrants | undefined);
    get createdOn(): string;
    get grantOption(): cdktf.IResolvable;
    get grantedBy(): string;
    get grantedOn(): string;
    get grantedTo(): string;
    get granteeName(): string;
    get name(): string;
    get privilege(): string;
}
export declare class DataSnowflakeGrantsGrantsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeGrantsGrantsOutputReference;
}
export interface DataSnowflakeGrantsFutureGrantsIn {
    /**
    * Lists all privileges on new (i.e. future) objects of a specified type in the database granted to a role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#database DataSnowflakeGrants#database}
    */
    readonly database?: string;
    /**
    * Lists all privileges on new (i.e. future) objects of a specified type in the schema granted to a role. Schema must be a fully qualified name ("&lt;db_name&gt;"."&lt;schema_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#schema DataSnowflakeGrants#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeGrantsFutureGrantsInToTerraform(struct?: DataSnowflakeGrantsFutureGrantsInOutputReference | DataSnowflakeGrantsFutureGrantsIn): any;
export declare function dataSnowflakeGrantsFutureGrantsInToHclTerraform(struct?: DataSnowflakeGrantsFutureGrantsInOutputReference | DataSnowflakeGrantsFutureGrantsIn): any;
export declare class DataSnowflakeGrantsFutureGrantsInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsFutureGrantsIn | undefined;
    set internalValue(value: DataSnowflakeGrantsFutureGrantsIn | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeGrantsFutureGrantsTo {
    /**
    * Lists all privileges on new (i.e. future) objects of a specified type in a database or schema granted to the account role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#account_role DataSnowflakeGrants#account_role}
    */
    readonly accountRole?: string;
    /**
    * Lists all privileges on new (i.e. future) objects granted to the database role. Must be a fully qualified name ("&lt;db_name&gt;"."&lt;database_role_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#database_role DataSnowflakeGrants#database_role}
    */
    readonly databaseRole?: string;
}
export declare function dataSnowflakeGrantsFutureGrantsToToTerraform(struct?: DataSnowflakeGrantsFutureGrantsToOutputReference | DataSnowflakeGrantsFutureGrantsTo): any;
export declare function dataSnowflakeGrantsFutureGrantsToToHclTerraform(struct?: DataSnowflakeGrantsFutureGrantsToOutputReference | DataSnowflakeGrantsFutureGrantsTo): any;
export declare class DataSnowflakeGrantsFutureGrantsToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsFutureGrantsTo | undefined;
    set internalValue(value: DataSnowflakeGrantsFutureGrantsTo | undefined);
    private _accountRole?;
    get accountRole(): string;
    set accountRole(value: string);
    resetAccountRole(): void;
    get accountRoleInput(): string | undefined;
    private _databaseRole?;
    get databaseRole(): string;
    set databaseRole(value: string);
    resetDatabaseRole(): void;
    get databaseRoleInput(): string | undefined;
}
export interface DataSnowflakeGrantsGrantsOf {
    /**
    * Lists all users and roles to which the account role has been granted.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#account_role DataSnowflakeGrants#account_role}
    */
    readonly accountRole?: string;
    /**
    * Lists all the users and roles to which the application role has been granted. Must be a fully qualified name ("&lt;db_name&gt;"."&lt;database_role_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#application_role DataSnowflakeGrants#application_role}
    */
    readonly applicationRole?: string;
    /**
    * Lists all users and roles to which the database role has been granted. Must be a fully qualified name ("&lt;db_name&gt;"."&lt;database_role_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#database_role DataSnowflakeGrants#database_role}
    */
    readonly databaseRole?: string;
    /**
    * Lists all the accounts for the share and indicates the accounts that are using the share.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#share DataSnowflakeGrants#share}
    */
    readonly share?: string;
}
export declare function dataSnowflakeGrantsGrantsOfToTerraform(struct?: DataSnowflakeGrantsGrantsOfOutputReference | DataSnowflakeGrantsGrantsOf): any;
export declare function dataSnowflakeGrantsGrantsOfToHclTerraform(struct?: DataSnowflakeGrantsGrantsOfOutputReference | DataSnowflakeGrantsGrantsOf): any;
export declare class DataSnowflakeGrantsGrantsOfOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsGrantsOf | undefined;
    set internalValue(value: DataSnowflakeGrantsGrantsOf | undefined);
    private _accountRole?;
    get accountRole(): string;
    set accountRole(value: string);
    resetAccountRole(): void;
    get accountRoleInput(): string | undefined;
    private _applicationRole?;
    get applicationRole(): string;
    set applicationRole(value: string);
    resetApplicationRole(): void;
    get applicationRoleInput(): string | undefined;
    private _databaseRole?;
    get databaseRole(): string;
    set databaseRole(value: string);
    resetDatabaseRole(): void;
    get databaseRoleInput(): string | undefined;
    private _share?;
    get share(): string;
    set share(value: string);
    resetShare(): void;
    get shareInput(): string | undefined;
}
export interface DataSnowflakeGrantsGrantsOn {
    /**
    * Object hierarchy to list privileges on. The only valid value is: ACCOUNT. Setting this attribute lists all the account-level (i.e. global) privileges that have been granted to roles.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#account DataSnowflakeGrants#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Name of object to list privileges on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#object_name DataSnowflakeGrants#object_name}
    */
    readonly objectName?: string;
    /**
    * Type of object to list privileges on.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#object_type DataSnowflakeGrants#object_type}
    */
    readonly objectType?: string;
}
export declare function dataSnowflakeGrantsGrantsOnToTerraform(struct?: DataSnowflakeGrantsGrantsOnOutputReference | DataSnowflakeGrantsGrantsOn): any;
export declare function dataSnowflakeGrantsGrantsOnToHclTerraform(struct?: DataSnowflakeGrantsGrantsOnOutputReference | DataSnowflakeGrantsGrantsOn): any;
export declare class DataSnowflakeGrantsGrantsOnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsGrantsOn | undefined;
    set internalValue(value: DataSnowflakeGrantsGrantsOn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _objectName?;
    get objectName(): string;
    set objectName(value: string);
    resetObjectName(): void;
    get objectNameInput(): string | undefined;
    private _objectType?;
    get objectType(): string;
    set objectType(value: string);
    resetObjectType(): void;
    get objectTypeInput(): string | undefined;
}
export interface DataSnowflakeGrantsGrantsToShare {
    /**
    * Lists all of the privileges and roles granted to the specified share.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#share_name DataSnowflakeGrants#share_name}
    */
    readonly shareName: string;
}
export declare function dataSnowflakeGrantsGrantsToShareToTerraform(struct?: DataSnowflakeGrantsGrantsToShareOutputReference | DataSnowflakeGrantsGrantsToShare): any;
export declare function dataSnowflakeGrantsGrantsToShareToHclTerraform(struct?: DataSnowflakeGrantsGrantsToShareOutputReference | DataSnowflakeGrantsGrantsToShare): any;
export declare class DataSnowflakeGrantsGrantsToShareOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsGrantsToShare | undefined;
    set internalValue(value: DataSnowflakeGrantsGrantsToShare | undefined);
    private _shareName?;
    get shareName(): string;
    set shareName(value: string);
    get shareNameInput(): string | undefined;
}
export interface DataSnowflakeGrantsGrantsTo {
    /**
    * Lists all privileges and roles granted to the role.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#account_role DataSnowflakeGrants#account_role}
    */
    readonly accountRole?: string;
    /**
    * Lists all the privileges and roles granted to the application.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#application DataSnowflakeGrants#application}
    */
    readonly application?: string;
    /**
    * Lists all the privileges and roles granted to the application role. Must be a fully qualified name ("&lt;app_name&gt;"."&lt;app_role_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#application_role DataSnowflakeGrants#application_role}
    */
    readonly applicationRole?: string;
    /**
    * Lists all privileges and roles granted to the database role. Must be a fully qualified name ("&lt;db_name&gt;"."&lt;database_role_name&gt;").
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#database_role DataSnowflakeGrants#database_role}
    */
    readonly databaseRole?: string;
    /**
    * Lists all the roles granted to the user. Note that the PUBLIC role, which is automatically available to every user, is not listed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#user DataSnowflakeGrants#user}
    */
    readonly user?: string;
    /**
    * share block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#share DataSnowflakeGrants#share}
    */
    readonly share?: DataSnowflakeGrantsGrantsToShare;
}
export declare function dataSnowflakeGrantsGrantsToToTerraform(struct?: DataSnowflakeGrantsGrantsToOutputReference | DataSnowflakeGrantsGrantsTo): any;
export declare function dataSnowflakeGrantsGrantsToToHclTerraform(struct?: DataSnowflakeGrantsGrantsToOutputReference | DataSnowflakeGrantsGrantsTo): any;
export declare class DataSnowflakeGrantsGrantsToOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeGrantsGrantsTo | undefined;
    set internalValue(value: DataSnowflakeGrantsGrantsTo | undefined);
    private _accountRole?;
    get accountRole(): string;
    set accountRole(value: string);
    resetAccountRole(): void;
    get accountRoleInput(): string | undefined;
    private _application?;
    get application(): string;
    set application(value: string);
    resetApplication(): void;
    get applicationInput(): string | undefined;
    private _applicationRole?;
    get applicationRole(): string;
    set applicationRole(value: string);
    resetApplicationRole(): void;
    get applicationRoleInput(): string | undefined;
    private _databaseRole?;
    get databaseRole(): string;
    set databaseRole(value: string);
    resetDatabaseRole(): void;
    get databaseRoleInput(): string | undefined;
    private _user?;
    get user(): string;
    set user(value: string);
    resetUser(): void;
    get userInput(): string | undefined;
    private _share;
    get share(): DataSnowflakeGrantsGrantsToShareOutputReference;
    putShare(value: DataSnowflakeGrantsGrantsToShare): void;
    resetShare(): void;
    get shareInput(): DataSnowflakeGrantsGrantsToShare | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants snowflake_grants}
*/
export declare class DataSnowflakeGrants extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_grants";
    /**
    * Generates CDKTF code for importing a DataSnowflakeGrants resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeGrants to import
    * @param importFromId The id of the existing DataSnowflakeGrants that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeGrants to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/data-sources/grants snowflake_grants} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeGrantsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeGrantsConfig);
    private _grants;
    get grants(): DataSnowflakeGrantsGrantsList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _futureGrantsIn;
    get futureGrantsIn(): DataSnowflakeGrantsFutureGrantsInOutputReference;
    putFutureGrantsIn(value: DataSnowflakeGrantsFutureGrantsIn): void;
    resetFutureGrantsIn(): void;
    get futureGrantsInInput(): DataSnowflakeGrantsFutureGrantsIn | undefined;
    private _futureGrantsTo;
    get futureGrantsTo(): DataSnowflakeGrantsFutureGrantsToOutputReference;
    putFutureGrantsTo(value: DataSnowflakeGrantsFutureGrantsTo): void;
    resetFutureGrantsTo(): void;
    get futureGrantsToInput(): DataSnowflakeGrantsFutureGrantsTo | undefined;
    private _grantsOf;
    get grantsOf(): DataSnowflakeGrantsGrantsOfOutputReference;
    putGrantsOf(value: DataSnowflakeGrantsGrantsOf): void;
    resetGrantsOf(): void;
    get grantsOfInput(): DataSnowflakeGrantsGrantsOf | undefined;
    private _grantsOn;
    get grantsOn(): DataSnowflakeGrantsGrantsOnOutputReference;
    putGrantsOn(value: DataSnowflakeGrantsGrantsOn): void;
    resetGrantsOn(): void;
    get grantsOnInput(): DataSnowflakeGrantsGrantsOn | undefined;
    private _grantsTo;
    get grantsTo(): DataSnowflakeGrantsGrantsToOutputReference;
    putGrantsTo(value: DataSnowflakeGrantsGrantsTo): void;
    resetGrantsTo(): void;
    get grantsToInput(): DataSnowflakeGrantsGrantsTo | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
