/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DynamicTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#comment DynamicTable#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#database DynamicTable#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#id DynamicTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Initialize trigger for the dynamic table. Can only be set on creation. Available options are ON_CREATE and ON_SCHEDULE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#initialize DynamicTable#initialize}
    */
    readonly initialize?: string;
    /**
    * Specifies the identifier (i.e. name) for the dynamic table; must be unique for the schema in which the dynamic table is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#name DynamicTable#name}
    */
    readonly name: string;
    /**
    * Specifies whether to replace the dynamic table if it already exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#or_replace DynamicTable#or_replace}
    */
    readonly orReplace?: boolean | cdktf.IResolvable;
    /**
    * Specifies the query to use to populate the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#query DynamicTable#query}
    */
    readonly query: string;
    /**
    * INCREMENTAL to use incremental refreshes, FULL to recompute the whole table on every refresh, or AUTO to let Snowflake decide.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#refresh_mode DynamicTable#refresh_mode}
    */
    readonly refreshMode?: string;
    /**
    * The schema in which to create the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#schema DynamicTable#schema}
    */
    readonly schema: string;
    /**
    * The warehouse in which to create the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#warehouse DynamicTable#warehouse}
    */
    readonly warehouse: string;
    /**
    * target_lag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#target_lag DynamicTable#target_lag}
    */
    readonly targetLag: DynamicTableTargetLag;
}
export interface DynamicTableTargetLag {
    /**
    * Specifies whether the target lag time is downstream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#downstream DynamicTable#downstream}
    */
    readonly downstream?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum target lag time for the dynamic table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#maximum_duration DynamicTable#maximum_duration}
    */
    readonly maximumDuration?: string;
}
export declare function dynamicTableTargetLagToTerraform(struct?: DynamicTableTargetLagOutputReference | DynamicTableTargetLag): any;
export declare function dynamicTableTargetLagToHclTerraform(struct?: DynamicTableTargetLagOutputReference | DynamicTableTargetLag): any;
export declare class DynamicTableTargetLagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DynamicTableTargetLag | undefined;
    set internalValue(value: DynamicTableTargetLag | undefined);
    private _downstream?;
    get downstream(): boolean | cdktf.IResolvable;
    set downstream(value: boolean | cdktf.IResolvable);
    resetDownstream(): void;
    get downstreamInput(): boolean | cdktf.IResolvable | undefined;
    private _maximumDuration?;
    get maximumDuration(): string;
    set maximumDuration(value: string);
    resetMaximumDuration(): void;
    get maximumDurationInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table snowflake_dynamic_table}
*/
export declare class DynamicTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_dynamic_table";
    /**
    * Generates CDKTF code for importing a DynamicTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DynamicTable to import
    * @param importFromId The id of the existing DynamicTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DynamicTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/dynamic_table snowflake_dynamic_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DynamicTableConfig
    */
    constructor(scope: Construct, id: string, config: DynamicTableConfig);
    get automaticClustering(): cdktf.IResolvable;
    get bytes(): number;
    get clusterBy(): string;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get createdOn(): string;
    get dataTimestamp(): string;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _initialize?;
    get initialize(): string;
    set initialize(value: string);
    resetInitialize(): void;
    get initializeInput(): string | undefined;
    get isClone(): cdktf.IResolvable;
    get isReplica(): cdktf.IResolvable;
    get lastSuspendedOn(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _orReplace?;
    get orReplace(): boolean | cdktf.IResolvable;
    set orReplace(value: boolean | cdktf.IResolvable);
    resetOrReplace(): void;
    get orReplaceInput(): boolean | cdktf.IResolvable | undefined;
    get owner(): string;
    private _query?;
    get query(): string;
    set query(value: string);
    get queryInput(): string | undefined;
    private _refreshMode?;
    get refreshMode(): string;
    set refreshMode(value: string);
    resetRefreshMode(): void;
    get refreshModeInput(): string | undefined;
    get refreshModeReason(): string;
    get rows(): number;
    get schedulingState(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _warehouse?;
    get warehouse(): string;
    set warehouse(value: string);
    get warehouseInput(): string | undefined;
    private _targetLag;
    get targetLag(): DynamicTableTargetLagOutputReference;
    putTargetLag(value: DynamicTableTargetLag): void;
    get targetLagInput(): DynamicTableTargetLag | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
