/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalTableConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether to automatically refresh the external table metadata once, immediately after the external table is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#auto_refresh ExternalTable#auto_refresh}
    */
    readonly autoRefresh?: boolean | cdktf.IResolvable;
    /**
    * Specifies the aws sns topic for the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#aws_sns_topic ExternalTable#aws_sns_topic}
    */
    readonly awsSnsTopic?: string;
    /**
    * Specifies a comment for the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#comment ExternalTable#comment}
    */
    readonly comment?: string;
    /**
    * Specifies to retain the access permissions from the original table when an external table is recreated using the CREATE OR REPLACE TABLE variant
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#copy_grants ExternalTable#copy_grants}
    */
    readonly copyGrants?: boolean | cdktf.IResolvable;
    /**
    * The database in which to create the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#database ExternalTable#database}
    */
    readonly database: string;
    /**
    * Specifies the file format for the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#file_format ExternalTable#file_format}
    */
    readonly fileFormat: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#id ExternalTable#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies a location for the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#location ExternalTable#location}
    */
    readonly location: string;
    /**
    * Specifies the identifier for the external table; must be unique for the database and schema in which the externalTable is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#name ExternalTable#name}
    */
    readonly name: string;
    /**
    * Specifies any partition columns to evaluate for the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#partition_by ExternalTable#partition_by}
    */
    readonly partitionBy?: string[];
    /**
    * Specifies the file names and/or paths on the external stage to match.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#pattern ExternalTable#pattern}
    */
    readonly pattern?: string;
    /**
    * Specifies weather to refresh when an external table is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#refresh_on_create ExternalTable#refresh_on_create}
    */
    readonly refreshOnCreate?: boolean | cdktf.IResolvable;
    /**
    * The schema in which to create the external table.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#schema ExternalTable#schema}
    */
    readonly schema: string;
    /**
    * Identifies the external table table type. For now, only "delta" for Delta Lake table format is supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#table_format ExternalTable#table_format}
    */
    readonly tableFormat?: string;
    /**
    * column block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#column ExternalTable#column}
    */
    readonly column: ExternalTableColumn[] | cdktf.IResolvable;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#tag ExternalTable#tag}
    */
    readonly tag?: ExternalTableTag[] | cdktf.IResolvable;
}
export interface ExternalTableColumn {
    /**
    * String that specifies the expression for the column. When queried, the column returns results derived from this expression.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#as ExternalTable#as}
    */
    readonly as: string;
    /**
    * Column name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#name ExternalTable#name}
    */
    readonly name: string;
    /**
    * Column type, e.g. VARIANT
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#type ExternalTable#type}
    */
    readonly type: string;
}
export declare function externalTableColumnToTerraform(struct?: ExternalTableColumn | cdktf.IResolvable): any;
export declare function externalTableColumnToHclTerraform(struct?: ExternalTableColumn | cdktf.IResolvable): any;
export declare class ExternalTableColumnOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalTableColumn | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalTableColumn | cdktf.IResolvable | undefined);
    private _as?;
    get as(): string;
    set as(value: string);
    get asInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ExternalTableColumnList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalTableColumn[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalTableColumnOutputReference;
}
export interface ExternalTableTag {
    /**
    * Name of the database that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#database ExternalTable#database}
    */
    readonly database?: string;
    /**
    * Tag name, e.g. department.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#name ExternalTable#name}
    */
    readonly name: string;
    /**
    * Name of the schema that the tag was created in.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#schema ExternalTable#schema}
    */
    readonly schema?: string;
    /**
    * Tag value, e.g. marketing_info.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#value ExternalTable#value}
    */
    readonly value: string;
}
export declare function externalTableTagToTerraform(struct?: ExternalTableTag | cdktf.IResolvable): any;
export declare function externalTableTagToHclTerraform(struct?: ExternalTableTag | cdktf.IResolvable): any;
export declare class ExternalTableTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalTableTag | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalTableTag | cdktf.IResolvable | undefined);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ExternalTableTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalTableTag[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalTableTagOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table snowflake_external_table}
*/
export declare class ExternalTable extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_external_table";
    /**
    * Generates CDKTF code for importing a ExternalTable resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalTable to import
    * @param importFromId The id of the existing ExternalTable that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalTable to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_table snowflake_external_table} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalTableConfig
    */
    constructor(scope: Construct, id: string, config: ExternalTableConfig);
    private _autoRefresh?;
    get autoRefresh(): boolean | cdktf.IResolvable;
    set autoRefresh(value: boolean | cdktf.IResolvable);
    resetAutoRefresh(): void;
    get autoRefreshInput(): boolean | cdktf.IResolvable | undefined;
    private _awsSnsTopic?;
    get awsSnsTopic(): string;
    set awsSnsTopic(value: string);
    resetAwsSnsTopic(): void;
    get awsSnsTopicInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _copyGrants?;
    get copyGrants(): boolean | cdktf.IResolvable;
    set copyGrants(value: boolean | cdktf.IResolvable);
    resetCopyGrants(): void;
    get copyGrantsInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _fileFormat?;
    get fileFormat(): string;
    set fileFormat(value: string);
    get fileFormatInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get owner(): string;
    private _partitionBy?;
    get partitionBy(): string[];
    set partitionBy(value: string[]);
    resetPartitionBy(): void;
    get partitionByInput(): string[] | undefined;
    private _pattern?;
    get pattern(): string;
    set pattern(value: string);
    resetPattern(): void;
    get patternInput(): string | undefined;
    private _refreshOnCreate?;
    get refreshOnCreate(): boolean | cdktf.IResolvable;
    set refreshOnCreate(value: boolean | cdktf.IResolvable);
    resetRefreshOnCreate(): void;
    get refreshOnCreateInput(): boolean | cdktf.IResolvable | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _tableFormat?;
    get tableFormat(): string;
    set tableFormat(value: string);
    resetTableFormat(): void;
    get tableFormatInput(): string | undefined;
    private _column;
    get column(): ExternalTableColumnList;
    putColumn(value: ExternalTableColumn[] | cdktf.IResolvable): void;
    get columnInput(): cdktf.IResolvable | ExternalTableColumn[] | undefined;
    private _tag;
    get tag(): ExternalTableTagList;
    putTag(value: ExternalTableTag[] | cdktf.IResolvable): void;
    resetTag(): void;
    get tagInput(): cdktf.IResolvable | ExternalTableTag[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
