/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ExternalVolumeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies whether write operations are allowed for the external volume; must be set to TRUE for Iceberg tables that use Snowflake as the catalog. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#allow_writes ExternalVolume#allow_writes}
    */
    readonly allowWrites?: string;
    /**
    * Specifies a comment for the external volume.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#comment ExternalVolume#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#id ExternalVolume#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the external volume; must be unique for your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#name ExternalVolume#name}
    */
    readonly name: string;
    /**
    * storage_location block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#storage_location ExternalVolume#storage_location}
    */
    readonly storageLocation: ExternalVolumeStorageLocation[] | cdktf.IResolvable;
}
export interface ExternalVolumeDescribeOutput {
}
export declare function externalVolumeDescribeOutputToTerraform(struct?: ExternalVolumeDescribeOutput): any;
export declare function externalVolumeDescribeOutputToHclTerraform(struct?: ExternalVolumeDescribeOutput): any;
export declare class ExternalVolumeDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeDescribeOutput | undefined;
    set internalValue(value: ExternalVolumeDescribeOutput | undefined);
    get default(): string;
    get name(): string;
    get parent(): string;
    get type(): string;
    get value(): string;
}
export declare class ExternalVolumeDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeDescribeOutputOutputReference;
}
export interface ExternalVolumeShowOutput {
}
export declare function externalVolumeShowOutputToTerraform(struct?: ExternalVolumeShowOutput): any;
export declare function externalVolumeShowOutputToHclTerraform(struct?: ExternalVolumeShowOutput): any;
export declare class ExternalVolumeShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeShowOutput | undefined;
    set internalValue(value: ExternalVolumeShowOutput | undefined);
    get allowWrites(): cdktf.IResolvable;
    get comment(): string;
    get name(): string;
}
export declare class ExternalVolumeShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeShowOutputOutputReference;
}
export interface ExternalVolumeStorageLocation {
    /**
    * Specifies the ID for your Office 365 tenant that the allowed and blocked storage accounts belong to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#azure_tenant_id ExternalVolume#azure_tenant_id}
    */
    readonly azureTenantId?: string;
    /**
    * Specifies the ID for the KMS-managed key used to encrypt files.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#encryption_kms_key_id ExternalVolume#encryption_kms_key_id}
    */
    readonly encryptionKmsKeyId?: string;
    /**
    * Specifies the encryption type used.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#encryption_type ExternalVolume#encryption_type}
    */
    readonly encryptionType?: string;
    /**
    * Specifies the case-sensitive Amazon Resource Name (ARN) of the AWS identity and access management (IAM) role that grants privileges on the S3 bucket containing your data files.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#storage_aws_role_arn ExternalVolume#storage_aws_role_arn}
    */
    readonly storageAwsRoleArn?: string;
    /**
    * Specifies the base URL for your cloud storage location.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#storage_base_url ExternalVolume#storage_base_url}
    */
    readonly storageBaseUrl: string;
    /**
    * Name of the storage location. Must be unique for the external volume. Do not use the name `terraform_provider_sentinel_storage_location` - this is reserved for the provider for performing update operations. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#storage_location_name ExternalVolume#storage_location_name}
    */
    readonly storageLocationName: string;
    /**
    * Specifies the cloud storage provider that stores your data files. Valid values are (case-insensitive): `GCS` | `AZURE` | `S3` | `S3GOV`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#storage_provider ExternalVolume#storage_provider}
    */
    readonly storageProvider: string;
}
export declare function externalVolumeStorageLocationToTerraform(struct?: ExternalVolumeStorageLocation | cdktf.IResolvable): any;
export declare function externalVolumeStorageLocationToHclTerraform(struct?: ExternalVolumeStorageLocation | cdktf.IResolvable): any;
export declare class ExternalVolumeStorageLocationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ExternalVolumeStorageLocation | cdktf.IResolvable | undefined;
    set internalValue(value: ExternalVolumeStorageLocation | cdktf.IResolvable | undefined);
    private _azureTenantId?;
    get azureTenantId(): string;
    set azureTenantId(value: string);
    resetAzureTenantId(): void;
    get azureTenantIdInput(): string | undefined;
    private _encryptionKmsKeyId?;
    get encryptionKmsKeyId(): string;
    set encryptionKmsKeyId(value: string);
    resetEncryptionKmsKeyId(): void;
    get encryptionKmsKeyIdInput(): string | undefined;
    private _encryptionType?;
    get encryptionType(): string;
    set encryptionType(value: string);
    resetEncryptionType(): void;
    get encryptionTypeInput(): string | undefined;
    get storageAwsExternalId(): string;
    private _storageAwsRoleArn?;
    get storageAwsRoleArn(): string;
    set storageAwsRoleArn(value: string);
    resetStorageAwsRoleArn(): void;
    get storageAwsRoleArnInput(): string | undefined;
    private _storageBaseUrl?;
    get storageBaseUrl(): string;
    set storageBaseUrl(value: string);
    get storageBaseUrlInput(): string | undefined;
    private _storageLocationName?;
    get storageLocationName(): string;
    set storageLocationName(value: string);
    get storageLocationNameInput(): string | undefined;
    private _storageProvider?;
    get storageProvider(): string;
    set storageProvider(value: string);
    get storageProviderInput(): string | undefined;
}
export declare class ExternalVolumeStorageLocationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ExternalVolumeStorageLocation[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ExternalVolumeStorageLocationOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume snowflake_external_volume}
*/
export declare class ExternalVolume extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_external_volume";
    /**
    * Generates CDKTF code for importing a ExternalVolume resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ExternalVolume to import
    * @param importFromId The id of the existing ExternalVolume that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ExternalVolume to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/external_volume snowflake_external_volume} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ExternalVolumeConfig
    */
    constructor(scope: Construct, id: string, config: ExternalVolumeConfig);
    private _allowWrites?;
    get allowWrites(): string;
    set allowWrites(value: string);
    resetAllowWrites(): void;
    get allowWritesInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ExternalVolumeDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): ExternalVolumeShowOutputList;
    private _storageLocation;
    get storageLocation(): ExternalVolumeStorageLocationList;
    putStorageLocation(value: ExternalVolumeStorageLocation[] | cdktf.IResolvable): void;
    get storageLocationInput(): cdktf.IResolvable | ExternalVolumeStorageLocation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
