/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies one or more IPv4 addresses (CIDR notation) that are allowed access to your Snowflake account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#allowed_ip_list NetworkPolicy#allowed_ip_list}
    */
    readonly allowedIpList?: string[];
    /**
    * Specifies a list of fully qualified network rules that contain the network identifiers that are allowed access to Snowflake.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#allowed_network_rule_list NetworkPolicy#allowed_network_rule_list}
    */
    readonly allowedNetworkRuleList?: string[];
    /**
    * Specifies one or more IPv4 addresses (CIDR notation) that are denied access to your Snowflake account. **Do not** add `0.0.0.0/0` to `blocked_ip_list`, in order to block all IP addresses except a select list, you only need to add IP addresses to `allowed_ip_list`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#blocked_ip_list NetworkPolicy#blocked_ip_list}
    */
    readonly blockedIpList?: string[];
    /**
    * Specifies a list of fully qualified network rules that contain the network identifiers that are denied access to Snowflake.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#blocked_network_rule_list NetworkPolicy#blocked_network_rule_list}
    */
    readonly blockedNetworkRuleList?: string[];
    /**
    * Specifies a comment for the network policy.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#comment NetworkPolicy#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#id NetworkPolicy#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier for the network policy; must be unique for the account in which the network policy is created. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#name NetworkPolicy#name}
    */
    readonly name: string;
}
export interface NetworkPolicyDescribeOutput {
}
export declare function networkPolicyDescribeOutputToTerraform(struct?: NetworkPolicyDescribeOutput): any;
export declare function networkPolicyDescribeOutputToHclTerraform(struct?: NetworkPolicyDescribeOutput): any;
export declare class NetworkPolicyDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkPolicyDescribeOutput | undefined;
    set internalValue(value: NetworkPolicyDescribeOutput | undefined);
    get allowedIpList(): string;
    get allowedNetworkRuleList(): string;
    get blockedIpList(): string;
    get blockedNetworkRuleList(): string;
}
export declare class NetworkPolicyDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkPolicyDescribeOutputOutputReference;
}
export interface NetworkPolicyShowOutput {
}
export declare function networkPolicyShowOutputToTerraform(struct?: NetworkPolicyShowOutput): any;
export declare function networkPolicyShowOutputToHclTerraform(struct?: NetworkPolicyShowOutput): any;
export declare class NetworkPolicyShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): NetworkPolicyShowOutput | undefined;
    set internalValue(value: NetworkPolicyShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get entriesInAllowedIpList(): number;
    get entriesInAllowedNetworkRules(): number;
    get entriesInBlockedIpList(): number;
    get entriesInBlockedNetworkRules(): number;
    get name(): string;
}
export declare class NetworkPolicyShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): NetworkPolicyShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy snowflake_network_policy}
*/
export declare class NetworkPolicy extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_network_policy";
    /**
    * Generates CDKTF code for importing a NetworkPolicy resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the NetworkPolicy to import
    * @param importFromId The id of the existing NetworkPolicy that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the NetworkPolicy to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/network_policy snowflake_network_policy} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkPolicyConfig
    */
    constructor(scope: Construct, id: string, config: NetworkPolicyConfig);
    private _allowedIpList?;
    get allowedIpList(): string[];
    set allowedIpList(value: string[]);
    resetAllowedIpList(): void;
    get allowedIpListInput(): string[] | undefined;
    private _allowedNetworkRuleList?;
    get allowedNetworkRuleList(): string[];
    set allowedNetworkRuleList(value: string[]);
    resetAllowedNetworkRuleList(): void;
    get allowedNetworkRuleListInput(): string[] | undefined;
    private _blockedIpList?;
    get blockedIpList(): string[];
    set blockedIpList(value: string[]);
    resetBlockedIpList(): void;
    get blockedIpListInput(): string[] | undefined;
    private _blockedNetworkRuleList?;
    get blockedNetworkRuleList(): string[];
    set blockedNetworkRuleList(value: string[]);
    resetBlockedNetworkRuleList(): void;
    get blockedNetworkRuleListInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): NetworkPolicyDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): NetworkPolicyShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
