/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#comment Procedure#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#database Procedure#database}
    */
    readonly database: string;
    /**
    * Sets execution context. Allowed values are CALLER and OWNER (consult a proper section in the [docs](https://docs.snowflake.com/en/sql-reference/sql/create-procedure#id1)). For more information see [caller's rights and owner's rights](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#execute_as Procedure#execute_as}
    */
    readonly executeAs?: string;
    /**
    * The handler method for Java / Python procedures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#handler Procedure#handler}
    */
    readonly handler?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#id Procedure#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Imports for Java / Python procedures. For Java this a list of jar files, for Python this is a list of Python files.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#imports Procedure#imports}
    */
    readonly imports?: string[];
    /**
    * Specifies the language of the stored procedure code.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#language Procedure#language}
    */
    readonly language?: string;
    /**
    * Specifies the identifier for the procedure; does not have to be unique for the schema in which the procedure is created. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#name Procedure#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#null_input_behavior Procedure#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * List of package imports to use for Java / Python procedures. For Java, package imports should be of the form: package_name:version_number, where package_name is snowflake_domain:package. For Python use it should be: ('numpy','pandas','xgboost==1.5.0').
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#packages Procedure#packages}
    */
    readonly packages?: string[];
    /**
    * Specifies the behavior of the function when returning results
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#return_behavior Procedure#return_behavior}
    */
    readonly returnBehavior?: string;
    /**
    * The return type of the procedure
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#return_type Procedure#return_type}
    */
    readonly returnType: string;
    /**
    * Required for Python procedures. Specifies Python runtime version.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#runtime_version Procedure#runtime_version}
    */
    readonly runtimeVersion?: string;
    /**
    * The schema in which to create the procedure. Don't use the | character.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#schema Procedure#schema}
    */
    readonly schema: string;
    /**
    * Specifies that the procedure is secure. For more information about secure procedures, see Protecting Sensitive Information with Secure UDFs and Stored Procedures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#secure Procedure#secure}
    */
    readonly secure?: boolean | cdktf.IResolvable;
    /**
    * Specifies the code used to create the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#statement Procedure#statement}
    */
    readonly statement: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#arguments Procedure#arguments}
    */
    readonly arguments?: ProcedureArguments[] | cdktf.IResolvable;
}
export interface ProcedureArguments {
    /**
    * The argument name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#name Procedure#name}
    */
    readonly name: string;
    /**
    * The argument type
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#type Procedure#type}
    */
    readonly type: string;
}
export declare function procedureArgumentsToTerraform(struct?: ProcedureArguments | cdktf.IResolvable): any;
export declare function procedureArgumentsToHclTerraform(struct?: ProcedureArguments | cdktf.IResolvable): any;
export declare class ProcedureArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureArguments | cdktf.IResolvable | undefined);
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export declare class ProcedureArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureArgumentsOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure snowflake_procedure}
*/
export declare class Procedure extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure";
    /**
    * Generates CDKTF code for importing a Procedure resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Procedure to import
    * @param importFromId The id of the existing Procedure that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Procedure to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/procedure snowflake_procedure} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _handler?;
    get handler(): string;
    set handler(value: string);
    resetHandler(): void;
    get handlerInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _imports?;
    get imports(): string[];
    set imports(value: string[]);
    resetImports(): void;
    get importsInput(): string[] | undefined;
    private _language?;
    get language(): string;
    set language(value: string);
    resetLanguage(): void;
    get languageInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _packages?;
    get packages(): string[];
    set packages(value: string[]);
    resetPackages(): void;
    get packagesInput(): string[] | undefined;
    private _returnBehavior?;
    get returnBehavior(): string;
    set returnBehavior(value: string);
    resetReturnBehavior(): void;
    get returnBehaviorInput(): string | undefined;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _runtimeVersion?;
    get runtimeVersion(): string;
    set runtimeVersion(value: string);
    resetRuntimeVersion(): void;
    get runtimeVersionInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _secure?;
    get secure(): boolean | cdktf.IResolvable;
    set secure(value: boolean | cdktf.IResolvable);
    resetSecure(): void;
    get secureInput(): boolean | cdktf.IResolvable | undefined;
    private _statement?;
    get statement(): string;
    set statement(value: string);
    get statementInput(): string | undefined;
    private _arguments;
    get arguments(): ProcedureArgumentsList;
    putArguments(value: ProcedureArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureArguments[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
