/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database parameter that specifies the default catalog to use for Iceberg tables. For more information, see [CATALOG](https://docs.snowflake.com/en/sql-reference/parameters#catalog).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#catalog Schema#catalog}
    */
    readonly catalog?: string;
    /**
    * Specifies a comment for the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#comment Schema#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the number of days for which Time Travel actions (CLONE and UNDROP) can be performed on the database, as well as specifying the default Time Travel retention time for all schemas created in the database. For more details, see [Understanding & Using Time Travel](https://docs.snowflake.com/en/user-guide/data-time-travel).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#data_retention_time_in_days Schema#data_retention_time_in_days}
    */
    readonly dataRetentionTimeInDays?: number;
    /**
    * The database in which to create the schema.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#database Schema#database}
    */
    readonly database: string;
    /**
    * Specifies a default collation specification for all schemas and tables added to the database. It can be overridden on schema or table level. For more information, see [collation specification](https://docs.snowflake.com/en/sql-reference/collation#label-collation-specification).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#default_ddl_collation Schema#default_ddl_collation}
    */
    readonly defaultDdlCollation?: string;
    /**
    * If true, enables stdout/stderr fast path logging for anonymous stored procedures.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#enable_console_output Schema#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * The database parameter that specifies the default external volume to use for Iceberg tables. For more information, see [EXTERNAL_VOLUME](https://docs.snowflake.com/en/sql-reference/parameters#external-volume).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#external_volume Schema#external_volume}
    */
    readonly externalVolume?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#id Schema#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the schema as transient. Transient schemas do not have a Fail-safe period so they do not incur additional storage costs once they leave Time Travel; however, this means they are also not protected by Fail-safe in the event of a data loss. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#is_transient Schema#is_transient}
    */
    readonly isTransient?: string;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Valid options are: [TRACE DEBUG INFO WARN ERROR FATAL OFF]. Messages at the specified level (and at more severe levels) are ingested. For more information, see [LOG_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#log_level Schema#log_level}
    */
    readonly logLevel?: string;
    /**
    * Object parameter that specifies the maximum number of days for which Snowflake can extend the data retention period for tables in the database to prevent streams on the tables from becoming stale. For a detailed description of this parameter, see [MAX_DATA_EXTENSION_TIME_IN_DAYS](https://docs.snowflake.com/en/sql-reference/parameters.html#label-max-data-extension-time-in-days).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#max_data_extension_time_in_days Schema#max_data_extension_time_in_days}
    */
    readonly maxDataExtensionTimeInDays?: number;
    /**
    * Specifies the identifier for the schema; must be unique for the database in which the schema is created. When the name is `PUBLIC`, during creation the provider checks if this schema has already been created and, in such case, `ALTER` is used to match the desired state.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#name Schema#name}
    */
    readonly name: string;
    /**
    * Specifies whether to pause a running pipe, primarily in preparation for transferring ownership of the pipe to a different role. For more information, check [PIPE_EXECUTION_PAUSED docs](https://docs.snowflake.com/en/sql-reference/parameters#pipe-execution-paused).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#pipe_execution_paused Schema#pipe_execution_paused}
    */
    readonly pipeExecutionPaused?: boolean | cdktf.IResolvable;
    /**
    * If true, the case of quoted identifiers is ignored. For more information, see [QUOTED_IDENTIFIERS_IGNORE_CASE](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#quoted_identifiers_ignore_case Schema#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to replace invalid UTF-8 characters with the Unicode replacement character (�) in query results for an Iceberg table. You can only set this parameter for tables that use an external Iceberg catalog. For more information, see [REPLACE_INVALID_CHARACTERS](https://docs.snowflake.com/en/sql-reference/parameters#replace-invalid-characters).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#replace_invalid_characters Schema#replace_invalid_characters}
    */
    readonly replaceInvalidCharacters?: boolean | cdktf.IResolvable;
    /**
    * The storage serialization policy for Iceberg tables that use Snowflake as the catalog. Valid options are: [COMPATIBLE OPTIMIZED]. COMPATIBLE: Snowflake performs encoding and compression of data files that ensures interoperability with third-party compute engines. OPTIMIZED: Snowflake performs encoding and compression of data files that ensures the best table performance within Snowflake. For more information, see [STORAGE_SERIALIZATION_POLICY](https://docs.snowflake.com/en/sql-reference/parameters#storage-serialization-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#storage_serialization_policy Schema#storage_serialization_policy}
    */
    readonly storageSerializationPolicy?: string;
    /**
    * How many times a task must fail in a row before it is automatically suspended. 0 disables auto-suspending. For more information, see [SUSPEND_TASK_AFTER_NUM_FAILURES](https://docs.snowflake.com/en/sql-reference/parameters#suspend-task-after-num-failures).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#suspend_task_after_num_failures Schema#suspend_task_after_num_failures}
    */
    readonly suspendTaskAfterNumFailures?: number;
    /**
    * Maximum automatic retries allowed for a user task. For more information, see [TASK_AUTO_RETRY_ATTEMPTS](https://docs.snowflake.com/en/sql-reference/parameters#task-auto-retry-attempts).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#task_auto_retry_attempts Schema#task_auto_retry_attempts}
    */
    readonly taskAutoRetryAttempts?: number;
    /**
    * Controls how trace events are ingested into the event table. Valid options are: [ALWAYS ON_EVENT OFF]. For information about levels, see [TRACE_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters.html#label-trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#trace_level Schema#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * The initial size of warehouse to use for managed warehouses in the absence of history. For more information, see [USER_TASK_MANAGED_INITIAL_WAREHOUSE_SIZE](https://docs.snowflake.com/en/sql-reference/parameters#user-task-managed-initial-warehouse-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#user_task_managed_initial_warehouse_size Schema#user_task_managed_initial_warehouse_size}
    */
    readonly userTaskManagedInitialWarehouseSize?: string;
    /**
    * Minimum amount of time between Triggered Task executions in seconds.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#user_task_minimum_trigger_interval_in_seconds Schema#user_task_minimum_trigger_interval_in_seconds}
    */
    readonly userTaskMinimumTriggerIntervalInSeconds?: number;
    /**
    * User task execution timeout in milliseconds. For more information, see [USER_TASK_TIMEOUT_MS](https://docs.snowflake.com/en/sql-reference/parameters#user-task-timeout-ms).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#user_task_timeout_ms Schema#user_task_timeout_ms}
    */
    readonly userTaskTimeoutMs?: number;
    /**
    * Specifies a managed schema. Managed access schemas centralize privilege management with the schema owner. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#with_managed_access Schema#with_managed_access}
    */
    readonly withManagedAccess?: string;
}
export interface SchemaDescribeOutput {
}
export declare function schemaDescribeOutputToTerraform(struct?: SchemaDescribeOutput): any;
export declare function schemaDescribeOutputToHclTerraform(struct?: SchemaDescribeOutput): any;
export declare class SchemaDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaDescribeOutput | undefined;
    set internalValue(value: SchemaDescribeOutput | undefined);
    get createdOn(): string;
    get kind(): string;
    get name(): string;
}
export declare class SchemaDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaDescribeOutputOutputReference;
}
export interface SchemaParametersCatalog {
}
export declare function schemaParametersCatalogToTerraform(struct?: SchemaParametersCatalog): any;
export declare function schemaParametersCatalogToHclTerraform(struct?: SchemaParametersCatalog): any;
export declare class SchemaParametersCatalogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersCatalog | undefined;
    set internalValue(value: SchemaParametersCatalog | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersCatalogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersCatalogOutputReference;
}
export interface SchemaParametersDataRetentionTimeInDays {
}
export declare function schemaParametersDataRetentionTimeInDaysToTerraform(struct?: SchemaParametersDataRetentionTimeInDays): any;
export declare function schemaParametersDataRetentionTimeInDaysToHclTerraform(struct?: SchemaParametersDataRetentionTimeInDays): any;
export declare class SchemaParametersDataRetentionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersDataRetentionTimeInDays | undefined;
    set internalValue(value: SchemaParametersDataRetentionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersDataRetentionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersDataRetentionTimeInDaysOutputReference;
}
export interface SchemaParametersDefaultDdlCollation {
}
export declare function schemaParametersDefaultDdlCollationToTerraform(struct?: SchemaParametersDefaultDdlCollation): any;
export declare function schemaParametersDefaultDdlCollationToHclTerraform(struct?: SchemaParametersDefaultDdlCollation): any;
export declare class SchemaParametersDefaultDdlCollationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersDefaultDdlCollation | undefined;
    set internalValue(value: SchemaParametersDefaultDdlCollation | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersDefaultDdlCollationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersDefaultDdlCollationOutputReference;
}
export interface SchemaParametersEnableConsoleOutput {
}
export declare function schemaParametersEnableConsoleOutputToTerraform(struct?: SchemaParametersEnableConsoleOutput): any;
export declare function schemaParametersEnableConsoleOutputToHclTerraform(struct?: SchemaParametersEnableConsoleOutput): any;
export declare class SchemaParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersEnableConsoleOutput | undefined;
    set internalValue(value: SchemaParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersEnableConsoleOutputOutputReference;
}
export interface SchemaParametersExternalVolume {
}
export declare function schemaParametersExternalVolumeToTerraform(struct?: SchemaParametersExternalVolume): any;
export declare function schemaParametersExternalVolumeToHclTerraform(struct?: SchemaParametersExternalVolume): any;
export declare class SchemaParametersExternalVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersExternalVolume | undefined;
    set internalValue(value: SchemaParametersExternalVolume | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersExternalVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersExternalVolumeOutputReference;
}
export interface SchemaParametersLogLevel {
}
export declare function schemaParametersLogLevelToTerraform(struct?: SchemaParametersLogLevel): any;
export declare function schemaParametersLogLevelToHclTerraform(struct?: SchemaParametersLogLevel): any;
export declare class SchemaParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersLogLevel | undefined;
    set internalValue(value: SchemaParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersLogLevelOutputReference;
}
export interface SchemaParametersMaxDataExtensionTimeInDays {
}
export declare function schemaParametersMaxDataExtensionTimeInDaysToTerraform(struct?: SchemaParametersMaxDataExtensionTimeInDays): any;
export declare function schemaParametersMaxDataExtensionTimeInDaysToHclTerraform(struct?: SchemaParametersMaxDataExtensionTimeInDays): any;
export declare class SchemaParametersMaxDataExtensionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersMaxDataExtensionTimeInDays | undefined;
    set internalValue(value: SchemaParametersMaxDataExtensionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersMaxDataExtensionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersMaxDataExtensionTimeInDaysOutputReference;
}
export interface SchemaParametersPipeExecutionPaused {
}
export declare function schemaParametersPipeExecutionPausedToTerraform(struct?: SchemaParametersPipeExecutionPaused): any;
export declare function schemaParametersPipeExecutionPausedToHclTerraform(struct?: SchemaParametersPipeExecutionPaused): any;
export declare class SchemaParametersPipeExecutionPausedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersPipeExecutionPaused | undefined;
    set internalValue(value: SchemaParametersPipeExecutionPaused | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersPipeExecutionPausedList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersPipeExecutionPausedOutputReference;
}
export interface SchemaParametersQuotedIdentifiersIgnoreCase {
}
export declare function schemaParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: SchemaParametersQuotedIdentifiersIgnoreCase): any;
export declare function schemaParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: SchemaParametersQuotedIdentifiersIgnoreCase): any;
export declare class SchemaParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: SchemaParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface SchemaParametersReplaceInvalidCharacters {
}
export declare function schemaParametersReplaceInvalidCharactersToTerraform(struct?: SchemaParametersReplaceInvalidCharacters): any;
export declare function schemaParametersReplaceInvalidCharactersToHclTerraform(struct?: SchemaParametersReplaceInvalidCharacters): any;
export declare class SchemaParametersReplaceInvalidCharactersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersReplaceInvalidCharacters | undefined;
    set internalValue(value: SchemaParametersReplaceInvalidCharacters | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersReplaceInvalidCharactersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersReplaceInvalidCharactersOutputReference;
}
export interface SchemaParametersStorageSerializationPolicy {
}
export declare function schemaParametersStorageSerializationPolicyToTerraform(struct?: SchemaParametersStorageSerializationPolicy): any;
export declare function schemaParametersStorageSerializationPolicyToHclTerraform(struct?: SchemaParametersStorageSerializationPolicy): any;
export declare class SchemaParametersStorageSerializationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersStorageSerializationPolicy | undefined;
    set internalValue(value: SchemaParametersStorageSerializationPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersStorageSerializationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersStorageSerializationPolicyOutputReference;
}
export interface SchemaParametersSuspendTaskAfterNumFailures {
}
export declare function schemaParametersSuspendTaskAfterNumFailuresToTerraform(struct?: SchemaParametersSuspendTaskAfterNumFailures): any;
export declare function schemaParametersSuspendTaskAfterNumFailuresToHclTerraform(struct?: SchemaParametersSuspendTaskAfterNumFailures): any;
export declare class SchemaParametersSuspendTaskAfterNumFailuresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersSuspendTaskAfterNumFailures | undefined;
    set internalValue(value: SchemaParametersSuspendTaskAfterNumFailures | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersSuspendTaskAfterNumFailuresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersSuspendTaskAfterNumFailuresOutputReference;
}
export interface SchemaParametersTaskAutoRetryAttempts {
}
export declare function schemaParametersTaskAutoRetryAttemptsToTerraform(struct?: SchemaParametersTaskAutoRetryAttempts): any;
export declare function schemaParametersTaskAutoRetryAttemptsToHclTerraform(struct?: SchemaParametersTaskAutoRetryAttempts): any;
export declare class SchemaParametersTaskAutoRetryAttemptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersTaskAutoRetryAttempts | undefined;
    set internalValue(value: SchemaParametersTaskAutoRetryAttempts | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersTaskAutoRetryAttemptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersTaskAutoRetryAttemptsOutputReference;
}
export interface SchemaParametersTraceLevel {
}
export declare function schemaParametersTraceLevelToTerraform(struct?: SchemaParametersTraceLevel): any;
export declare function schemaParametersTraceLevelToHclTerraform(struct?: SchemaParametersTraceLevel): any;
export declare class SchemaParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersTraceLevel | undefined;
    set internalValue(value: SchemaParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersTraceLevelOutputReference;
}
export interface SchemaParametersUserTaskManagedInitialWarehouseSize {
}
export declare function schemaParametersUserTaskManagedInitialWarehouseSizeToTerraform(struct?: SchemaParametersUserTaskManagedInitialWarehouseSize): any;
export declare function schemaParametersUserTaskManagedInitialWarehouseSizeToHclTerraform(struct?: SchemaParametersUserTaskManagedInitialWarehouseSize): any;
export declare class SchemaParametersUserTaskManagedInitialWarehouseSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersUserTaskManagedInitialWarehouseSize | undefined;
    set internalValue(value: SchemaParametersUserTaskManagedInitialWarehouseSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersUserTaskManagedInitialWarehouseSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersUserTaskManagedInitialWarehouseSizeOutputReference;
}
export interface SchemaParametersUserTaskMinimumTriggerIntervalInSeconds {
}
export declare function schemaParametersUserTaskMinimumTriggerIntervalInSecondsToTerraform(struct?: SchemaParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare function schemaParametersUserTaskMinimumTriggerIntervalInSecondsToHclTerraform(struct?: SchemaParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare class SchemaParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersUserTaskMinimumTriggerIntervalInSeconds | undefined;
    set internalValue(value: SchemaParametersUserTaskMinimumTriggerIntervalInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersUserTaskMinimumTriggerIntervalInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference;
}
export interface SchemaParametersUserTaskTimeoutMs {
}
export declare function schemaParametersUserTaskTimeoutMsToTerraform(struct?: SchemaParametersUserTaskTimeoutMs): any;
export declare function schemaParametersUserTaskTimeoutMsToHclTerraform(struct?: SchemaParametersUserTaskTimeoutMs): any;
export declare class SchemaParametersUserTaskTimeoutMsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParametersUserTaskTimeoutMs | undefined;
    set internalValue(value: SchemaParametersUserTaskTimeoutMs | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class SchemaParametersUserTaskTimeoutMsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersUserTaskTimeoutMsOutputReference;
}
export interface SchemaParameters {
}
export declare function schemaParametersToTerraform(struct?: SchemaParameters): any;
export declare function schemaParametersToHclTerraform(struct?: SchemaParameters): any;
export declare class SchemaParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaParameters | undefined;
    set internalValue(value: SchemaParameters | undefined);
    private _catalog;
    get catalog(): SchemaParametersCatalogList;
    private _dataRetentionTimeInDays;
    get dataRetentionTimeInDays(): SchemaParametersDataRetentionTimeInDaysList;
    private _defaultDdlCollation;
    get defaultDdlCollation(): SchemaParametersDefaultDdlCollationList;
    private _enableConsoleOutput;
    get enableConsoleOutput(): SchemaParametersEnableConsoleOutputList;
    private _externalVolume;
    get externalVolume(): SchemaParametersExternalVolumeList;
    private _logLevel;
    get logLevel(): SchemaParametersLogLevelList;
    private _maxDataExtensionTimeInDays;
    get maxDataExtensionTimeInDays(): SchemaParametersMaxDataExtensionTimeInDaysList;
    private _pipeExecutionPaused;
    get pipeExecutionPaused(): SchemaParametersPipeExecutionPausedList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): SchemaParametersQuotedIdentifiersIgnoreCaseList;
    private _replaceInvalidCharacters;
    get replaceInvalidCharacters(): SchemaParametersReplaceInvalidCharactersList;
    private _storageSerializationPolicy;
    get storageSerializationPolicy(): SchemaParametersStorageSerializationPolicyList;
    private _suspendTaskAfterNumFailures;
    get suspendTaskAfterNumFailures(): SchemaParametersSuspendTaskAfterNumFailuresList;
    private _taskAutoRetryAttempts;
    get taskAutoRetryAttempts(): SchemaParametersTaskAutoRetryAttemptsList;
    private _traceLevel;
    get traceLevel(): SchemaParametersTraceLevelList;
    private _userTaskManagedInitialWarehouseSize;
    get userTaskManagedInitialWarehouseSize(): SchemaParametersUserTaskManagedInitialWarehouseSizeList;
    private _userTaskMinimumTriggerIntervalInSeconds;
    get userTaskMinimumTriggerIntervalInSeconds(): SchemaParametersUserTaskMinimumTriggerIntervalInSecondsList;
    private _userTaskTimeoutMs;
    get userTaskTimeoutMs(): SchemaParametersUserTaskTimeoutMsList;
}
export declare class SchemaParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaParametersOutputReference;
}
export interface SchemaShowOutput {
}
export declare function schemaShowOutputToTerraform(struct?: SchemaShowOutput): any;
export declare function schemaShowOutputToHclTerraform(struct?: SchemaShowOutput): any;
export declare class SchemaShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SchemaShowOutput | undefined;
    set internalValue(value: SchemaShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get droppedOn(): string;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get name(): string;
    get options(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get retentionTime(): string;
}
export declare class SchemaShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SchemaShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema snowflake_schema}
*/
export declare class Schema extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_schema";
    /**
    * Generates CDKTF code for importing a Schema resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Schema to import
    * @param importFromId The id of the existing Schema that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Schema to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/schema snowflake_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchemaConfig
    */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _catalog?;
    get catalog(): string;
    set catalog(value: string);
    resetCatalog(): void;
    get catalogInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dataRetentionTimeInDays?;
    get dataRetentionTimeInDays(): number;
    set dataRetentionTimeInDays(value: number);
    resetDataRetentionTimeInDays(): void;
    get dataRetentionTimeInDaysInput(): number | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _defaultDdlCollation?;
    get defaultDdlCollation(): string;
    set defaultDdlCollation(value: string);
    resetDefaultDdlCollation(): void;
    get defaultDdlCollationInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): SchemaDescribeOutputList;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _externalVolume?;
    get externalVolume(): string;
    set externalVolume(value: string);
    resetExternalVolume(): void;
    get externalVolumeInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isTransient?;
    get isTransient(): string;
    set isTransient(value: string);
    resetIsTransient(): void;
    get isTransientInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _maxDataExtensionTimeInDays?;
    get maxDataExtensionTimeInDays(): number;
    set maxDataExtensionTimeInDays(value: number);
    resetMaxDataExtensionTimeInDays(): void;
    get maxDataExtensionTimeInDaysInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _parameters;
    get parameters(): SchemaParametersList;
    private _pipeExecutionPaused?;
    get pipeExecutionPaused(): boolean | cdktf.IResolvable;
    set pipeExecutionPaused(value: boolean | cdktf.IResolvable);
    resetPipeExecutionPaused(): void;
    get pipeExecutionPausedInput(): boolean | cdktf.IResolvable | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _replaceInvalidCharacters?;
    get replaceInvalidCharacters(): boolean | cdktf.IResolvable;
    set replaceInvalidCharacters(value: boolean | cdktf.IResolvable);
    resetReplaceInvalidCharacters(): void;
    get replaceInvalidCharactersInput(): boolean | cdktf.IResolvable | undefined;
    private _showOutput;
    get showOutput(): SchemaShowOutputList;
    private _storageSerializationPolicy?;
    get storageSerializationPolicy(): string;
    set storageSerializationPolicy(value: string);
    resetStorageSerializationPolicy(): void;
    get storageSerializationPolicyInput(): string | undefined;
    private _suspendTaskAfterNumFailures?;
    get suspendTaskAfterNumFailures(): number;
    set suspendTaskAfterNumFailures(value: number);
    resetSuspendTaskAfterNumFailures(): void;
    get suspendTaskAfterNumFailuresInput(): number | undefined;
    private _taskAutoRetryAttempts?;
    get taskAutoRetryAttempts(): number;
    set taskAutoRetryAttempts(value: number);
    resetTaskAutoRetryAttempts(): void;
    get taskAutoRetryAttemptsInput(): number | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _userTaskManagedInitialWarehouseSize?;
    get userTaskManagedInitialWarehouseSize(): string;
    set userTaskManagedInitialWarehouseSize(value: string);
    resetUserTaskManagedInitialWarehouseSize(): void;
    get userTaskManagedInitialWarehouseSizeInput(): string | undefined;
    private _userTaskMinimumTriggerIntervalInSeconds?;
    get userTaskMinimumTriggerIntervalInSeconds(): number;
    set userTaskMinimumTriggerIntervalInSeconds(value: number);
    resetUserTaskMinimumTriggerIntervalInSeconds(): void;
    get userTaskMinimumTriggerIntervalInSecondsInput(): number | undefined;
    private _userTaskTimeoutMs?;
    get userTaskTimeoutMs(): number;
    set userTaskTimeoutMs(value: number);
    resetUserTaskTimeoutMs(): void;
    get userTaskTimeoutMsInput(): number | undefined;
    private _withManagedAccess?;
    get withManagedAccess(): string;
    set withManagedAccess(value: string);
    resetWithManagedAccess(): void;
    get withManagedAccessInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
