/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretWithBasicAuthenticationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#comment SecretWithBasicAuthentication#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the secret Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#database SecretWithBasicAuthentication#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#id SecretWithBasicAuthentication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the secret, must be unique in your schema. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#name SecretWithBasicAuthentication#name}
    */
    readonly name: string;
    /**
    * Specifies the password value to store in the secret. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#password SecretWithBasicAuthentication#password}
    */
    readonly password: string;
    /**
    * The schema in which to create the secret. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#schema SecretWithBasicAuthentication#schema}
    */
    readonly schema: string;
    /**
    * Specifies the username value to store in the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#username SecretWithBasicAuthentication#username}
    */
    readonly username: string;
}
export interface SecretWithBasicAuthenticationDescribeOutput {
}
export declare function secretWithBasicAuthenticationDescribeOutputToTerraform(struct?: SecretWithBasicAuthenticationDescribeOutput): any;
export declare function secretWithBasicAuthenticationDescribeOutputToHclTerraform(struct?: SecretWithBasicAuthenticationDescribeOutput): any;
export declare class SecretWithBasicAuthenticationDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithBasicAuthenticationDescribeOutput | undefined;
    set internalValue(value: SecretWithBasicAuthenticationDescribeOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get integrationName(): string;
    get name(): string;
    get oauthAccessTokenExpiryTime(): string;
    get oauthRefreshTokenExpiryTime(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get schemaName(): string;
    get secretType(): string;
    get username(): string;
}
export declare class SecretWithBasicAuthenticationDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithBasicAuthenticationDescribeOutputOutputReference;
}
export interface SecretWithBasicAuthenticationShowOutput {
}
export declare function secretWithBasicAuthenticationShowOutputToTerraform(struct?: SecretWithBasicAuthenticationShowOutput): any;
export declare function secretWithBasicAuthenticationShowOutputToHclTerraform(struct?: SecretWithBasicAuthenticationShowOutput): any;
export declare class SecretWithBasicAuthenticationShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithBasicAuthenticationShowOutput | undefined;
    set internalValue(value: SecretWithBasicAuthenticationShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get secretType(): string;
}
export declare class SecretWithBasicAuthenticationShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithBasicAuthenticationShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication snowflake_secret_with_basic_authentication}
*/
export declare class SecretWithBasicAuthentication extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secret_with_basic_authentication";
    /**
    * Generates CDKTF code for importing a SecretWithBasicAuthentication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecretWithBasicAuthentication to import
    * @param importFromId The id of the existing SecretWithBasicAuthentication that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecretWithBasicAuthentication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.98.0/docs/resources/secret_with_basic_authentication snowflake_secret_with_basic_authentication} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretWithBasicAuthenticationConfig
    */
    constructor(scope: Construct, id: string, config: SecretWithBasicAuthenticationConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): SecretWithBasicAuthenticationDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    get passwordInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    get secretType(): string;
    private _showOutput;
    get showOutput(): SecretWithBasicAuthenticationShowOutputList;
    private _username?;
    get username(): string;
    set username(value: string);
    get usernameInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
